/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.VersionHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.jna.Struct;
import oshi.software.common.AbstractInternetProtocolStats;
import oshi.software.os.InternetProtocolStats;
import oshi.util.ParseUtil;

@ThreadSafe
public class WindowsInternetProtocolStats
extends AbstractInternetProtocolStats {
    private static final IPHlpAPI IPHLP = IPHlpAPI.INSTANCE;
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        try (Struct.CloseableMibTcpStats closeableMibTcpStats = new Struct.CloseableMibTcpStats();){
            IPHLP.GetTcpStatisticsEx(closeableMibTcpStats, 2);
            InternetProtocolStats.TcpStats tcpStats = new InternetProtocolStats.TcpStats(closeableMibTcpStats.dwCurrEstab, closeableMibTcpStats.dwActiveOpens, closeableMibTcpStats.dwPassiveOpens, closeableMibTcpStats.dwAttemptFails, closeableMibTcpStats.dwEstabResets, closeableMibTcpStats.dwOutSegs, closeableMibTcpStats.dwInSegs, closeableMibTcpStats.dwRetransSegs, closeableMibTcpStats.dwInErrs, closeableMibTcpStats.dwOutRsts);
            return tcpStats;
        }
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        try (Struct.CloseableMibTcpStats closeableMibTcpStats = new Struct.CloseableMibTcpStats();){
            IPHLP.GetTcpStatisticsEx(closeableMibTcpStats, 23);
            InternetProtocolStats.TcpStats tcpStats = new InternetProtocolStats.TcpStats(closeableMibTcpStats.dwCurrEstab, closeableMibTcpStats.dwActiveOpens, closeableMibTcpStats.dwPassiveOpens, closeableMibTcpStats.dwAttemptFails, closeableMibTcpStats.dwEstabResets, closeableMibTcpStats.dwOutSegs, closeableMibTcpStats.dwInSegs, closeableMibTcpStats.dwRetransSegs, closeableMibTcpStats.dwInErrs, closeableMibTcpStats.dwOutRsts);
            return tcpStats;
        }
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        try (Struct.CloseableMibUdpStats closeableMibUdpStats = new Struct.CloseableMibUdpStats();){
            IPHLP.GetUdpStatisticsEx(closeableMibUdpStats, 2);
            InternetProtocolStats.UdpStats udpStats = new InternetProtocolStats.UdpStats(closeableMibUdpStats.dwOutDatagrams, closeableMibUdpStats.dwInDatagrams, closeableMibUdpStats.dwNoPorts, closeableMibUdpStats.dwInErrors);
            return udpStats;
        }
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        try (Struct.CloseableMibUdpStats closeableMibUdpStats = new Struct.CloseableMibUdpStats();){
            IPHLP.GetUdpStatisticsEx(closeableMibUdpStats, 23);
            InternetProtocolStats.UdpStats udpStats = new InternetProtocolStats.UdpStats(closeableMibUdpStats.dwOutDatagrams, closeableMibUdpStats.dwInDatagrams, closeableMibUdpStats.dwNoPorts, closeableMibUdpStats.dwInErrors);
            return udpStats;
        }
    }

    @Override
    public List<InternetProtocolStats.IPConnection> getConnections() {
        if (IS_VISTA_OR_GREATER) {
            ArrayList<InternetProtocolStats.IPConnection> arrayList = new ArrayList<InternetProtocolStats.IPConnection>();
            arrayList.addAll(WindowsInternetProtocolStats.queryTCPv4Connections());
            arrayList.addAll(WindowsInternetProtocolStats.queryTCPv6Connections());
            arrayList.addAll(WindowsInternetProtocolStats.queryUDPv4Connections());
            arrayList.addAll(WindowsInternetProtocolStats.queryUDPv6Connections());
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static List<InternetProtocolStats.IPConnection> queryTCPv4Connections() {
        ArrayList<InternetProtocolStats.IPConnection> arrayList = new ArrayList<InternetProtocolStats.IPConnection>();
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
            int n = IPHLP.GetExtendedTcpTable(null, closeableIntByReference, false, 2, 5, 0);
            int n2 = closeableIntByReference.getValue();
            Memory memory = new Memory(n2);
            do {
                if ((n = IPHLP.GetExtendedTcpTable(memory, closeableIntByReference, false, 2, 5, 0)) != 122) continue;
                n2 = closeableIntByReference.getValue();
                memory.close();
                memory = new Memory(n2);
            } while (n == 122);
            IPHlpAPI.MIB_TCPTABLE_OWNER_PID mIB_TCPTABLE_OWNER_PID = new IPHlpAPI.MIB_TCPTABLE_OWNER_PID(memory);
            for (int i = 0; i < mIB_TCPTABLE_OWNER_PID.dwNumEntries; ++i) {
                IPHlpAPI.MIB_TCPROW_OWNER_PID mIB_TCPROW_OWNER_PID = mIB_TCPTABLE_OWNER_PID.table[i];
                arrayList.add(new InternetProtocolStats.IPConnection("tcp4", ParseUtil.parseIntToIP(mIB_TCPROW_OWNER_PID.dwLocalAddr), ParseUtil.bigEndian16ToLittleEndian(mIB_TCPROW_OWNER_PID.dwLocalPort), ParseUtil.parseIntToIP(mIB_TCPROW_OWNER_PID.dwRemoteAddr), ParseUtil.bigEndian16ToLittleEndian(mIB_TCPROW_OWNER_PID.dwRemotePort), WindowsInternetProtocolStats.stateLookup(mIB_TCPROW_OWNER_PID.dwState), 0, 0, mIB_TCPROW_OWNER_PID.dwOwningPid));
            }
            memory.close();
        }
        return arrayList;
    }

    private static List<InternetProtocolStats.IPConnection> queryTCPv6Connections() {
        ArrayList<InternetProtocolStats.IPConnection> arrayList = new ArrayList<InternetProtocolStats.IPConnection>();
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
            int n = IPHLP.GetExtendedTcpTable(null, closeableIntByReference, false, 23, 5, 0);
            int n2 = closeableIntByReference.getValue();
            Memory memory = new Memory(n2);
            do {
                if ((n = IPHLP.GetExtendedTcpTable(memory, closeableIntByReference, false, 23, 5, 0)) != 122) continue;
                n2 = closeableIntByReference.getValue();
                memory.close();
                memory = new Memory(n2);
            } while (n == 122);
            IPHlpAPI.MIB_TCP6TABLE_OWNER_PID mIB_TCP6TABLE_OWNER_PID = new IPHlpAPI.MIB_TCP6TABLE_OWNER_PID(memory);
            for (int i = 0; i < mIB_TCP6TABLE_OWNER_PID.dwNumEntries; ++i) {
                IPHlpAPI.MIB_TCP6ROW_OWNER_PID mIB_TCP6ROW_OWNER_PID = mIB_TCP6TABLE_OWNER_PID.table[i];
                arrayList.add(new InternetProtocolStats.IPConnection("tcp6", mIB_TCP6ROW_OWNER_PID.LocalAddr, ParseUtil.bigEndian16ToLittleEndian(mIB_TCP6ROW_OWNER_PID.dwLocalPort), mIB_TCP6ROW_OWNER_PID.RemoteAddr, ParseUtil.bigEndian16ToLittleEndian(mIB_TCP6ROW_OWNER_PID.dwRemotePort), WindowsInternetProtocolStats.stateLookup(mIB_TCP6ROW_OWNER_PID.State), 0, 0, mIB_TCP6ROW_OWNER_PID.dwOwningPid));
            }
            memory.close();
        }
        return arrayList;
    }

    private static List<InternetProtocolStats.IPConnection> queryUDPv4Connections() {
        ArrayList<InternetProtocolStats.IPConnection> arrayList = new ArrayList<InternetProtocolStats.IPConnection>();
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
            int n = IPHLP.GetExtendedUdpTable(null, closeableIntByReference, false, 2, 1, 0);
            int n2 = closeableIntByReference.getValue();
            Memory memory = new Memory(n2);
            do {
                if ((n = IPHLP.GetExtendedUdpTable(memory, closeableIntByReference, false, 2, 1, 0)) != 122) continue;
                n2 = closeableIntByReference.getValue();
                memory.close();
                memory = new Memory(n2);
            } while (n == 122);
            IPHlpAPI.MIB_UDPTABLE_OWNER_PID mIB_UDPTABLE_OWNER_PID = new IPHlpAPI.MIB_UDPTABLE_OWNER_PID(memory);
            for (int i = 0; i < mIB_UDPTABLE_OWNER_PID.dwNumEntries; ++i) {
                IPHlpAPI.MIB_UDPROW_OWNER_PID mIB_UDPROW_OWNER_PID = mIB_UDPTABLE_OWNER_PID.table[i];
                arrayList.add(new InternetProtocolStats.IPConnection("udp4", ParseUtil.parseIntToIP(mIB_UDPROW_OWNER_PID.dwLocalAddr), ParseUtil.bigEndian16ToLittleEndian(mIB_UDPROW_OWNER_PID.dwLocalPort), new byte[0], 0, InternetProtocolStats.TcpState.NONE, 0, 0, mIB_UDPROW_OWNER_PID.dwOwningPid));
            }
            memory.close();
        }
        return arrayList;
    }

    private static List<InternetProtocolStats.IPConnection> queryUDPv6Connections() {
        ArrayList<InternetProtocolStats.IPConnection> arrayList = new ArrayList<InternetProtocolStats.IPConnection>();
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();){
            int n = IPHLP.GetExtendedUdpTable(null, closeableIntByReference, false, 23, 1, 0);
            int n2 = closeableIntByReference.getValue();
            Memory memory = new Memory(n2);
            do {
                if ((n = IPHLP.GetExtendedUdpTable(memory, closeableIntByReference, false, 23, 1, 0)) != 122) continue;
                n2 = closeableIntByReference.getValue();
                memory.close();
                memory = new Memory(n2);
            } while (n == 122);
            IPHlpAPI.MIB_UDP6TABLE_OWNER_PID mIB_UDP6TABLE_OWNER_PID = new IPHlpAPI.MIB_UDP6TABLE_OWNER_PID(memory);
            for (int i = 0; i < mIB_UDP6TABLE_OWNER_PID.dwNumEntries; ++i) {
                IPHlpAPI.MIB_UDP6ROW_OWNER_PID mIB_UDP6ROW_OWNER_PID = mIB_UDP6TABLE_OWNER_PID.table[i];
                arrayList.add(new InternetProtocolStats.IPConnection("udp6", mIB_UDP6ROW_OWNER_PID.ucLocalAddr, ParseUtil.bigEndian16ToLittleEndian(mIB_UDP6ROW_OWNER_PID.dwLocalPort), new byte[0], 0, InternetProtocolStats.TcpState.NONE, 0, 0, mIB_UDP6ROW_OWNER_PID.dwOwningPid));
            }
        }
        return arrayList;
    }

    private static InternetProtocolStats.TcpState stateLookup(int n) {
        switch (n) {
            case 1: 
            case 12: {
                return InternetProtocolStats.TcpState.CLOSED;
            }
            case 2: {
                return InternetProtocolStats.TcpState.LISTEN;
            }
            case 3: {
                return InternetProtocolStats.TcpState.SYN_SENT;
            }
            case 4: {
                return InternetProtocolStats.TcpState.SYN_RECV;
            }
            case 5: {
                return InternetProtocolStats.TcpState.ESTABLISHED;
            }
            case 6: {
                return InternetProtocolStats.TcpState.FIN_WAIT_1;
            }
            case 7: {
                return InternetProtocolStats.TcpState.FIN_WAIT_2;
            }
            case 8: {
                return InternetProtocolStats.TcpState.CLOSE_WAIT;
            }
            case 9: {
                return InternetProtocolStats.TcpState.CLOSING;
            }
            case 10: {
                return InternetProtocolStats.TcpState.LAST_ACK;
            }
            case 11: {
                return InternetProtocolStats.TcpState.TIME_WAIT;
            }
        }
        return InternetProtocolStats.TcpState.UNKNOWN;
    }
}

