/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.openbsd;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class OpenBsdPowerSource
extends AbstractPowerSource {
    public OpenBsdPowerSource(String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, PowerSource.CapacityUnits capacityUnits, int n, int n2, int n3, int n4, String string3, LocalDate localDate, String string4, String string5, double d7) {
        super(string, string2, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string3, localDate, string4, string5, d7);
    }

    public static List<PowerSource> getPowerSources() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String object : ExecutingCommand.runNative("systat -ab sensors")) {
            if (!object.contains(".amphour") && !object.contains(".watthour")) continue;
            int string = object.indexOf(46);
            hashSet.add(object.substring(0, string));
        }
        ArrayList arrayList = new ArrayList();
        for (String string : hashSet) {
            arrayList.add(OpenBsdPowerSource.getPowerSource(string));
        }
        return arrayList;
    }

    private static OpenBsdPowerSource getPowerSource(String string) {
        int n;
        Object object;
        String string2 = string.startsWith("acpi") ? string.substring(4) : string;
        double d = 1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = -1.0;
        double d5 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        PowerSource.CapacityUnits capacityUnits = PowerSource.CapacityUnits.RELATIVE;
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        int n5 = -1;
        LocalDate localDate = null;
        double d6 = 0.0;
        for (String string3 : ExecutingCommand.runNative("systat -ab sensors")) {
            object = ParseUtil.whitespaces.split(string3);
            if (((String[])object).length <= 1 || !object[0].startsWith(string)) continue;
            if (object[0].contains("volt0") || object[0].contains("volt") && string3.contains("current")) {
                d4 = ParseUtil.parseDoubleOrDefault(object[1], -1.0);
                continue;
            }
            if (object[0].contains("current0")) {
                d5 = ParseUtil.parseDoubleOrDefault(object[1], 0.0);
                continue;
            }
            if (object[0].contains("temp0")) {
                d6 = ParseUtil.parseDoubleOrDefault(object[1], 0.0);
                continue;
            }
            if (!object[0].contains("watthour") && !object[0].contains("amphour")) continue;
            PowerSource.CapacityUnits capacityUnits2 = capacityUnits = object[0].contains("watthour") ? PowerSource.CapacityUnits.MWH : PowerSource.CapacityUnits.MAH;
            if (string3.contains("remaining")) {
                n2 = (int)(1000.0 * ParseUtil.parseDoubleOrDefault(object[1], 0.0));
                continue;
            }
            if (string3.contains("full")) {
                n3 = (int)(1000.0 * ParseUtil.parseDoubleOrDefault(object[1], 0.0));
                continue;
            }
            if (!string3.contains("new") && !string3.contains("design")) continue;
            n4 = (int)(1000.0 * ParseUtil.parseDoubleOrDefault(object[1], 0.0));
        }
        int n6 = ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("apm -b"), 255);
        if (n6 < 4) {
            bl = true;
            if (n6 == 3) {
                bl2 = true;
            } else {
                int n7 = ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("apm -m"), -1);
                d2 = n7 < 0 ? -1.0 : 60.0 * (double)n7;
                bl3 = true;
            }
        }
        if ((n = ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("apm -l"), -1)) > 0) {
            d = (double)n / 100.0;
        }
        if (n3 < n4 && n3 < n2) {
            n3 = n4;
        } else if (n4 < n3 && n4 < n2) {
            n4 = n3;
        }
        object = "unknown";
        String string4 = "unknown";
        String string5 = "unknown";
        String string6 = "unknown";
        double d7 = d2;
        if (d4 > 0.0) {
            if (d5 > 0.0 && d3 == 0.0) {
                d3 = d5 * d4;
            } else if (d5 == 0.0 && d3 > 0.0) {
                d5 = d3 / d4;
            }
        }
        return new OpenBsdPowerSource(string2, (String)object, d, d2, d7, d3, d4, d5, bl, bl2, bl3, capacityUnits, n2, n3, n4, n5, string5, localDate, string6, string4, d6);
    }
}

