/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractSensors;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.GlobalConfig;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.SysPath;

@ThreadSafe
final class LinuxSensors
extends AbstractSensors {
    public static final String OSHI_HWMON_NAME_PRIORITY = "oshi.os.linux.sensors.hwmon.names";
    public static final String OSHI_THERMAL_ZONE_TYPE_PRIORITY = "oshi.os.linux.sensors.cpuTemperature.types";
    private static final List<String> HWMON_NAME_PRIORITY = Stream.of(GlobalConfig.get("oshi.os.linux.sensors.hwmon.names", "coretemp,k10temp,zenpower,k8temp,via-cputemp,acpitz").split(",")).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    private static final List<String> THERMAL_ZONE_TYPE_PRIORITY = Stream.of(GlobalConfig.get("oshi.os.linux.sensors.cpuTemperature.types", "cpu-thermal,x86_pkg_temp").split(",")).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    private static final String TYPE = "type";
    private static final String NAME = "/name";
    private static final String TEMP = "temp";
    private static final String FAN = "fan";
    private static final String VOLTAGE = "in";
    private static final String INPUT_SUFFIX = "_input";
    private static final Pattern TEMP_INPUT_PATTERN = Pattern.compile("^temp\\d+_input$");
    private static final String HWMON = "hwmon";
    private static final String HWMON_PATH = SysPath.HWMON + "hwmon";
    private static final String THERMAL_ZONE = "thermal_zone";
    private static final String THERMAL_ZONE_PATH = SysPath.THERMAL + "thermal_zone";
    private static final boolean IS_PI = LinuxSensors.queryCpuTemperatureFromVcGenCmd() > 0.0;
    private final Map<String, String> sensorsMap = new HashMap<String, String>();

    LinuxSensors() {
        if (!IS_PI) {
            this.populateSensorsMapFromHwmon();
            if (!this.sensorsMap.containsKey(TEMP)) {
                this.populateSensorsMapFromThermalZone();
            }
        }
    }

    private void populateSensorsMapFromHwmon() {
        String string2 = null;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (Paths.get(HWMON_PATH + n2, new String[0]).toFile().isDirectory()) {
            Object object;
            int n3;
            String string3 = HWMON_PATH + n2;
            String string4 = FileUtil.getStringFromFile(string3 + NAME).trim();
            File file2 = new File(string3);
            File[] fileArray = file2.listFiles((file, string) -> TEMP_INPUT_PATTERN.matcher(string).matches());
            if (fileArray != null && fileArray.length > 0 && (n3 = HWMON_NAME_PRIORITY.indexOf(string4)) >= 0 && n3 < n) {
                File[] fileArray2 = fileArray;
                int n4 = fileArray2.length;
                for (int i = 0; i < n4; ++i) {
                    object = fileArray2[i];
                    long l = FileUtil.getLongFromFile(((File)object).getPath());
                    if (l <= 0L) continue;
                    n = n3;
                    string2 = string3;
                    break;
                }
            }
            for (String string5 : new String[]{FAN, VOLTAGE}) {
                object = string5;
                this.getSensorFilesFromPath(string3, string5, arg_0 -> LinuxSensors.lambda$populateSensorsMapFromHwmon$3((String)object, arg_0));
            }
            ++n2;
        }
        if (string2 != null) {
            this.sensorsMap.put(TEMP, string2 + "/temp");
        }
    }

    private void populateSensorsMapFromThermalZone() {
        this.getSensorFilesFromPath(THERMAL_ZONE_PATH, TEMP, file -> file.getName().equals(TYPE) || file.getName().equals(TEMP), fileArray -> Stream.of(fileArray).filter(file -> TYPE.equals(file.getName())).findFirst().map(File::getPath).map(FileUtil::getStringFromFile).map(THERMAL_ZONE_TYPE_PRIORITY::indexOf).filter(n -> n >= 0).orElse(THERMAL_ZONE_TYPE_PRIORITY.size()));
    }

    private void getSensorFilesFromPath(String string, String string2, FileFilter fileFilter) {
        this.getSensorFilesFromPath(string, string2, fileFilter, fileArray -> 0);
    }

    private void getSensorFilesFromPath(String string, String string2, FileFilter fileFilter, ToIntFunction<File[]> toIntFunction) {
        String string3 = null;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (Paths.get(string + n2, new String[0]).toFile().isDirectory()) {
            int n3;
            String string4 = string + n2;
            File file = new File(string4);
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray != null && fileArray.length > 0 && (n3 = toIntFunction.applyAsInt(fileArray)) < n) {
                n = n3;
                string3 = string4;
            }
            ++n2;
        }
        if (string3 != null) {
            this.sensorsMap.put(string2, String.format(Locale.ROOT, "%s/%s", string3, string2));
        }
    }

    @Override
    public double queryCpuTemperature() {
        if (IS_PI) {
            return LinuxSensors.queryCpuTemperatureFromVcGenCmd();
        }
        String string = this.sensorsMap.get(TEMP);
        if (string != null) {
            long l = 0L;
            if (string.contains(HWMON)) {
                l = FileUtil.getLongFromFile(String.format(Locale.ROOT, "%s1%s", string, INPUT_SUFFIX));
                if (l > 0L) {
                    return (double)l / 1000.0;
                }
                long l2 = 0L;
                int n = 0;
                for (int i = 2; i <= 6; ++i) {
                    l = FileUtil.getLongFromFile(String.format(Locale.ROOT, "%s%d%s", string, i, INPUT_SUFFIX));
                    if (l <= 0L) continue;
                    l2 += l;
                    ++n;
                }
                if (n > 0) {
                    return (double)l2 / ((double)n * 1000.0);
                }
            } else if (string.contains(THERMAL_ZONE) && (l = FileUtil.getLongFromFile(string)) > 0L) {
                return (double)l / 1000.0;
            }
        }
        return 0.0;
    }

    private static double queryCpuTemperatureFromVcGenCmd() {
        String string = ExecutingCommand.getFirstAnswer("vcgencmd measure_temp");
        if (string.startsWith("temp=")) {
            return ParseUtil.parseDoubleOrDefault(string.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }

    @Override
    public int[] queryFanSpeeds() {
        String string;
        if (!IS_PI && (string = this.sensorsMap.get(FAN)) != null) {
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 1;
            while (new File((String)(object = String.format(Locale.ROOT, "%s%d%s", string, n, INPUT_SUFFIX))).exists()) {
                arrayList.add(FileUtil.getIntFromFile((String)object));
                ++n;
            }
            object = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            return object;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        if (IS_PI) {
            return LinuxSensors.queryCpuVoltageFromVcGenCmd();
        }
        String string = this.sensorsMap.get(VOLTAGE);
        if (string != null) {
            return (double)FileUtil.getIntFromFile(String.format(Locale.ROOT, "%s1%s", string, INPUT_SUFFIX)) / 1000.0;
        }
        return 0.0;
    }

    private static double queryCpuVoltageFromVcGenCmd() {
        String string = ExecutingCommand.getFirstAnswer("vcgencmd measure_volts core");
        if (string.startsWith("volt=")) {
            return ParseUtil.parseDoubleOrDefault(string.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }

    private static /* synthetic */ boolean lambda$populateSensorsMapFromHwmon$3(String string, File file) {
        try {
            return file.getName().startsWith(string) && file.getName().endsWith(INPUT_SUFFIX) && FileUtil.getIntFromFile(file.getCanonicalPath()) > 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

