/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.tab;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.mixin.TabNavigationBarAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ScrollableNavigationBar
extends TabNavigationBar {
    private static final int NAVBAR_MARGIN = 28;
    private static final Font font = Minecraft.m_91087_().f_91062_;
    private int scrollOffset;
    private int maxScrollOffset;
    private final TabNavigationBarAccessor accessor = (TabNavigationBarAccessor)((Object)this);

    public ScrollableNavigationBar(int width, TabManager tabManager, Iterable<? extends Tab> tabs) {
        super(width, tabManager, (Iterable)ImmutableList.copyOf(tabs));
        for (TabButton tabButton : this.accessor.yacl$getTabButtons()) {
            Tab tab = tabButton.m_274356_();
            if (!(tab instanceof TabExt)) continue;
            TabExt tab2 = (TabExt)tab;
            tabButton.m_257544_(tab2.getTooltip());
        }
    }

    public void m_267766_() {
        ImmutableList<TabButton> tabButtons = this.accessor.yacl$getTabButtons();
        int noScrollWidth = this.accessor.yacl$getWidth() - 56;
        int allTabsWidth = 0;
        for (TabButton tabButton : tabButtons) {
            int buttonWidth = font.m_92852_((FormattedText)tabButton.m_6035_()) + 20;
            allTabsWidth += buttonWidth;
            tabButton.m_93674_(buttonWidth);
        }
        if (allTabsWidth < noScrollWidth) {
            int equalWidth = noScrollWidth / tabButtons.size();
            List<TabButton> smallTabs = tabButtons.stream().filter(btn -> btn.m_5711_() < equalWidth).toList();
            List<TabButton> bigTabs = tabButtons.stream().filter(btn -> btn.m_5711_() >= equalWidth).toList();
            int leftoverWidth = noScrollWidth - bigTabs.stream().mapToInt(AbstractWidget::m_5711_).sum();
            int equalWidthForSmallTabs = leftoverWidth / smallTabs.size();
            for (TabButton tabButton : smallTabs) {
                tabButton.m_93674_(equalWidthForSmallTabs);
            }
            allTabsWidth = noScrollWidth;
        }
        GridLayout layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.m_264036_();
        layout.m_253211_(0);
        this.scrollOffset = 0;
        layout.m_252865_(Math.max((this.accessor.yacl$getWidth() - allTabsWidth) / 2, 28));
        this.maxScrollOffset = Math.max(0, allTabsWidth - noScrollWidth);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280168_().m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double vertical) {
        this.setScrollOffset(this.scrollOffset - (int)(vertical * 15.0));
        return true;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseY <= 24.0;
    }

    public void setScrollOffset(int scrollOffset) {
        GridLayout layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.m_252865_(layout.m_252754_() + this.scrollOffset);
        this.scrollOffset = Mth.m_14045_((int)scrollOffset, (int)0, (int)this.maxScrollOffset);
        layout.m_252865_(layout.m_252754_() - this.scrollOffset);
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void m_7522_(@Nullable GuiEventListener child) {
        super.m_7522_(child);
        if (child instanceof TabButton) {
            TabButton tabButton = (TabButton)child;
            this.ensureVisible(tabButton);
        }
    }

    protected void ensureVisible(TabButton tabButton) {
        if (tabButton.m_252754_() < 28) {
            this.setScrollOffset(this.scrollOffset - (28 - tabButton.m_252754_()));
        } else if (tabButton.m_252754_() + tabButton.m_5711_() > this.accessor.yacl$getWidth() - 28) {
            this.setScrollOffset(this.scrollOffset + (tabButton.m_252754_() + tabButton.m_5711_() - (this.accessor.yacl$getWidth() - 28)));
        }
    }

    public ImmutableList<Tab> getTabs() {
        return this.accessor.yacl$getTabs();
    }

    public TabManager getTabManager() {
        return this.accessor.yacl$getTabManager();
    }
}

