/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.utils;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.EffectSpawningRule;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.particle.ModParticles;
import com.leclowndu93150.wakes.particle.WithOwnerParticleType;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WakesUtils {
    public static void placeFallSplash(Entity entity) {
        WakeHandler wakeHandler = WakeHandler.getInstance(entity.m_9236_()).orElse(null);
        if (wakeHandler == null) {
            return;
        }
        for (WakeNode node : WakeNode.Factory.splashNodes(entity, (int)Math.floor(((ProducesWake)entity).wakes$wakeHeight().floatValue()))) {
            wakeHandler.insert(node);
        }
    }

    public static void spawnPaddleSplashCloudParticle(Level world, Boat boat) {
        for (int i = 0; i < 2; ++i) {
            double phase;
            if (!boat.m_38313_(i) || !(0.19634954631328583 <= (phase = (double)boat.f_38263_[i] % (Math.PI * 2))) || !(phase <= 1.178097277879715)) continue;
            Vec3 rot = boat.m_20252_(1.0f);
            double x = boat.m_20185_() + (i == 1 ? -rot.f_82481_ : rot.f_82481_);
            double z = boat.m_20189_() + (i == 1 ? rot.f_82479_ : -rot.f_82479_);
            Vec3 pos = new Vec3(x, (double)((ProducesWake)boat).wakes$wakeHeight().floatValue(), z);
            world.m_7106_((ParticleOptions)ModParticles.SPLASH_CLOUD.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnSplashPlane(Level world, Entity owner) {
        WithOwnerParticleType wake = ModParticles.SPLASH_PLANE.get().withOwner(owner);
        Vec3 pos = owner.m_20182_();
        world.m_7106_((ParticleOptions)wake, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
    }

    public static void placeWakeTrail(Entity entity) {
        Vec3 prevPos;
        WakeHandler wakeHandler = WakeHandler.getInstance(entity.m_9236_()).orElse(null);
        if (wakeHandler == null) {
            return;
        }
        ProducesWake producer = (ProducesWake)entity;
        double velocity = producer.wakes$getHorizontalVelocity();
        int y = (int)Math.floor(producer.wakes$wakeHeight().floatValue());
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            for (WakeNode node : WakeNode.Factory.rowingNodes(boat, y)) {
                wakeHandler.insert(node);
            }
            if (((Boolean)WakesConfig.APPEARANCE.spawnParticles.get()).booleanValue()) {
                WakesUtils.spawnPaddleSplashCloudParticle(entity.m_9236_(), boat);
            }
        }
        if ((prevPos = producer.wakes$getPrevPos()) == null) {
            return;
        }
        for (WakeNode node : WakeNode.Factory.thickNodeTrail(prevPos.f_82479_, prevPos.f_82481_, entity.m_20185_(), entity.m_20189_(), y, ((Integer)WakesConfig.GENERAL.initialStrength.get()).intValue(), velocity, entity.m_20205_())) {
            wakeHandler.insert(node);
        }
    }

    public static EffectSpawningRule getEffectRuleFromSource(Entity source) {
        if (source instanceof Boat) {
            Boat boat = (Boat)source;
            List passengers = boat.m_20197_();
            if (passengers.contains(Minecraft.m_91087_().f_91074_)) {
                return (EffectSpawningRule)((Object)WakesConfig.GENERAL.boatSpawning.get());
            }
            if (passengers.stream().anyMatch(Entity::m_142389_)) {
                return ((EffectSpawningRule)((Object)WakesConfig.GENERAL.boatSpawning.get())).mask((EffectSpawningRule)((Object)WakesConfig.GENERAL.otherPlayersSpawning.get()));
            }
            return (EffectSpawningRule)((Object)WakesConfig.GENERAL.boatSpawning.get());
        }
        if (source instanceof Player) {
            Player player = (Player)source;
            if (player.m_5833_()) {
                return EffectSpawningRule.DISABLED;
            }
            if (player instanceof LocalPlayer) {
                return (EffectSpawningRule)((Object)WakesConfig.GENERAL.playerSpawning.get());
            }
            if (player instanceof RemotePlayer) {
                return (EffectSpawningRule)((Object)WakesConfig.GENERAL.otherPlayersSpawning.get());
            }
            return EffectSpawningRule.DISABLED;
        }
        if (source instanceof LivingEntity) {
            return (EffectSpawningRule)((Object)WakesConfig.GENERAL.mobSpawning.get());
        }
        if (source instanceof ItemEntity) {
            return (EffectSpawningRule)((Object)WakesConfig.GENERAL.itemSpawning.get());
        }
        return EffectSpawningRule.DISABLED;
    }

    public static void bresenhamLine(int x1, int y1, int x2, int y2, ArrayList<Long> points) {
        int dy = y2 - y1;
        int dx = x2 - x1;
        if (dx == 0) {
            if (y2 < y1) {
                int temp = y1;
                y1 = y2;
                y2 = temp;
            }
            for (int y = y1; y < y2 + 1; ++y) {
                points.add(WakesUtils.posAsLong(x1, y));
            }
        } else {
            float k = (float)dy / (float)dx;
            int adjust = k >= 0.0f ? 1 : -1;
            int offset = 0;
            if (k <= 1.0f && k >= -1.0f) {
                int delta = Math.abs(dy) * 2;
                int threshold = Math.abs(dx);
                int thresholdInc = Math.abs(dx) * 2;
                int y = y1;
                if (x2 < x1) {
                    int temp = x1;
                    x1 = x2;
                    x2 = temp;
                    y = y2;
                }
                for (int x = x1; x < x2 + 1; ++x) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    y += adjust;
                    threshold += thresholdInc;
                }
            } else {
                int delta = Math.abs(dx) * 2;
                int threshold = Math.abs(dy);
                int thresholdInc = Math.abs(dy) * 2;
                int x = x1;
                if (y2 < y1) {
                    int temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                for (int y = y1; y < y2 + 1; ++y) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    x += adjust;
                    threshold += thresholdInc;
                }
            }
        }
    }

    public static long posAsLong(int x, int y) {
        int xs = x >> 31 & 1;
        int ys = y >> 31 & 1;
        long pos = (long)(x &= Integer.MAX_VALUE) << 32 | (long)(y &= Integer.MAX_VALUE);
        pos ^= ((long)(-xs) ^ pos) & Long.MIN_VALUE;
        pos ^= ((long)(-ys) ^ pos) & 0x80000000L;
        return pos;
    }

    public static int[] longAsPos(long pos) {
        return new int[]{(int)(pos >> 32), (int)pos};
    }

    public static MutableComponent translatable(String ... subKeys) {
        StringBuilder translationKey = new StringBuilder("wakes");
        for (String s : subKeys) {
            translationKey.append(".").append(s);
        }
        return Component.m_237115_((String)translationKey.toString());
    }

    public static int[] abgrInt2rgbaArr(int n) {
        int[] arr = new int[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n2 = i;
                arr[n2] = arr[n2] | (n >> i * 8 + j & 1) << 7 - j;
            }
        }
        return arr;
    }

    public static int rgbaArr2abgrInt(int[] arr) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                n |= (arr[i] >> j & 1) << i * 8 + j;
            }
        }
        return n;
    }

    public static float getFluidLevel(Level world, Entity entityInFluid) {
        AABB box = entityInFluid.m_20191_();
        return WakesUtils.getFluidLevel(world, Mth.m_14107_((double)box.f_82288_), Mth.m_14165_((double)box.f_82291_), Mth.m_14107_((double)box.f_82289_), Mth.m_14165_((double)box.f_82292_), Mth.m_14107_((double)box.f_82290_), Mth.m_14165_((double)box.f_82293_));
    }

    private static float getFluidLevel(Level world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        block0: for (int y = minY; y < maxY; ++y) {
            float f = 0.0f;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    blockPos.m_122178_(x, y, z);
                    FluidState fluidState = world.m_6425_((BlockPos)blockPos);
                    if (fluidState.m_76170_()) {
                        f = Math.max(f, fluidState.m_76155_((BlockGetter)world, (BlockPos)blockPos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockPos.m_123342_() + f;
        }
        return maxY + 1;
    }
}

