/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.event;

import com.leclowndu93150.wakes.WakesClient;
import com.leclowndu93150.wakes.debug.WakesDebugInfo;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WakeWorldTicker {
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            WakesClient.areShadersEnabled = WakesClient.areShadersEnabled();
            WakesDebugInfo.reset();
            WakeHandler.getInstance((Level)clientLevel).ifPresent(WakeHandler::tick);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() != null && event.getEntity().m_9236_() instanceof ClientLevel) {
            WakeHandler.init(event.getEntity().m_9236_());
            ResourceKey fromDimension = event.getFrom();
            if (Minecraft.m_91087_().f_91073_ == null || !Minecraft.m_91087_().f_91073_.m_46472_().equals((Object)fromDimension)) {
                WakeHandler.killDimension((ResourceKey<Level>)fromDimension);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() != null && event.getEntity().m_9236_() instanceof ClientLevel) {
            WakeHandler.init(event.getEntity().m_9236_());
        }
    }
}

