/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.api.VoicechatSocket;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.ConnectionCheckAckPacket;
import de.maxhenkel.voicechat.voice.common.ConnectionCheckPacket;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.Secret;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.ServerCategoryManager;
import de.maxhenkel.voicechat.voice.server.ServerGroupManager;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class Server
extends Thread {
    private final Map<UUID, ClientConnection> connections;
    private final Map<UUID, ClientConnection> unCheckedConnections;
    private final Map<UUID, Secret> secrets;
    private final boolean dedicated;
    private int port;
    private final MinecraftServer server;
    private VoicechatSocket socket;
    private final ProcessThread processThread;
    private final BlockingQueue<RawUdpPacket> packetQueue;
    private final PingManager pingManager;
    private final PlayerStateManager playerStateManager;
    private final ServerGroupManager groupManager;
    private final ServerCategoryManager categoryManager;

    public Server(MinecraftServer server) {
        this.dedicated = server instanceof DedicatedServer;
        if (this.dedicated) {
            int configPort = Voicechat.SERVER_CONFIG.voiceChatPort.get();
            if (configPort < 0) {
                Voicechat.LOGGER.info("Using the Minecraft servers port as voice chat port", new Object[0]);
                this.port = server.m_7010_();
            } else {
                this.port = configPort;
            }
        } else {
            this.port = 0;
        }
        this.server = server;
        this.socket = PluginManager.instance().getSocketImplementation(server);
        this.connections = new ConcurrentHashMap<UUID, ClientConnection>();
        this.unCheckedConnections = new ConcurrentHashMap<UUID, ClientConnection>();
        this.secrets = new ConcurrentHashMap<UUID, Secret>();
        this.packetQueue = new LinkedBlockingQueue<RawUdpPacket>();
        this.pingManager = new PingManager(this);
        this.playerStateManager = new PlayerStateManager(this);
        this.groupManager = new ServerGroupManager(this);
        this.categoryManager = new ServerCategoryManager(this);
        this.setDaemon(true);
        this.setName("VoiceChatServerThread");
        this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
        this.processThread = new ProcessThread();
        this.processThread.start();
    }

    public void onPlayerLoggedIn(ServerPlayer player) {
        this.playerStateManager.onPlayerLoggedIn(player);
    }

    public void onPlayerLoggedOut(ServerPlayer player) {
        this.disconnectClient(player.m_20148_());
        this.playerStateManager.onPlayerLoggedOut(player);
        this.groupManager.onPlayerLoggedOut(player);
    }

    public void onPlayerHide(ServerPlayer visibilityChangedPlayer, ServerPlayer observingPlayer) {
        this.playerStateManager.onPlayerHide(visibilityChangedPlayer, observingPlayer);
    }

    public void onPlayerShow(ServerPlayer visibilityChangedPlayer, ServerPlayer observingPlayer) {
        this.playerStateManager.onPlayerShow(visibilityChangedPlayer, observingPlayer);
    }

    public void onPlayerVoicechatConnect(ServerPlayer player) {
        this.playerStateManager.onPlayerVoicechatConnect(player);
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        this.playerStateManager.onPlayerVoicechatDisconnect(uuid);
    }

    public void onPlayerCompatibilityCheckSucceeded(ServerPlayer player) {
        this.playerStateManager.onPlayerCompatibilityCheckSucceeded(player);
        this.groupManager.onPlayerCompatibilityCheckSucceeded(player);
        this.categoryManager.onPlayerCompatibilityCheckSucceeded(player);
    }

    @Override
    public void run() {
        try {
            String bindAddress = this.getBindAddress();
            try {
                InetAddress.getByName(bindAddress);
            }
            catch (UnknownHostException e) {
                Voicechat.LOGGER.error("Failed to parse bind IP address '{}'", bindAddress, e);
                Voicechat.LOGGER.info("Binding to wildcard IP address", new Object[0]);
                bindAddress = "";
            }
            this.socket.open(this.port, bindAddress);
            if (bindAddress.isEmpty()) {
                Voicechat.LOGGER.info("Voice chat server started at port {}", this.socket.getLocalPort());
            } else {
                Voicechat.LOGGER.info("Voice chat server started at {}:{}", bindAddress, this.socket.getLocalPort());
            }
            while (!this.socket.isClosed()) {
                try {
                    this.packetQueue.add(this.socket.read());
                }
                catch (Exception e) {
                    if (e instanceof SocketException && e.getCause() instanceof AsynchronousCloseException || !Voicechat.debugMode()) continue;
                    Voicechat.LOGGER.error("Failed to read from socket", e);
                }
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Voice chat server error", e);
        }
    }

    private String getBindAddress() {
        if (!this.dedicated) {
            return "";
        }
        String bindAddress = Voicechat.SERVER_CONFIG.voiceChatBindAddress.get();
        if (bindAddress.trim().equals("*")) {
            bindAddress = "";
        } else if (bindAddress.trim().equals("") && this.server instanceof DedicatedServer && !(bindAddress = ((DedicatedServer)this.server).m_7913_().f_139730_).trim().isEmpty()) {
            try {
                InetAddress address = InetAddress.getByName(bindAddress);
                if (address.isLoopbackAddress()) {
                    bindAddress = "";
                } else {
                    Voicechat.LOGGER.info("Using server-ip as bind address: {}", bindAddress);
                }
            }
            catch (Exception e) {
                Voicechat.LOGGER.warn("Invalid server-ip", e);
                bindAddress = "";
            }
        }
        return bindAddress;
    }

    public void changePort(int port) throws Exception {
        VoicechatSocket newSocket = PluginManager.instance().getSocketImplementation(this.server);
        newSocket.open(port, this.getBindAddress());
        VoicechatSocket old = this.socket;
        this.socket = newSocket;
        this.port = port;
        old.close();
        this.connections.clear();
        this.unCheckedConnections.clear();
        this.secrets.clear();
    }

    public Secret getSecret(UUID playerUUID) {
        if (this.hasSecret(playerUUID)) {
            return this.secrets.get(playerUUID);
        }
        Secret secret = Secret.generateNewRandomSecret();
        this.secrets.put(playerUUID, secret);
        return secret;
    }

    @Nullable
    public Secret generateNewSecret(UUID playerUUID) {
        if (this.hasSecret(playerUUID)) {
            return null;
        }
        return this.getSecret(playerUUID);
    }

    public boolean hasSecret(UUID playerUUID) {
        return this.secrets.containsKey(playerUUID);
    }

    public void disconnectClient(UUID playerUUID) {
        this.connections.remove(playerUUID);
        this.unCheckedConnections.remove(playerUUID);
        this.secrets.remove(playerUUID);
        PluginManager.instance().onPlayerDisconnected(playerUUID);
    }

    public void close() {
        this.socket.close();
        this.processThread.close();
        PluginManager.instance().onServerStopped();
    }

    public boolean isClosed() {
        return !this.processThread.running;
    }

    public void onMicPacket(UUID playerUuid, MicPacket packet) {
        ServerPlayer player = this.server.m_6846_().m_11259_(playerUuid);
        if (player == null) {
            return;
        }
        if (!PermissionManager.INSTANCE.SPEAK_PERMISSION.hasPermission(player)) {
            CooldownTimer.run("no-speak-" + playerUuid, 30000L, () -> player.m_5661_((Component)Component.m_237115_((String)"message.voicechat.no_speak_permission"), true));
            return;
        }
        PlayerState state = this.playerStateManager.getState(player.m_20148_());
        if (state == null) {
            return;
        }
        if (!PluginManager.instance().onMicPacket(player, state, packet)) {
            this.processMicPacket(player, state, packet);
        }
    }

    private void processMicPacket(ServerPlayer player, PlayerState state, MicPacket packet) {
        if (state.hasGroup()) {
            Group group = this.groupManager.getGroup(state.getGroup());
            this.processGroupPacket(state, player, packet);
            if (group == null || group.isOpen()) {
                this.processProximityPacket(state, player, packet);
            }
            return;
        }
        this.processProximityPacket(state, player, packet);
    }

    private void processGroupPacket(PlayerState senderState, ServerPlayer sender, MicPacket packet) {
        UUID groupId = senderState.getGroup();
        if (groupId == null) {
            return;
        }
        GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
        for (PlayerState state : this.playerStateManager.getStates()) {
            ServerPlayer p;
            if (!groupId.equals(state.getGroup()) || senderState.getUuid().equals(state.getUuid()) || (p = this.server.m_6846_().m_11259_(state.getUuid())) == null) continue;
            ClientConnection connection = this.getConnection(state.getUuid());
            this.sendSoundPacket(sender, senderState, p, state, connection, groupSoundPacket, "group");
        }
    }

    private void processProximityPacket(PlayerState senderState, ServerPlayer sender, MicPacket packet) {
        UUID groupId = senderState.getGroup();
        float distance = packet.isWhispering() ? Voicechat.SERVER_CONFIG.whisperDistance.get().floatValue() : Utils.getDefaultDistanceServer();
        distance = PluginManager.instance().getDistance(sender, senderState, packet, distance);
        SoundPacket soundPacket = null;
        String source = null;
        if (sender.m_5833_()) {
            ServerPlayer spectatingPlayer;
            Entity camera;
            if (Voicechat.SERVER_CONFIG.spectatorPlayerPossession.get().booleanValue() && (camera = sender.m_8954_()) instanceof ServerPlayer && (spectatingPlayer = (ServerPlayer)camera) != sender) {
                PlayerState receiverState = this.playerStateManager.getState(spectatingPlayer.m_20148_());
                if (receiverState == null) {
                    return;
                }
                GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
                ClientConnection connection = this.getConnection(receiverState.getUuid());
                this.sendSoundPacket(sender, senderState, spectatingPlayer, receiverState, connection, groupSoundPacket, "spectator");
                return;
            }
            if (Voicechat.SERVER_CONFIG.spectatorInteraction.get().booleanValue()) {
                soundPacket = new LocationSoundPacket(sender.m_20148_(), sender.m_20148_(), sender.m_146892_(), packet.getData(), packet.getSequenceNumber(), distance, null);
                source = "spectator";
            }
        }
        if (soundPacket == null) {
            soundPacket = new PlayerSoundPacket(sender.m_20148_(), sender.m_20148_(), packet.getData(), packet.getSequenceNumber(), packet.isWhispering(), distance, null);
            source = "proximity";
        }
        this.broadcast(ServerWorldUtils.getPlayersInRange(sender.m_284548_(), sender.m_20182_(), this.getBroadcastRange(distance), p -> !p.m_20148_().equals(sender.m_20148_())), soundPacket, sender, senderState, groupId, source);
    }

    public void sendSoundPacket(@Nullable ServerPlayer sender, @Nullable PlayerState senderState, ServerPlayer receiver, PlayerState receiverState, @Nullable ClientConnection connection, SoundPacket<?> soundPacket, String source) {
        PluginManager.instance().onListenerAudio(receiver.m_20148_(), soundPacket);
        if (connection == null) {
            return;
        }
        if (receiverState.isDisabled() || receiverState.isDisconnected()) {
            return;
        }
        if (PluginManager.instance().onSoundPacket(sender, senderState, receiver, receiverState, soundPacket, source)) {
            return;
        }
        if (!PermissionManager.INSTANCE.LISTEN_PERMISSION.hasPermission(receiver)) {
            CooldownTimer.run(String.format("no-listen-%s", receiver.m_20148_()), 30000L, () -> receiver.m_5661_((Component)Component.m_237115_((String)"message.voicechat.no_listen_permission"), true));
            return;
        }
        this.sendPacket(soundPacket, connection);
    }

    public double getBroadcastRange(float minRange) {
        double broadcastRange = Voicechat.SERVER_CONFIG.broadcastRange.get();
        if (broadcastRange < 0.0) {
            broadcastRange = Voicechat.SERVER_CONFIG.voiceChatDistance.get() + 1.0;
        }
        return Math.max(broadcastRange, (double)minRange);
    }

    public void broadcast(Collection<ServerPlayer> players, SoundPacket<?> packet, @Nullable ServerPlayer sender, @Nullable PlayerState senderState, @Nullable UUID groupId, String source) {
        for (ServerPlayer player : players) {
            PlayerState state = this.playerStateManager.getState(player.m_20148_());
            if (state == null || state.hasGroup() && state.getGroup().equals(groupId)) continue;
            Group receiverGroup = null;
            if (state.hasGroup()) {
                receiverGroup = this.groupManager.getGroup(state.getGroup());
            }
            if (receiverGroup != null && receiverGroup.isIsolated()) continue;
            ClientConnection connection = this.getConnection(state.getUuid());
            this.sendSoundPacket(sender, senderState, player, state, connection, packet, source);
        }
    }

    private void sendKeepAlives() {
        long timestamp = System.currentTimeMillis();
        this.connections.values().removeIf(connection -> {
            if (timestamp - connection.getLastKeepAliveResponse() >= (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue() * 10L) {
                this.secrets.remove(connection.getPlayerUUID());
                Voicechat.LOGGER.info("Player {} timed out", connection.getPlayerUUID());
                ServerPlayer player = this.server.m_6846_().m_11259_(connection.getPlayerUUID());
                if (player != null) {
                    Voicechat.LOGGER.info("Reconnecting player {}", player.m_7755_().getString());
                    Voicechat.SERVER.initializePlayerConnection(player);
                } else {
                    Voicechat.LOGGER.warn("Reconnecting player {} failed (Could not find player)", connection.getPlayerUUID());
                }
                CommonCompatibilityManager.INSTANCE.emitServerVoiceChatDisconnectedEvent(connection.getPlayerUUID());
                PluginManager.instance().onPlayerDisconnected(connection.getPlayerUUID());
                return true;
            }
            return false;
        });
        for (ClientConnection connection2 : this.connections.values()) {
            this.sendPacket(new KeepAlivePacket(), connection2);
        }
    }

    @Nullable
    public ClientConnection getSender(NetworkMessage message) {
        return this.connections.values().stream().filter(connection -> connection.getAddress().equals(message.getAddress())).findAny().orElse(null);
    }

    @Nullable
    public ClientConnection getUnconnectedSender(NetworkMessage message) {
        return this.unCheckedConnections.values().stream().filter(connection -> connection.getAddress().equals(message.getAddress())).findAny().orElse(null);
    }

    public Map<UUID, ClientConnection> getConnections() {
        return this.connections;
    }

    @Nullable
    public ClientConnection getConnection(UUID playerID) {
        return this.connections.get(playerID);
    }

    public VoicechatSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public boolean sendPacket(Packet<?> packet, ClientConnection connection) {
        try {
            this.sendPacketRaw(packet, connection);
            return true;
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to send voice chat packet to {}", connection.getPlayerUUID());
            return false;
        }
    }

    public void sendPacketRaw(Packet<?> packet, ClientConnection connection) throws Exception {
        connection.send(this, new NetworkMessage(packet));
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public PlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    public ServerGroupManager getGroupManager() {
        return this.groupManager;
    }

    public ServerCategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    private class ProcessThread
    extends Thread {
        private boolean running = true;
        private long lastKeepAlive = 0L;

        public ProcessThread() {
            this.setDaemon(true);
            this.setName("VoiceChatPacketProcessingThread");
            this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    AuthenticatePacket packet;
                    Secret secret;
                    NetworkMessage message;
                    RawUdpPacket rawPacket;
                    Server.this.pingManager.checkTimeouts();
                    long keepAliveTime = System.currentTimeMillis();
                    if (keepAliveTime - this.lastKeepAlive > (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue()) {
                        Server.this.sendKeepAlives();
                        this.lastKeepAlive = keepAliveTime;
                    }
                    if ((rawPacket = Server.this.packetQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                    try {
                        message = NetworkMessage.readPacketServer(rawPacket, Server.this);
                    }
                    catch (Exception e) {
                        CooldownTimer.run("failed_reading_packet", () -> Voicechat.LOGGER.warn("Failed to read packet from {}", rawPacket.getSocketAddress()));
                        continue;
                    }
                    if (message == null) continue;
                    if (System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) {
                        CooldownTimer.run("ttl", () -> {
                            Voicechat.LOGGER.warn("Dropping voice chat packets! Your Server might be overloaded!", new Object[0]);
                            Voicechat.LOGGER.warn("Packet queue has {} packets", Server.this.packetQueue.size());
                        });
                        continue;
                    }
                    Packet<? extends Packet> packet2 = message.getPacket();
                    if (packet2 instanceof AuthenticatePacket && (secret = Server.this.secrets.get((packet = (AuthenticatePacket)packet2).getPlayerUUID())) != null && secret.equals(packet.getSecret())) {
                        ClientConnection connection = Server.this.unCheckedConnections.get(packet.getPlayerUUID());
                        if (connection == null) {
                            connection = Server.this.connections.get(packet.getPlayerUUID());
                        }
                        if (connection == null) {
                            connection = new ClientConnection(packet.getPlayerUUID(), message.getAddress());
                            Server.this.unCheckedConnections.put(packet.getPlayerUUID(), connection);
                            Voicechat.LOGGER.info("Successfully authenticated player {}", packet.getPlayerUUID());
                        }
                        Server.this.sendPacket(new AuthenticateAckPacket(), connection);
                    }
                    if (message.getPacket() instanceof ConnectionCheckPacket) {
                        ClientConnection connection = Server.this.getUnconnectedSender(message);
                        if (connection == null) {
                            connection = Server.this.getSender(message);
                            if (connection == null) continue;
                            Server.this.sendPacket(new ConnectionCheckAckPacket(), connection);
                            continue;
                        }
                        connection.setLastKeepAliveResponse(System.currentTimeMillis());
                        Server.this.connections.put(connection.getPlayerUUID(), connection);
                        Server.this.unCheckedConnections.remove(connection.getPlayerUUID());
                        Voicechat.LOGGER.info("Successfully validated connection of player {}", connection.getPlayerUUID());
                        ServerPlayer player = Server.this.server.m_6846_().m_11259_(connection.getPlayerUUID());
                        if (player != null) {
                            CommonCompatibilityManager.INSTANCE.emitServerVoiceChatConnectedEvent(player);
                            PluginManager.instance().onPlayerConnected(player);
                            Voicechat.LOGGER.info("Player {} ({}) successfully connected to voice chat", player.m_7755_().getString(), connection.getPlayerUUID());
                        }
                        Server.this.sendPacket(new ConnectionCheckAckPacket(), connection);
                        continue;
                    }
                    ClientConnection conn = Server.this.getSender(message);
                    if (conn == null) continue;
                    Packet<? extends Packet> packet3 = message.getPacket();
                    if (packet3 instanceof MicPacket) {
                        MicPacket packet4 = (MicPacket)packet3;
                        Server.this.onMicPacket(conn.getPlayerUUID(), packet4);
                        continue;
                    }
                    packet3 = message.getPacket();
                    if (packet3 instanceof PingPacket) {
                        PingPacket packet5 = (PingPacket)packet3;
                        Server.this.pingManager.onPongPacket(packet5);
                        continue;
                    }
                    if (!(message.getPacket() instanceof KeepAlivePacket)) continue;
                    conn.setLastKeepAliveResponse(System.currentTimeMillis());
                }
                catch (Exception e) {
                    Voicechat.LOGGER.error("Voice chat server error", e);
                }
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

