/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.struct.data;

import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.func.Boolf;
import pro.komaru.tridot.util.struct.func.Cons;

public class ObjectTree<T> {
    protected Seq<T> childObjects = Seq.with();
    protected String name = "";
    protected Seq<ObjectTree<T>> childTrees = Seq.with();

    private ObjectTree() {
    }

    public Seq<T> allDeep() {
        Seq<T> all = Seq.with(this.children());
        for (ObjectTree<T> tree : this.trees()) {
            all.add(tree.allDeep());
        }
        return all;
    }

    public static <T> ObjectTree<T> of(final String _name, final Seq<T> children) {
        return new ObjectTree<T>(){
            {
                this.name = _name;
                this.childObjects = children.copy();
            }
        };
    }

    public Seq<T> children() {
        return this.childObjects;
    }

    public Seq<T> deepChildren() {
        Seq thisChildren = this.children().copy();
        Seq treesChildren = Seq.with();
        this.trees().each(t -> treesChildren.add(t.deepChildren()));
        thisChildren.addAll(treesChildren);
        return thisChildren;
    }

    public Seq<ObjectTree<T>> trees() {
        return this.childTrees;
    }

    public static void safeClear(ObjectTree<?> tree) {
        if (tree != null) {
            tree.clear();
        }
    }

    public ObjectTree<T> create(String name, Seq<T> children) {
        ObjectTree<T> tree = ObjectTree.of(name, children);
        this.childTrees.remove(t -> t.is(name));
        this.childTrees.add(tree);
        return tree;
    }

    public ObjectTree<T> create(String name) {
        return this.create(name, Seq.with());
    }

    public ObjectTree<T> tree(Boolf<ObjectTree<T>> filter) {
        return this.trees().find(filter);
    }

    public ObjectTree<T> tree(String name) {
        return this.tree((ObjectTree<T> t) -> t.is(name));
    }

    public ObjectTree<T> tree(String name, String sub) {
        ObjectTree<T> parentTree = this.tree((ObjectTree<T> t) -> t.is(name));
        if (parentTree == null) {
            return null;
        }
        return parentTree.tree((ObjectTree<T> t) -> t.is(sub));
    }

    public ObjectTree<T> treeDeep(String name) {
        ObjectTree<T> tree = this.tree(name);
        if (tree != null) {
            return tree;
        }
        for (ObjectTree<T> objTree : this.trees()) {
            ObjectTree<T> foundTree = objTree.treeDeep(name);
            if (foundTree == null) continue;
            return foundTree;
        }
        return null;
    }

    public T child(Boolf<T> filter) {
        return this.children().find(filter);
    }

    private boolean is(String name) {
        return this.name.equals(name);
    }

    public <A> void each(Class<A> as, Cons<A> cons) {
        this.children().each(e -> cons.get(e));
    }

    public void clear() {
        this.children().clear();
        this.trees().clear();
    }

    public String name() {
        return this.name;
    }
}

