/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.math.raycast;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import pro.komaru.tridot.util.math.raycast.RayCastContext;
import pro.komaru.tridot.util.math.raycast.RayHitResult;
import pro.komaru.tridot.util.phys.Vec3;

public class RayCast {
    public static RayHitResult getHit(Level level, RayCastContext context) {
        Vec3 start = context.getStartPos();
        Vec3 end = context.getEndPos();
        int entityCount = context.getEntityCount();
        float size = context.getEntitySize();
        boolean entityEnd = context.getEntityEnd();
        Predicate<BlockPos> blockPosFilter = context.getBlockPosFilter();
        Predicate<Entity> entityFilter = context.getEntityFilter();
        double distance = Math.sqrt(Math.pow(start.x() - end.x(), 2.0) + Math.pow(start.y() - end.y(), 2.0) + Math.pow(start.z() - end.z(), 2.0));
        double X2 = start.x();
        double Y2 = start.y();
        double Z2 = start.z();
        double oldX = X2;
        double oldY = Y2;
        double oldZ = Z2;
        int count = 0;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        float i = 0.0f;
        while ((double)i < distance * 160.0) {
            BlockPos blockPos;
            BlockHitResult blockHitResult;
            double dst = distance * 160.0;
            double dX = start.x() - end.x();
            double dY = start.y() - end.y();
            double dZ = start.z() - end.z();
            double x = -(dX / dst) * (double)i;
            double y = -(dY / dst) * (double)i;
            double z = -(dZ / dst) * (double)i;
            X2 = (double)start.x() + x;
            Y2 = (double)start.y() + y;
            Z2 = (double)start.z() + z;
            boolean canEntity = true;
            if (entityEnd) {
                boolean bl = canEntity = entityCount > 0;
            }
            if (canEntity) {
                List entityList = level.m_45976_(Entity.class, new AABB(X2 - (double)size, Y2 - (double)size, Z2 - (double)size, X2 + (double)size, Y2 + (double)size, Z2 + (double)size));
                for (Entity entity : entityList) {
                    if (!entityFilter.test(entity) || entities.contains(entity)) continue;
                    entities.add(entity);
                    if (!entityEnd || ++count < entityCount) continue;
                    return new RayHitResult(new Vec3(X2, Y2, Z2)).setEntities(entities);
                }
            }
            if ((blockHitResult = context.getBlockShape(level.m_8055_(blockPos = BlockPos.m_274561_((double)X2, (double)Y2, (double)Z2)), (BlockGetter)level, blockPos).m_83220_(start.mcVec(), end.mcVec(), blockPos)) != null && blockPosFilter.test(blockPos)) {
                boolean isBlock = !level.m_8055_(blockHitResult.m_82425_()).m_60795_();
                return new RayHitResult(new Vec3(oldX, oldY, oldZ)).setHitPos(new Vec3(X2, Y2, Z2)).setBlockPos(blockHitResult.m_82425_()).setDirection(blockHitResult.m_82434_()).setBlock(isBlock).setEntities(entities);
            }
            blockHitResult = context.getFluidShape(level.m_6425_(blockPos), (BlockGetter)level, blockPos).m_83220_(start.mcVec(), end.mcVec(), blockPos);
            if (blockHitResult != null) {
                return new RayHitResult(new Vec3(oldX, oldY, oldZ)).setHitPos(new Vec3(X2, Y2, Z2)).setBlockPos(blockHitResult.m_82425_()).setDirection(blockHitResult.m_82434_()).setBlock(true).setEntities(entities);
            }
            oldX = X2;
            oldY = Y2;
            oldZ = Z2;
            i += 1.0f;
        }
        return new RayHitResult(new Vec3(X2, Y2, Z2)).setEntities(entities);
    }

    public static RayHitResult getHit(Level level, Vec3 start, Vec3 end) {
        return RayCast.getHit(level, new RayCastContext(start, end));
    }

    public static List<Entity> getHitEntities(Level level, Vec3 start, Vec3 endPos, float distance) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        float ds = (float)Math.sqrt(Math.pow(start.x() - endPos.x(), 2.0) + Math.pow(start.y() - endPos.y(), 2.0) + Math.pow(start.z() - endPos.z(), 2.0));
        for (float i = 0.0f; i < ds * 10.0f; i += 1.0f) {
            float dst = ds * 10.0f;
            double dX = start.x() - endPos.x();
            double dY = start.y() - endPos.y();
            double dZ = start.z() - endPos.z();
            float x = (float)(-(dX / (double)dst)) * i;
            float y = (float)(-(dY / (double)dst)) * i;
            float z = (float)(-(dZ / (double)dst)) * i;
            float X2 = start.x() + x;
            float Y2 = start.y() + y;
            float Z2 = start.z() + z;
            List entityList = level.m_45976_(Entity.class, new AABB((double)(X2 - distance), (double)(Y2 - distance), (double)(Z2 - distance), (double)(X2 + distance), (double)(Y2 + distance), (double)(Z2 + distance)));
            for (Entity entity : entityList) {
                if (list.contains(entity)) continue;
                list.add(entity);
            }
        }
        return list;
    }
}

