/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.file.binary;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

public class Reads
implements Closeable {
    private static final Reads instance = new Reads(null);
    public DataInput input;

    public Reads(DataInput input) {
        this.input = input;
    }

    public static Reads get(DataInput input) {
        Reads.instance.input = input;
        return instance;
    }

    public int checkEOF() {
        try {
            if (this.input instanceof InputStream) {
                return ((InputStream)((Object)this.input)).read();
            }
            return -1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long l() {
        try {
            return this.input.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int i() {
        try {
            return this.input.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public short s() {
        try {
            return this.input.readShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int us() {
        try {
            return this.input.readUnsignedShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte b() {
        try {
            return this.input.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] b(int length) {
        try {
            byte[] array = new byte[length];
            this.input.readFully(array);
            return array;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] b(byte[] array) {
        try {
            this.input.readFully(array);
            return array;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] b(byte[] array, int offset, int length) {
        try {
            this.input.readFully(array, offset, length);
            return array;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int ub() {
        try {
            return this.input.readUnsignedByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean bool() {
        try {
            return this.input.readBoolean();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public float f() {
        try {
            return this.input.readFloat();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double d() {
        try {
            return this.input.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String str() {
        try {
            return this.input.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void skip(int amount) {
        try {
            this.input.skipBytes(amount);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.input instanceof Closeable) {
            try {
                ((Closeable)((Object)this.input)).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

