/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.comps.render.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.comps.render.RenderStackc;
import pro.komaru.tridot.util.phys.AbsRect;
import pro.komaru.tridot.util.phys.Vec2;

public interface IGuiDrawer
extends RenderStackc {
    public static final Map<String, Vec2> CACHED_DIMS = new HashMap<String, Vec2>();

    public GuiGraphics graphics();

    default public IGuiDrawer clipOn(int x, int y, int w, int h) {
        AbsRect r = AbsRect.xywhDef(x, y, w, h).pose(this.stack());
        this.graphics().m_280588_((int)r.x, (int)r.y, (int)r.x2, (int)r.y2);
        return this;
    }

    default public IGuiDrawer clipOff() {
        this.graphics().m_280618_();
        return this;
    }

    default public IGuiDrawer alpha(float a) {
        return this.color(this.getColor(), a);
    }

    default public Col getColor() {
        float[] color = RenderSystem.getShaderColor();
        return new Col(color[0], color[1], color[2], color[3]);
    }

    default public IGuiDrawer color() {
        return this.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    default public IGuiDrawer color(Col rgb, float a) {
        return this.color(rgb.r, rgb.g, rgb.b, a);
    }

    default public IGuiDrawer color(Col color) {
        return this.color(color.r, color.g, color.b, color.a);
    }

    default public IGuiDrawer color(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        return this;
    }

    default public IGuiDrawer rect(String texture, float x, float y) {
        return this.rect(texture, x, y, 0.0f);
    }

    default public IGuiDrawer rect(String texture, float x, float y, float rotation) {
        return this.rect(texture, x, y, 1.0f, 1.0f, rotation);
    }

    default public IGuiDrawer rect(String texture, float x, float y, float sclx, float scly) {
        return this.rect(texture, x, y, sclx, scly, 0.0f);
    }

    default public IGuiDrawer rect(String texture, float x, float y, float sclx, float scly, float rotation) {
        return this.rect(texture, x, y, sclx, scly, rotation, 0, 0, -1, -1);
    }

    default public IGuiDrawer rect(String texture, float x, float y, float sclx, float scly, float rotation, float clipX, float clipY, float clipW, float clipH) {
        float tw = this.textureSize((ResourceLocation)this.texturePath((String)texture)).x;
        float th = this.textureSize((ResourceLocation)this.texturePath((String)texture)).y;
        return this.rect(texture, x, y, sclx, scly, rotation, (int)(clipX * tw), (int)(clipY * th), (int)(clipW * tw), (int)(clipH * th));
    }

    default public IGuiDrawer rect(String texture, float x, float y, float sclx, float scly, float rotation, int clipX, int clipY, int clipW, int clipH) {
        clipW = clipW == -1 ? (int)this.textureSize((ResourceLocation)this.texturePath((String)texture)).x : clipW;
        clipH = clipH == -1 ? (int)this.textureSize((ResourceLocation)this.texturePath((String)texture)).y : clipH;
        return this.rect(texture, x, y, sclx, scly, rotation, clipX, clipY, clipW, clipH, (int)this.textureSize((ResourceLocation)this.texturePath((String)texture)).x, (int)this.textureSize((ResourceLocation)this.texturePath((String)texture)).y);
    }

    default public IGuiDrawer rect(String texture, float x, float y, float sclx, float scly, float rotation, int clipX, int clipY, int clipW, int clipH, int tw, int th) {
        return this.rect(texture, x, y, sclx, scly, rotation, 0.0f, 0.0f, clipX, clipY, clipW, clipH, tw, th);
    }

    default public IGuiDrawer rect(String texture, float x, float y, float sclx, float scly, float rotation, float rotpx, float rotpy, int clipX, int clipY, int clipW, int clipH, int tw, int th) {
        this.push();
        this.move(x, y);
        this.scale(sclx, scly);
        this.rotate(rotation, (float)tw / 2.0f + rotpx, (float)th / 2.0f + rotpy);
        this.graphics().m_280163_(this.texturePath(texture), 0, 0, (float)clipX, (float)clipY, clipW, clipH, tw, th);
        this.pop();
        return this;
    }

    default public ResourceLocation texturePath(String path) {
        if (path.contains(":")) {
            return new ResourceLocation(path).m_247266_(s -> "textures/" + s + ".png");
        }
        return new ResourceLocation(this.namespace(), "textures/" + path + ".png");
    }

    public String namespace();

    private Vec2 textureSize(ResourceLocation location) {
        TextureManager mng = Minecraft.m_91087_().m_91097_();
        if (CACHED_DIMS.containsKey(location.toString())) {
            return CACHED_DIMS.get(location.toString());
        }
        try {
            NativeImage img = NativeImage.m_85058_((InputStream)((Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).get()).m_215507_());
            CACHED_DIMS.put(location.toString(), new Vec2(img.m_84982_(), img.m_85084_()));
            return new Vec2(img.m_84982_(), img.m_85084_());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Vec2(256.0f, 256.0f);
        }
    }

    default public Minecraft mc() {
        return Utils.mc();
    }

    default public int screenW() {
        return this.mc().m_91268_().m_85445_();
    }

    default public float screenCx() {
        return (float)this.screenW() / 2.0f;
    }

    default public float screenCy() {
        return (float)this.screenH() / 2.0f;
    }

    default public int screenH() {
        return this.mc().m_91268_().m_85446_();
    }
}

