/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.comps.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import org.joml.Matrix4f;
import pro.komaru.tridot.util.comps.phys.Pos2;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.comps.phys.X;
import pro.komaru.tridot.util.comps.phys.Y;
import pro.komaru.tridot.util.comps.phys.Z;
import pro.komaru.tridot.util.phys.Vec3;
import pro.komaru.tridot.util.struct.func.Cons;

public interface RenderStackc {
    public PoseStack stack();

    default public RenderStackc push() {
        return this.pose(PoseStack::m_85836_);
    }

    default public RenderStackc pop() {
        return this.pose(PoseStack::m_85849_);
    }

    default public RenderStackc reset() {
        return this.pop().push();
    }

    default public RenderStackc pose(Cons<PoseStack> cons) {
        cons.get(this.stack());
        return this;
    }

    default public RenderStackc trnsZ(float layer) {
        return this.move(0.0f, 0.0f, layer);
    }

    default public RenderStackc layer(float layer) {
        return this.trnsZ(-this.trns().z + layer);
    }

    default public <XY extends X & Y> RenderStackc move2(XY vec) {
        return this.move(vec.x(), ((Y)vec).y());
    }

    default public RenderStackc move(Pos2 vec) {
        return this.move(vec.x(), vec.y());
    }

    default public RenderStackc move(float x, float y) {
        return this.move(x, y, 0.0f);
    }

    default public <XYZ extends X & Y> RenderStackc move3(XYZ vec) {
        return this.move(vec.x(), ((Y)vec).y(), ((Z)vec).z());
    }

    default public RenderStackc move(Pos3 vec) {
        return this.move(vec.x(), vec.y(), vec.z());
    }

    default public RenderStackc move(float x, float y, float z) {
        return this.pose(s -> s.m_252880_(x, y, z));
    }

    default public RenderStackc scale(float xy) {
        return this.scale(xy, xy);
    }

    default public <XY extends X & Y> RenderStackc scale2(XY xy) {
        return this.scale(xy.x(), ((Y)xy).y());
    }

    default public <XYZ extends X & Y> RenderStackc scale3(XYZ xy) {
        return this.scale(xy.x(), ((Y)xy).y(), ((Z)xy).z());
    }

    default public RenderStackc scale(Pos2 vec) {
        return this.scale(vec.x(), vec.y());
    }

    default public RenderStackc scale(Pos3 vec) {
        return this.scale(vec.x(), vec.y(), vec.z());
    }

    default public RenderStackc scale(float x, float y) {
        return this.scale(x, y, 1.0f);
    }

    default public RenderStackc scale(float x, float y, float z) {
        return this.pose(s -> s.m_85841_(x, y, z));
    }

    default public RenderStackc scale(Pos3 scl, Pos2 point) {
        return this.scale(scl.x(), scl.y(), scl.z(), point.x(), point.y());
    }

    default public RenderStackc scale(Pos2 scl, Pos2 point) {
        return this.scale(scl.x(), scl.y(), point.x(), point.y());
    }

    default public RenderStackc scale(float sclx, float scly, float px, float py) {
        this.move(px, py).scale(sclx, scly).move(-px, -py);
        return this;
    }

    default public RenderStackc scale(float sclx, float scly, float sclz, float px, float py) {
        this.move(px, py).scale(sclx, scly, sclz).move(-px, -py);
        return this;
    }

    default public RenderStackc rotateXYZ(Pos3 rot, Pos3 point) {
        return this.rotateXYZ(rot.x(), rot.y(), rot.z(), point.x(), point.y(), point.z());
    }

    default public RenderStackc rotateXYZ(float x, float y, float z, float px, float py, float pz) {
        return this.move(px, py, pz).rotateXYZ(x, y, z).move(-px, -py, -pz);
    }

    default public RenderStackc rotateXYZ(float x, float y, float z) {
        return this.pose(s -> s.m_252781_(Axis.f_252529_.m_252977_(x))).pose(s -> s.m_252781_(Axis.f_252436_.m_252977_(y))).pose(s -> s.m_252781_(Axis.f_252403_.m_252977_(z)));
    }

    default public RenderStackc rotate(float angle, Pos2 point) {
        return this.rotate(angle, point.x(), point.y());
    }

    default public RenderStackc rotate(float angle, float px, float py) {
        this.move(px, py).rotate(angle).move(-px, -py);
        return this;
    }

    default public RenderStackc rotate(float angle) {
        return this.pose(s -> s.m_252781_(Axis.f_252403_.m_252977_(angle)));
    }

    default public Vec3 trns() {
        Matrix4f mat = this.matrix();
        return new Vec3(mat.m30(), mat.m31(), mat.m32());
    }

    default public Vec3 scl() {
        Matrix4f mat = this.matrix();
        float sclX = (float)Math.sqrt(mat.m00() * mat.m00() + mat.m01() * mat.m01() + mat.m02() * mat.m02());
        float sclY = (float)Math.sqrt(mat.m10() * mat.m10() + mat.m11() * mat.m11() + mat.m12() * mat.m12());
        float sclZ = (float)Math.sqrt(mat.m20() * mat.m20() + mat.m21() * mat.m21() + mat.m22() * mat.m22());
        return new Vec3(sclX, sclY, sclZ);
    }

    default public Vec3 rot() {
        Matrix4f mat = this.matrix();
        Vec3 scale = this.scl();
        float xYaw = mat.m00() / scale.x;
        float yYaw = mat.m10() / scale.x;
        float zYaw = mat.m20() / scale.x;
        float yaw = (float)Math.atan2(xYaw, zYaw);
        float pitch = (float)Math.asin(-yYaw);
        float roll = (float)Math.atan2(mat.m12() / scale.z, mat.m11() / scale.y);
        return new Vec3(pitch, yaw, roll);
    }

    default public Matrix4f matrix() {
        return this.stack().m_85850_().m_252922_();
    }
}

