/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractTridotArrow;

public class ConfigurableCrossbow
extends CrossbowItem
implements Vanishable {
    public double baseDamage;
    public int arrowBaseDamage;
    public int chargeTime = 25;
    public int range = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    public Supplier<? extends EntityType<? extends AbstractArrow>> arrow;

    public ConfigurableCrossbow(double pBaseDamage, Item.Properties pProperties) {
        super(pProperties);
        this.baseDamage = pBaseDamage;
        this.arrowBaseDamage = 2;
        this.arrow = () -> EntityType.f_20548_;
    }

    public ConfigurableCrossbow(Supplier<? extends EntityType<? extends AbstractArrow>> arrow, double pBaseDamage, int pArrowBaseDamage, Item.Properties pProperties) {
        super(pProperties);
        this.baseDamage = pBaseDamage;
        this.arrowBaseDamage = pArrowBaseDamage;
        this.arrow = arrow;
    }

    public ConfigurableCrossbow(Supplier<? extends EntityType<? extends AbstractArrow>> arrow, int chargeTime, double pBaseDamage, int pArrowBaseDamage, Item.Properties pProperties) {
        super(pProperties);
        this.baseDamage = pBaseDamage;
        this.arrowBaseDamage = pArrowBaseDamage;
        this.arrow = arrow;
        this.chargeTime = chargeTime;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (ConfigurableCrossbow.m_40932_((ItemStack)itemstack)) {
            this.performCustomShooting(pLevel, (LivingEntity)pPlayer, pHand, itemstack, this.m_40945_(itemstack), 1.0f);
            ConfigurableCrossbow.m_40884_((ItemStack)itemstack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!pPlayer.m_6298_(itemstack).m_41619_()) {
            if (!ConfigurableCrossbow.m_40932_((ItemStack)itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                pPlayer.m_6672_(pHand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public float m_40945_(ItemStack pCrossbowStack) {
        return ConfigurableCrossbow.m_40871_((ItemStack)pCrossbowStack, (Item)Items.f_42688_) ? 1.6f : 3.15f;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        int i = this.m_8105_(pStack) - pTimeLeft;
        float f = this.m_40853_(i, pStack);
        if (f >= 1.0f && !ConfigurableCrossbow.m_40932_((ItemStack)pStack) && this.m_40859_(pEntityLiving, pStack)) {
            ConfigurableCrossbow.m_40884_((ItemStack)pStack, (boolean)true);
            SoundSource soundsource = pEntityLiving instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            pLevel.m_6263_(null, pEntityLiving.m_20185_(), pEntityLiving.m_20186_(), pEntityLiving.m_20189_(), SoundEvents.f_11841_, soundsource, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public boolean m_40859_(LivingEntity pShooter, ItemStack pCrossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)pCrossbowStack);
        int j = i == 0 ? 1 : 3;
        boolean flag = pShooter instanceof Player && ((Player)pShooter).m_150110_().f_35937_;
        ItemStack itemstack = pShooter.m_6298_(pCrossbowStack);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (this.m_40862_(pShooter, pCrossbowStack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    public boolean m_40862_(LivingEntity pShooter, ItemStack pCrossbowStack, ItemStack pAmmoStack, boolean pHasAmmo, boolean pIsCreative) {
        ItemStack itemstack;
        boolean flag;
        if (pAmmoStack.m_41619_()) {
            return false;
        }
        boolean bl = flag = pIsCreative && pAmmoStack.m_41720_() instanceof ArrowItem;
        if (!(flag || pIsCreative || pHasAmmo)) {
            itemstack = pAmmoStack.m_41620_(1);
            if (pAmmoStack.m_41619_() && pShooter instanceof Player) {
                ((Player)pShooter).m_150109_().m_36057_(pAmmoStack);
            }
        } else {
            itemstack = pAmmoStack.m_41777_();
        }
        this.m_40928_(pCrossbowStack, itemstack);
        return true;
    }

    public void m_40928_(ItemStack pCrossbowStack, ItemStack pAmmoStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41784_();
        ListTag listtag = compoundtag.m_128425_("ChargedProjectiles", 9) ? compoundtag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        pAmmoStack.m_41739_(compoundtag1);
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
    }

    public List<ItemStack> m_40941_(ItemStack pCrossbowStack) {
        ListTag listtag;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("ChargedProjectiles", 9) && (listtag = compoundtag.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundtag1));
            }
        }
        return list;
    }

    public void m_40943_(ItemStack pCrossbowStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 9);
            listtag.clear();
            compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
        }
    }

    public void m_40894_(Level pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pCrossbowStack, ItemStack pAmmoStack, float pSoundPitch, boolean pIsCreativeMode, float pVelocity, float pInaccuracy, float pProjectileAngle) {
        if (!pLevel.f_46443_) {
            AbstractArrow projectile;
            boolean flag = pAmmoStack.m_150930_(Items.f_42688_);
            if (flag) {
                projectile = new FireworkRocketEntity(pLevel, pAmmoStack, (Entity)pShooter, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.15f, pShooter.m_20189_(), true);
            } else {
                projectile = this.m_40914_(pLevel, pShooter, pCrossbowStack, pAmmoStack);
                if (pIsCreativeMode || pProjectileAngle != 0.0f) {
                    projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (pShooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowattackmob = (CrossbowAttackMob)pShooter;
                crossbowattackmob.m_5811_(crossbowattackmob.m_5448_(), pCrossbowStack, (Projectile)this.createArrow(pLevel, pShooter), pProjectileAngle);
            } else {
                Vec3 vec31 = pShooter.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(pProjectileAngle * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = pShooter.m_20252_(1.0f);
                Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), pVelocity, pInaccuracy);
            }
            pCrossbowStack.m_41622_(flag ? 3 : 1, pShooter, p_40858_ -> p_40858_.m_21190_(pHand));
            pLevel.m_7967_((Entity)projectile);
            pLevel.m_6263_(null, pShooter.m_20185_(), pShooter.m_20186_(), pShooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    public void doPreSpawn(AbstractArrow abstractarrow, LivingEntity player, float power) {
        abstractarrow.m_36781_(abstractarrow.m_36789_() + this.baseDamage);
        abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 1.0f);
        if (power == 1.0f) {
            abstractarrow.m_36762_(true);
        }
    }

    public AbstractArrow createArrow(Level pLevel, LivingEntity player) {
        AbstractArrow customArrow = (AbstractArrow)this.arrow.get().m_20615_(pLevel);
        customArrow.m_20219_(new Vec3(player.m_146892_().f_82479_, player.m_146892_().f_82480_ - (double)0.1f, player.m_146892_().f_82481_));
        customArrow.m_5602_((Entity)player);
        if (customArrow instanceof AbstractTridotArrow) {
            AbstractTridotArrow valor = (AbstractTridotArrow)customArrow;
            valor.doPostSpawn();
        }
        return customArrow;
    }

    public AbstractArrow m_40914_(Level pLevel, LivingEntity pLivingEntity, ItemStack pCrossbowStack, ItemStack pAmmoStack) {
        AbstractArrow abstractarrow;
        ArrowItem arrowitem = (ArrowItem)(pAmmoStack.m_41720_() instanceof ArrowItem ? pAmmoStack.m_41720_() : Items.f_42412_);
        AbstractArrow abstractArrow = abstractarrow = arrowitem == Items.f_42412_ && this.arrow.get() != EntityType.f_20548_ ? this.createArrow(pLevel, pLivingEntity) : arrowitem.m_6394_(pLevel, pAmmoStack, pLivingEntity);
        if (pLivingEntity instanceof CrossbowAttackMob && this.arrow.get() != EntityType.f_20548_) {
            this.createArrow(pLevel, pLivingEntity);
        }
        abstractarrow.m_5602_((Entity)pLivingEntity);
        this.doPreSpawn(abstractarrow, pLivingEntity, this.m_40945_(pCrossbowStack));
        if (pLivingEntity instanceof Player) {
            abstractarrow.m_36762_(true);
        }
        abstractarrow.m_36740_(SoundEvents.f_11840_);
        abstractarrow.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)pCrossbowStack);
        if (i > 0) {
            abstractarrow.m_36767_((byte)i);
        }
        return abstractarrow;
    }

    public void performCustomShooting(Level pLevel, LivingEntity pShooter, InteractionHand pUsedHand, ItemStack pCrossbowStack, float pVelocity, float pInaccuracy) {
        if (pShooter instanceof Player) {
            Player player = (Player)pShooter;
            if (ForgeEventFactory.onArrowLoose((ItemStack)pCrossbowStack, (Level)pShooter.m_9236_(), (Player)player, (int)1, (boolean)true) < 0) {
                return;
            }
        }
        List<ItemStack> list = this.m_40941_(pCrossbowStack);
        float[] afloat = this.m_220023_(pShooter.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = pShooter instanceof Player && ((Player)pShooter).m_150110_().f_35937_;
            if (itemstack.m_41619_()) continue;
            if (i == 0) {
                this.m_40894_(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i], flag, pVelocity, pInaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                this.m_40894_(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i], flag, pVelocity, pInaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            this.m_40894_(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i], flag, pVelocity, pInaccuracy, 10.0f);
        }
        this.m_40905_(pLevel, pShooter, pCrossbowStack);
    }

    public float[] m_220023_(RandomSource pRandom) {
        boolean flag = pRandom.m_188499_();
        return new float[]{1.0f, this.m_220025_(flag, pRandom), this.m_220025_(!flag, pRandom)};
    }

    public float m_220025_(boolean pIsHighPitched, RandomSource pRandom) {
        float f = pIsHighPitched ? 0.63f : 0.43f;
        return 1.0f / (pRandom.m_188501_() * 0.5f + 1.8f) + f;
    }

    public void m_40905_(Level pLevel, LivingEntity pShooter, ItemStack pCrossbowStack) {
        if (pShooter instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pShooter;
            if (!pLevel.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayer, pCrossbowStack);
            }
            serverplayer.m_36246_(Stats.f_12982_.m_12902_((Object)pCrossbowStack.m_41720_()));
        }
        this.m_40943_(pCrossbowStack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pCount) {
        if (!pLevel.f_46443_) {
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)pStack);
            SoundEvent soundevent = this.m_40851_(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(pStack.m_41779_() - pCount) / (float)this.getCustomChargeDuration(pStack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                pLevel.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                pLevel.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack pStack) {
        return this.getCustomChargeDuration(pStack) + 3;
    }

    public int getCustomChargeDuration(ItemStack pCrossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)pCrossbowStack);
        return i == 0 ? this.chargeTime : this.chargeTime - 5 * i;
    }

    public SoundEvent m_40851_(int pEnchantmentLevel) {
        return switch (pEnchantmentLevel) {
            case 1 -> SoundEvents.f_11844_;
            case 2 -> SoundEvents.f_11845_;
            case 3 -> SoundEvents.f_11846_;
            default -> SoundEvents.f_11843_;
        };
    }

    public float m_40853_(int pUseTime, ItemStack pCrossbowStack) {
        float f = (float)pUseTime / (float)this.getCustomChargeDuration(pCrossbowStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public String formatTickDuration(int ticks) {
        double totalSeconds = (double)ticks / 20.0;
        int days = (int)(totalSeconds / 86400.0);
        int hours = (int)((totalSeconds %= 86400.0) / 3600.0);
        int minutes = (int)((totalSeconds %= 3600.0) / 60.0);
        totalSeconds %= 60.0;
        StringBuilder sb = new StringBuilder();
        if (days > 0) {
            sb.append(days).append("d ");
        }
        if (hours > 0) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0) {
            sb.append(minutes).append("m ");
        }
        if (totalSeconds > 0.0 || sb.isEmpty()) {
            if (totalSeconds == (double)((int)totalSeconds)) {
                sb.append((int)totalSeconds).append("s");
            } else {
                sb.append(String.format("%.2fs", totalSeconds));
            }
        }
        return sb.toString().trim();
    }

    private double calculateAverageDamage(ItemStack pStack) {
        double baseArrowDamage = this.baseDamage + 2.0;
        return baseArrowDamage * 4.0 - 2.0;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        List<ItemStack> list = this.m_40941_(pStack);
        if (ConfigurableCrossbow.m_40932_((ItemStack)pStack) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            Component name = itemstack.m_150930_(Items.f_42412_) && this.arrow.get() != EntityType.f_20548_ ? this.arrow.get().m_20676_() : itemstack.m_41611_();
            pTooltip.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_7220_(CommonComponents.f_263701_).m_7220_(name));
            if (pFlag.m_7050_() && itemstack.m_150930_(Items.f_42688_)) {
                ArrayList list1 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemstack, pLevel, (List)list1, pFlag);
                if (!list1.isEmpty()) {
                    list1.replaceAll(pSibling -> Component.m_237113_((String)"  ").m_7220_(pSibling).m_130940_(ChatFormatting.GRAY));
                    pTooltip.addAll(list1);
                }
            }
        }
        pTooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.crossbow.speed", (Object[])new Object[]{this.formatTickDuration(this.getCustomChargeDuration(pStack))}).m_130940_(ChatFormatting.GRAY));
    }

    public int m_6615_() {
        return this.range;
    }
}

