/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.skins;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import pro.komaru.tridot.client.model.item.CustomModel;
import pro.komaru.tridot.client.model.item.ItemSkinItemOverrides;
import pro.komaru.tridot.client.model.item.ItemSkinModels;
import pro.komaru.tridot.client.model.render.item.LargeItemRenderer;
import pro.komaru.tridot.common.registry.item.skins.ISkinProvider;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.util.struct.data.Seq;

public class SkinRegistryManager {
    private static final Map<String, ItemSkin> skins = new HashMap<String, ItemSkin>();
    private static final Seq<ItemSkin> skinList = Seq.with();
    private static final SkinRegistryManager INSTANCE = new SkinRegistryManager();

    public static SkinRegistryManager getInstance() {
        return INSTANCE;
    }

    public static void add(ItemSkin skin) {
        if (skin == null || skin.skinBuilder == null || skin.skinBuilder.id == null) {
            return;
        }
        skins.put(skin.skinBuilder.id, skin);
        skinList.add(skin);
    }

    public static ItemSkin get(int index) {
        if (index >= 0 && index < SkinRegistryManager.skinList.size) {
            return skinList.get(index);
        }
        return null;
    }

    public static ItemSkin get(String id) {
        return skins.get(id);
    }

    public static int size() {
        return skins.size();
    }

    public static Seq<ItemSkin> getApplicableSkins(ItemStack stack) {
        Seq<ItemSkin> skins = Seq.with();
        SkinRegistryManager.getSkins().forEach(s -> {
            if (s.appliesOn(stack)) {
                skins.add((ItemSkin)s);
            }
        });
        return skins;
    }

    public static Seq<ItemSkin> getSkins() {
        return Seq.with(skinList);
    }

    public static Map<String, ItemSkin> getSkinsMap() {
        return Collections.unmodifiableMap(skins);
    }

    public void registerSkinProvider(ISkinProvider provider) {
        provider.initializeSkins();
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            provider.registerModels();
            return new Object();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addSkinModel(Map<ResourceLocation, BakedModel> map, ResourceLocation id) {
        BakedModel model = map.get(new ModelResourceLocation(id, "inventory"));
        CustomModel newModel = new CustomModel(model, new ItemSkinItemOverrides());
        map.replace((ResourceLocation)new ModelResourceLocation(id, "inventory"), newModel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addLargeModel(Map<ResourceLocation, BakedModel> map, String modId, String skin) {
        LargeItemRenderer.bakeModel(map, modId, "skin/" + skin);
        ItemSkinModels.addModelSkins(modId + ":" + skin, map.get(SkinRegistryManager.getModelLocationSkin(modId + ":" + skin)));
    }

    public static ModelResourceLocation getModelLocationSkin(String id) {
        int i = id.indexOf(":");
        String modId = id.substring(0, i);
        String skinId = id.substring(i + 1);
        return new ModelResourceLocation(new ResourceLocation(modId, "skin/" + skinId), "inventory");
    }

    @Mod.EventBusSubscriber(modid="tridot", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientRegistryEvents {
        @SubscribeEvent
        public static void modelRegistrySkins(ModelEvent.RegisterAdditional event) {
            for (String skin : ItemSkinModels.getSkins()) {
                event.register((ResourceLocation)SkinRegistryManager.getModelLocationSkin(skin));
            }
        }

        @SubscribeEvent
        public static void modelBakeSkins(ModelEvent.ModifyBakingResult event) {
            Map map = event.getModels();
            for (String skin : ItemSkinModels.getSkins()) {
                BakedModel model = (BakedModel)map.get(SkinRegistryManager.getModelLocationSkin(skin));
                ItemSkinModels.addModelSkins(skin, model);
            }
        }
    }
}

