/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.components.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import pro.komaru.tridot.Tridot;

public class AbilityClientComponent
implements ClientTooltipComponent {
    public final ResourceLocation bg = Tridot.ofTridot("textures/gui/tooltips/background.png");
    public final ResourceLocation icon;
    public final int maxChars = 200;
    public final int iconMargin = 6;
    public final int iconSize;
    public final int paddingTop;
    public final List<FormattedCharSequence> lines;

    public AbilityClientComponent(MutableComponent text, ResourceLocation icon, int iconSize, int paddingTop) {
        this.lines = Language.m_128107_().m_128112_(Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)text, 200, text.m_7383_()));
        this.iconSize = iconSize;
        this.paddingTop = paddingTop;
        this.icon = icon;
    }

    public static ClientTooltipComponent create(MutableComponent text, ResourceLocation icon, int paddingTop, int iconSize) {
        return new AbilityClientComponent(text, icon, iconSize, paddingTop);
    }

    public int m_142103_() {
        return Math.max(this.iconSize + 6, 10 * this.lines.size()) + this.paddingTop;
    }

    public int m_142069_(Font pFont) {
        int width = 0;
        for (FormattedCharSequence line : this.lines) {
            float scale = 1.0f;
            int lineWidth = this.iconSize + 6 + (int)((float)pFont.m_92724_(line) * scale);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    public void m_142440_(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
        int x = pMouseX + this.iconSize + 4;
        int y = pMouseY + this.paddingTop;
        for (FormattedCharSequence line : this.lines) {
            float scale = 1.0f;
            Matrix4f scaled = new Matrix4f((Matrix4fc)pMatrix);
            scaled.scale(scale, scale, 1.0f);
            pFont.m_272191_(line, (float)x / scale, (float)y / scale + 1.0f, -1, true, scaled, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            y += 9;
        }
    }

    public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        RenderSystem.enableBlend();
        pGuiGraphics.m_280163_(this.bg, pX, pY + this.paddingTop - 1, 0.0f, 0.0f, this.iconSize, this.iconSize, this.iconSize, this.iconSize);
        pGuiGraphics.m_280163_(this.icon, pX, pY + this.paddingTop - 1, 0.0f, 0.0f, this.iconSize, this.iconSize, this.iconSize, this.iconSize);
        RenderSystem.disableBlend();
    }
}

