/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.render.screenshake;

import net.minecraft.client.Camera;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.Interp;
import pro.komaru.tridot.util.phys.Vec3;

public class PositionedScreenshakeInstance
extends ScreenshakeInstance {
    public final Vec3 position;
    public final float falloffDistance;
    public final float maxDistance;
    public final Interp falloffEasing;

    public PositionedScreenshakeInstance(int duration, Pos3 position, float falloffDistance, float maxDistance, Interp falloffEasing) {
        super(duration);
        this.position = new Vec3(position);
        this.falloffDistance = falloffDistance;
        this.maxDistance = maxDistance;
        this.falloffEasing = falloffEasing;
    }

    public PositionedScreenshakeInstance(int duration, Pos3 position, float falloffDistance, float maxDistance) {
        this(duration, position, falloffDistance, maxDistance, Interp.linear);
    }

    @Override
    public float updateIntensity(Camera camera) {
        float intensity = super.updateIntensity(camera);
        float distance = this.position.cpy().sub(Vec3.from(camera.m_90583_())).len();
        if (distance > this.maxDistance) {
            return 0.0f;
        }
        float distanceMultiplier = 1.0f;
        if (distance > this.falloffDistance) {
            float remaining = this.maxDistance - this.falloffDistance;
            float current = distance - this.falloffDistance;
            distanceMultiplier = 1.0f - current / remaining;
        }
        Vector3f lookDirection = camera.m_253058_();
        Vec3 directionToScreenshake = this.position.cpy().sub(Vec3.from(camera.m_90583_())).nor();
        float angle = Math.max(0.0f, lookDirection.dot((Vector3fc)new Vector3f(directionToScreenshake.x(), directionToScreenshake.y(), directionToScreenshake.z())));
        return (intensity + intensity * angle) * 0.5f * distanceMultiplier;
    }
}

