/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.render.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.util.struct.func.Cons;

public abstract class TridotScreen
extends Screen {
    public boolean pause = false;
    public int tick = 0;
    public PoseStack localPose;
    public GuiGraphics localG;
    public String assetsId;

    public TridotScreen() {
        super((Component)Component.m_237113_((String)""));
    }

    public void update(GuiGraphics g) {
        this.localPose = g.m_280168_();
        this.localG = g;
    }

    public void push() {
        this.localPose.m_85836_();
    }

    public void pop() {
        this.localPose.m_85849_();
    }

    public void pop_push() {
        this.pop();
        this.push();
    }

    public void blit(String texture, int x, int y, int cutx, int cuty, int cutw, int cuth, int tw, int th) {
        ResourceLocation location = texture.contains(":") ? new ResourceLocation(texture) : new ResourceLocation(this.assetsId, texture);
        this.localG.m_280163_(location, x, y, (float)cutx, (float)cuty, cutw, cuth, tw, th);
    }

    public void blit(String texture, int x, int y, int tw, int ty) {
        this.blit(texture, x, y, 0, 0, tw, ty, tw, ty);
    }

    public void blit(String texture, int x, int y, int cutx, int cuty, int cutw, int cuth) {
        this.blit(texture, x, y, cutx, cuty, cutw, cuth, 256, 256);
    }

    public void color(float r, float g, float b, float a) {
        if (this.localG != null) {
            this.localG.m_280246_(r, g, b, a);
        } else {
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }
    }

    public void color(float r, float g, float b) {
        this.color(r, g, b, this.color(3));
    }

    public void color(float a) {
        this.color(this.color(0), this.color(1), this.color(2), a);
    }

    public void color() {
        this.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public float color(int idx) {
        return RenderSystem.getShaderColor()[idx];
    }

    public boolean m_7043_() {
        return this.pause;
    }

    public void m_86600_() {
        ++this.tick;
    }

    public float time() {
        return (float)this.tick + this.mc().getPartialTick();
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partial) {
        this.update(g);
        this.renderBefore(g, mouseX, mouseY, partial);
        this.renderChildren(g, mouseX, mouseY, partial);
        this.renderAfter(g, mouseX, mouseY, partial);
    }

    public void renderBefore(GuiGraphics g, int mouseX, int mouseY, float partial) {
    }

    public void renderAfter(GuiGraphics g, int mouseX, int mouseY, float partial) {
    }

    public void renderChildren(GuiGraphics g, int mouseX, int mouseY, float partial) {
        for (Renderable renderable : this.f_169369_) {
            this.renderChild(renderable, g, mouseX, mouseY, partial);
        }
    }

    public void renderChild(Renderable r, GuiGraphics g, int mouseX, int mouseY, float partial) {
        r.m_88315_(g, mouseX, mouseY, partial);
    }

    public <T> T add(T object) {
        if (object instanceof Renderable) {
            Renderable r = (Renderable)object;
            this.m_169394_(r);
        }
        if (object instanceof GuiEventListener) {
            GuiEventListener a = (GuiEventListener)object;
            this.addWidgetOnly(a);
        }
        return object;
    }

    public Minecraft mc() {
        return Utils.mc();
    }

    public int w() {
        return this.mc().m_91268_().m_85445_();
    }

    public float cx() {
        return (float)this.w() / 2.0f;
    }

    public float cy() {
        return (float)this.h() / 2.0f;
    }

    public int h() {
        return this.mc().m_91268_().m_85446_();
    }

    protected <T extends GuiEventListener> T addWidgetOnly(T pListener) {
        this.m_6702_().add(pListener);
        return pListener;
    }

    public void move(float x, float y, float z) {
        this.pose(p -> p.m_252880_(x, y, z));
    }

    public void move(float x, float y) {
        this.move(x, y, 0.0f);
    }

    public void rotate(float angle) {
        this.localPose.m_252781_(Axis.f_252403_.m_252977_(angle));
    }

    public void rotate(float px, float py, float angle) {
        this.move(px, py);
        this.rotate(angle);
        this.move(-px, -py);
    }

    public void scale(float x, float y, float px, float py) {
        this.move(px, py);
        this.scale(x, y);
        this.move(-px, -py);
    }

    public void scale(float x, float y, float z) {
        this.pose(p -> p.m_85841_(x, y, z));
    }

    public void scale(float x, float y) {
        this.scale(x, y, 1.0f);
    }

    public void scale(float xy) {
        this.scale(xy, xy);
    }

    public void layer(float z) {
        this.move(0.0f, 0.0f, z);
    }

    public void pose(Cons<PoseStack> p) {
        if (this.localPose != null) {
            p.get(this.localPose);
        }
    }
}

