/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.model.armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;

public abstract class ArmorModel
extends HumanoidModel {
    public EquipmentSlot slot;
    public final ModelPart root;
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart leftArm;
    public final ModelPart rightArm;
    public final ModelPart pelvis;
    public final ModelPart leftLegging;
    public final ModelPart rightLegging;
    public final ModelPart leftFoot;
    public final ModelPart rightFoot;

    public ArmorModel(ModelPart root) {
        super(root);
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.pelvis = root.m_171324_("pelvis");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArm = root.m_171324_("right_arm");
        this.leftLegging = root.m_171324_("left_legging");
        this.rightLegging = root.m_171324_("right_legging");
        this.leftFoot = root.m_171324_("left_foot");
        this.rightFoot = root.m_171324_("right_foot");
    }

    public static PartDefinition createHumanoidAlias(MeshDefinition mesh) {
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("body", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("pelvis", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("head", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("left_legging", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("left_foot", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("right_legging", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("right_foot", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("left_arm", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("right_arm", new CubeListBuilder(), PartPose.f_171404_);
        return root;
    }

    protected Iterable<ModelPart> m_5607_() {
        return this.slot == EquipmentSlot.HEAD ? ImmutableList.of((Object)this.head) : ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.leftLegging, (Object)this.rightLegging, (Object)this.pelvis);
        }
        if (this.slot == EquipmentSlot.FEET) {
            return ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot);
        }
        return ImmutableList.of();
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_7695_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void copyFromDefault(HumanoidModel model) {
        this.body.m_104315_(model.f_102810_);
        this.pelvis.m_104315_(model.f_102810_);
        this.leftLegging.m_104315_(model.f_102814_);
        this.rightLegging.m_104315_(model.f_102813_);
        this.leftFoot.m_104315_(model.f_102814_);
        this.rightFoot.m_104315_(model.f_102813_);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

