/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle.data;

import net.minecraft.util.Mth;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleDataBuilder;
import pro.komaru.tridot.util.math.Interp;

public class GenericParticleData {
    public final float startingValue;
    public final float middleValue;
    public final float endingValue;
    public final float rs1;
    public final float rs2;
    public final float rm1;
    public final float rm2;
    public final float re1;
    public final float re2;
    public final float coefficient;
    public final Interp startToMiddleEasing;
    public final Interp middleToEndEasing;
    public float valueMultiplier = 1.0f;
    public float coefficientMultiplier = 1.0f;

    protected GenericParticleData(float startingValue, float middleValue, float endingValue, float rs1, float rs2, float rm1, float rm2, float re1, float re2, float coefficient, Interp startToMiddleEasing, Interp middleToEndEasing) {
        this.startingValue = startingValue;
        this.middleValue = middleValue;
        this.endingValue = endingValue;
        this.rs1 = rs1;
        this.rs2 = rs2;
        this.rm1 = rm1;
        this.rm2 = rm2;
        this.re1 = re1;
        this.re2 = re2;
        this.coefficient = coefficient;
        this.startToMiddleEasing = startToMiddleEasing;
        this.middleToEndEasing = middleToEndEasing;
    }

    public GenericParticleData copy() {
        return new GenericParticleData(this.startingValue, this.middleValue, this.endingValue, this.rs1, this.rs2, this.rm1, this.rm2, this.re1, this.re2, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing).overrideValueMultiplier(this.valueMultiplier).overrideCoefficientMultiplier(this.coefficientMultiplier);
    }

    public GenericParticleData bake() {
        return new GenericParticleData(this.startingValue * this.valueMultiplier, this.middleValue * this.valueMultiplier, this.endingValue * this.valueMultiplier, this.rs1 * this.valueMultiplier, this.rs2 * this.valueMultiplier, this.rm1 * this.valueMultiplier, this.rm2 * this.valueMultiplier, this.re1 * this.valueMultiplier, this.re2 * this.valueMultiplier, this.coefficient * this.coefficientMultiplier, this.startToMiddleEasing, this.middleToEndEasing);
    }

    public GenericParticleData multiplyCoefficient(float coefficientMultiplier) {
        this.coefficientMultiplier *= coefficientMultiplier;
        return this;
    }

    public GenericParticleData multiplyValue(float valueMultiplier) {
        this.valueMultiplier *= valueMultiplier;
        return this;
    }

    public GenericParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        this.coefficientMultiplier = coefficientMultiplier;
        return this;
    }

    public GenericParticleData overrideValueMultiplier(float valueMultiplier) {
        this.valueMultiplier = valueMultiplier;
        return this;
    }

    public boolean isTrinary() {
        return this.endingValue != -1.0f;
    }

    public float getProgress(float age, float lifetime) {
        return Mth.m_14036_((float)(age * this.coefficient * this.coefficientMultiplier / lifetime), (float)0.0f, (float)1.0f);
    }

    public float getValue(float age, float lifetime, float startingValue, float middleValue, float endingValue) {
        float progress = this.getProgress(age, lifetime);
        float result = this.isTrinary() ? (progress >= 0.5f ? Mth.m_14179_((float)this.middleToEndEasing.apply((progress - 0.5f) / 0.5f), (float)middleValue, (float)endingValue) : Mth.m_14179_((float)this.startToMiddleEasing.apply(progress / 0.5f), (float)startingValue, (float)middleValue)) : Mth.m_14179_((float)this.startToMiddleEasing.apply(progress), (float)startingValue, (float)middleValue);
        return result * this.valueMultiplier;
    }

    public float getValue(float age, float lifetime) {
        return this.getValue(age, lifetime, this.startingValue, this.middleValue, this.endingValue);
    }

    public static GenericParticleDataBuilder create() {
        return new GenericParticleDataBuilder(-1.0f, -1.0f, -1.0f);
    }

    public static GenericParticleDataBuilder create(float value) {
        return new GenericParticleDataBuilder(value, value, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, endingValue, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float middleValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, middleValue, endingValue);
    }

    public static GenericParticleData constrictTransparency(GenericParticleData data) {
        float startingValue = Mth.m_14036_((float)data.startingValue, (float)0.0f, (float)1.0f);
        float middleValue = Mth.m_14036_((float)data.middleValue, (float)0.0f, (float)1.0f);
        float endingValue = data.endingValue == -1.0f ? -1.0f : Mth.m_14036_((float)data.endingValue, (float)0.0f, (float)1.0f);
        float rs1 = data.rs1 == -1.0f ? -1.0f : Mth.m_14036_((float)data.rs1, (float)0.0f, (float)1.0f);
        float rm1 = data.rm1 == -1.0f ? -1.0f : Mth.m_14036_((float)data.rm1, (float)0.0f, (float)1.0f);
        float re1 = data.re1 == -1.0f ? -1.0f : Mth.m_14036_((float)data.re1, (float)0.0f, (float)1.0f);
        float rs2 = data.rs2 == -1.0f ? -1.0f : Mth.m_14036_((float)data.rs2, (float)0.0f, (float)1.0f);
        float rm2 = data.rm2 == -1.0f ? -1.0f : Mth.m_14036_((float)data.rm2, (float)0.0f, (float)1.0f);
        float re2 = data.re2 == -1.0f ? -1.0f : Mth.m_14036_((float)data.re2, (float)0.0f, (float)1.0f);
        float coefficient = data.coefficient;
        Interp startToMiddleEasing = data.startToMiddleEasing;
        Interp middleToEndEasing = data.middleToEndEasing;
        return new GenericParticleData(startingValue, middleValue, endingValue, rs1, rs2, rm1, rm2, re1, re2, coefficient, startToMiddleEasing, middleToEndEasing);
    }
}

