/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import pro.komaru.tridot.client.gfx.particle.AbstractParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.gfx.particle.options.GenericParticleOptions;
import pro.komaru.tridot.client.gfx.particle.options.ScreenParticleOptions;
import pro.komaru.tridot.client.gfx.particle.screen.GenericScreenParticle;
import pro.komaru.tridot.client.gfx.particle.type.ScreenParticleType;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.client.render.gui.particle.ScreenParticleHandler;
import pro.komaru.tridot.client.render.gui.particle.ScreenParticleHolder;

public class ScreenParticleBuilder
extends AbstractParticleBuilder<ScreenParticleBuilder> {
    final ScreenParticleType<?> type;
    final ScreenParticleOptions options;
    final ScreenParticleHolder target;

    public static ScreenParticleBuilder create(ScreenParticleType<?> type, ScreenParticleHolder target) {
        return new ScreenParticleBuilder(type, target);
    }

    protected ScreenParticleBuilder(ScreenParticleType<?> type, ScreenParticleHolder target) {
        this.type = type;
        this.options = new ScreenParticleOptions(type);
        this.target = target;
    }

    public ScreenParticleOptions getParticleOptions() {
        return this.options;
    }

    public ScreenParticleBuilder modifyData(Supplier<GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        dataConsumer.accept(dataType.get());
        return this;
    }

    public ScreenParticleBuilder modifyData(Optional<GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        dataType.ifPresent(dataConsumer);
        return this;
    }

    public ScreenParticleBuilder modifyData(Function<ScreenParticleBuilder, GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        dataConsumer.accept(dataType.apply(this));
        return this;
    }

    public ScreenParticleBuilder modifyDataOptional(Function<ScreenParticleBuilder, Optional<GenericParticleData>> dataType, Consumer<GenericParticleData> dataConsumer) {
        return this.modifyData(dataType.apply(this), dataConsumer);
    }

    public final ScreenParticleBuilder modifyData(Collection<Supplier<GenericParticleData>> dataTypes, Consumer<GenericParticleData> dataConsumer) {
        for (Supplier<GenericParticleData> dataFunction : dataTypes) {
            dataConsumer.accept(dataFunction.get());
        }
        return this;
    }

    public ScreenParticleBuilder setDiscardFunction(GenericParticleOptions.DiscardFunctionType discardFunctionType) {
        this.options.discardFunctionType = discardFunctionType;
        return this;
    }

    public ScreenParticleBuilder setRenderType(TridotRenderTypes.ScreenParticleRenderType renderType) {
        this.options.renderType = renderType;
        return this;
    }

    @Override
    public ScreenParticleBuilder randomVelocity(double maxSpeed) {
        return this.randomVelocity(maxSpeed, maxSpeed);
    }

    @Override
    public ScreenParticleBuilder randomVelocity(double maxXSpeed, double maxYSpeed) {
        this.maxXSpeed = maxXSpeed;
        this.maxYSpeed = maxYSpeed;
        return this;
    }

    @Override
    public ScreenParticleBuilder addVelocity(double vx, double vy, double vz) {
        this.vx += vx;
        this.vy += vy;
        return this;
    }

    @Override
    public ScreenParticleBuilder setVelocity(double vx, double vy, double vz) {
        this.vx = vx;
        this.vy = vy;
        return this;
    }

    @Override
    public ScreenParticleBuilder randomOffset(double maxDistance) {
        return this.randomOffset(maxDistance, maxDistance);
    }

    @Override
    public ScreenParticleBuilder randomOffset(double maxXDist, double maxYDist) {
        this.maxXDist = maxXDist;
        this.maxYDist = maxYDist;
        return this;
    }

    public ScreenParticleBuilder act(Consumer<ScreenParticleBuilder> particleBuilderConsumer) {
        particleBuilderConsumer.accept(this);
        return this;
    }

    public ScreenParticleBuilder addActor(Consumer<GenericScreenParticle> particleActor) {
        this.options.actor = particleActor;
        return this;
    }

    public ScreenParticleBuilder spawn(double x, double y) {
        double yaw = (double)this.random.nextFloat() * Math.PI * 2.0;
        double pitch = (double)this.random.nextFloat() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)this.random.nextFloat() * this.maxXSpeed;
        double ySpeed = (double)this.random.nextFloat() * this.maxYSpeed;
        this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.vy += Math.sin(pitch) * ySpeed;
        double yaw2 = (double)this.random.nextFloat() * Math.PI * 2.0;
        double pitch2 = (double)this.random.nextFloat() * Math.PI - 1.5707963267948966;
        double xDist = (double)this.random.nextFloat() * this.maxXDist;
        double yDist = (double)this.random.nextFloat() * this.maxYDist;
        double xPos = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
        double yPos = Math.sin(pitch2) * yDist;
        ScreenParticleHandler.addParticle(this.target, this.options, x + xPos, y + yPos, this.vx, this.vy);
        return this;
    }

    public ScreenParticleBuilder repeat(double x, double y, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawn(x, y);
        }
        return this;
    }

    public ScreenParticleBuilder spawnOnStack(double xOffset, double yOffset) {
        this.options.tracksStack = true;
        this.options.stackTrackXOffset = xOffset;
        this.options.stackTrackYOffset = yOffset;
        this.spawn((double)ScreenParticleHandler.currentItemX + xOffset, (double)ScreenParticleHandler.currentItemY + yOffset);
        return this;
    }

    public ScreenParticleBuilder repeatOnStack(double xOffset, double yOffset, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawnOnStack(xOffset, yOffset);
        }
        return this;
    }

    public ScreenParticleBuilder setColorData(ColorParticleData colorData) {
        this.options.colorData = colorData;
        return this;
    }

    public ScreenParticleBuilder setScaleData(GenericParticleData scaleData) {
        this.options.scaleData = scaleData;
        return this;
    }

    public ScreenParticleBuilder setTransparencyData(GenericParticleData transparencyData) {
        this.options.transparencyData = transparencyData;
        return this;
    }

    public ScreenParticleBuilder setSpinData(SpinParticleData spinData) {
        this.options.spinData = spinData;
        return this;
    }

    public ScreenParticleBuilder setGravity(float gravity) {
        this.options.gravity = gravity;
        return this;
    }

    public ScreenParticleBuilder setGravity(float gravity, float additionalGravity) {
        this.options.gravity = gravity;
        this.options.additionalGravity = additionalGravity;
        return this;
    }

    public ScreenParticleBuilder setLifetime(int lifetime) {
        this.options.lifetime = lifetime;
        return this;
    }

    public ScreenParticleBuilder setLifetime(int lifetime, int additionalLifetime) {
        this.options.lifetime = lifetime;
        this.options.additionalLifetime = additionalLifetime;
        return this;
    }
}

