/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;
import pro.komaru.tridot.client.model.render.item.CustomItemRenderer;
import pro.komaru.tridot.client.render.DotRenderType;
import pro.komaru.tridot.client.render.RenderBuilder;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.common.ServerTickHandler;
import pro.komaru.tridot.common.compatibility.snakeyaml.internal.Logger;
import pro.komaru.tridot.common.registry.EnchantmentsRegistry;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.struct.Structs;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.func.Boolf;
import pro.komaru.tridot.util.struct.func.Cons;

public class Utils {
    public static ArcRandom rand = Tmp.rnd;
    public static boolean isDevelopment = !FMLLoader.isProduction();

    public static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    public static MinecraftServer server() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static LocalPlayer player() {
        return Utils.mc().f_91074_;
    }

    public static Seq<ServerPlayer> players() {
        return Seq.with(Utils.server().m_6846_().m_11314_());
    }

    public static void player(Cons<ServerPlayer> cons) {
        Utils.players().each(cons);
    }

    public static Object parse(Tag obj) {
        if (obj instanceof ByteTag) {
            ByteTag b = (ByteTag)obj;
            return b.m_7063_();
        }
        if (obj instanceof ShortTag) {
            ShortTag s = (ShortTag)obj;
            return s.m_7053_();
        }
        if (obj instanceof IntTag) {
            IntTag i = (IntTag)obj;
            return i.m_7047_();
        }
        if (obj instanceof LongTag) {
            LongTag l = (LongTag)obj;
            return l.m_7046_();
        }
        if (obj instanceof FloatTag) {
            FloatTag f = (FloatTag)obj;
            return Float.valueOf(f.m_7057_());
        }
        if (obj instanceof DoubleTag) {
            DoubleTag d = (DoubleTag)obj;
            return d.m_7061_();
        }
        if (obj instanceof ByteArrayTag) {
            ByteArrayTag b = (ByteArrayTag)obj;
            return b.m_128227_();
        }
        if (obj instanceof StringTag) {
            StringTag s = (StringTag)obj;
            return s.m_7916_();
        }
        if (obj instanceof ListTag) {
            ListTag l = (ListTag)obj;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Tag tag : l) {
                list.add(Utils.parse(tag));
            }
            return list;
        }
        if (obj instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)obj;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String k : nbt.m_128431_()) {
                map.put(k, Utils.parse(nbt.m_128423_(k)));
            }
            return map;
        }
        try {
            return TagParser.m_129359_((String)obj.toString());
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static Tag parse(Object obj) {
        if (obj instanceof Byte) {
            Byte b = (Byte)obj;
            return ByteTag.m_128266_((byte)b);
        }
        if (obj instanceof Short) {
            Short s = (Short)obj;
            return ShortTag.m_129258_((short)s);
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return IntTag.m_128679_((int)i);
        }
        if (obj instanceof Long) {
            Long l = (Long)obj;
            return LongTag.m_128882_((long)l);
        }
        if (obj instanceof Float) {
            Float f = (Float)obj;
            return FloatTag.m_128566_((float)f.floatValue());
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            return DoubleTag.m_128500_((double)d);
        }
        if (obj instanceof byte[]) {
            byte[] bs = (byte[])obj;
            return new ByteArrayTag(bs);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return StringTag.m_129297_((String)str);
        }
        if (obj instanceof List) {
            List l = (List)obj;
            ListTag tag = new ListTag();
            for (Object o : l) {
                tag.add((Object)Utils.parse(o));
            }
            return tag;
        }
        if (obj instanceof Object[]) {
            Object[] os = (Object[])obj;
            ListTag tag = new ListTag();
            for (Object o : os) {
                tag.add((Object)Utils.parse(o));
            }
            return tag;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            CompoundTag tag = new CompoundTag();
            map.forEach((k, v) -> tag.m_128365_(String.valueOf(k), Utils.parse(v)));
            return tag;
        }
        return EndTag.f_128534_;
    }

    public static void put(CompoundTag nbt, String key, Object obj) {
        nbt.m_128365_(key, Utils.parse(obj));
    }

    public static class Levels {
        public static ServerLevel overworld() {
            return Utils.server().m_129783_();
        }

        public static ServerLevel nether() {
            return Utils.server().m_129880_(Level.f_46429_);
        }

        public static ServerLevel end() {
            return Utils.server().m_129880_(Level.f_46430_);
        }
    }

    public static class Render {
        public static CustomItemRenderer customItemRenderer;
        public static float blitOffset;
        public static int FULL_BRIGHT;
        public static Function<Float, Float> FULL_WIDTH_FUNCTION;
        public static Function<Float, Float> LINEAR_IN_WIDTH_FUNCTION;
        public static Function<Float, Float> LINEAR_OUT_WIDTH_FUNCTION;
        public static Function<Float, Float> LINEAR_IN_ROUND_WIDTH_FUNCTION;
        public static Function<Float, Float> LINEAR_OUT_ROUND_WIDTH_FUNCTION;
        public static Function<Float, Float> LINEAR_IN_SEMI_ROUND_WIDTH_FUNCTION;
        public static Function<Float, Float> LINEAR_OUT_SEMI_ROUND_WIDTH_FUNCTION;

        public static ShaderInstance getShader(RenderType type) {
            if (type instanceof DotRenderType) {
                DotRenderType renderType = (DotRenderType)type;
                Optional shader = renderType.state.f_173274_.f_173136_;
                if (shader.isPresent()) {
                    return (ShaderInstance)((Supplier)shader.get()).get();
                }
            }
            return null;
        }

        public static CustomItemRenderer getCustomItemRenderer() {
            Minecraft minecraft = Minecraft.m_91087_();
            if (customItemRenderer == null) {
                customItemRenderer = new CustomItemRenderer(minecraft, minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors(), minecraft.m_91291_().getBlockEntityRenderer());
            }
            return customItemRenderer;
        }

        public static void renderAura(RenderBuilder builder, PoseStack poseStack, float radius, float size, int longs, boolean floor) {
            Matrix4f last = poseStack.m_85850_().m_252922_();
            RenderBuilder.VertexConsumerActor supplier = builder.getSupplier();
            VertexConsumer vertexConsumer = builder.getVertexConsumer();
            float startU = 0.0f;
            float endU = (float)Math.PI * 2;
            float stepU = (endU - startU) / (float)longs;
            for (int i = 0; i < longs; ++i) {
                float u = (float)i * stepU + startU;
                float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                Vector3f p0 = new Vector3f((float)Math.cos(u) * radius, 0.0f, (float)Math.sin(u) * radius);
                Vector3f p1 = new Vector3f((float)Math.cos(un) * radius, 0.0f, (float)Math.sin(un) * radius);
                float textureU = builder.u0;
                float textureV = builder.v0;
                float textureUN = builder.u1;
                float textureVN = builder.v1;
                if (builder.firstSide) {
                    supplier.placeVertex(vertexConsumer, last, builder, p0.x(), size, p0.z(), builder.r2, builder.g2, builder.b2, builder.a2, textureU, textureVN, builder.l2);
                    supplier.placeVertex(vertexConsumer, last, builder, p1.x(), size, p1.z(), builder.r2, builder.g2, builder.b2, builder.a2, textureUN, textureVN, builder.l2);
                    supplier.placeVertex(vertexConsumer, last, builder, p1.x(), 0.0f, p1.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureUN, textureV, builder.l1);
                    supplier.placeVertex(vertexConsumer, last, builder, p0.x(), 0.0f, p0.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureU, textureV, builder.l1);
                }
                if (builder.secondSide) {
                    supplier.placeVertex(vertexConsumer, last, builder, p0.x(), 0.0f, p0.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureUN, textureV, builder.l1);
                    supplier.placeVertex(vertexConsumer, last, builder, p1.x(), 0.0f, p1.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureU, textureV, builder.l1);
                    supplier.placeVertex(vertexConsumer, last, builder, p1.x(), size, p1.z(), builder.r2, builder.g2, builder.b2, builder.a2, textureU, textureVN, builder.l2);
                    supplier.placeVertex(vertexConsumer, last, builder, p0.x(), size, p0.z(), builder.r2, builder.g2, builder.b2, builder.a2, textureUN, textureVN, builder.l2);
                }
                if (!floor) continue;
                if (builder.firstSide) {
                    supplier.placeVertex(vertexConsumer, last, builder, 0.0f, 0.1f, 0.0f, builder.r2, builder.g2, builder.b2, builder.a2, textureU, textureVN, builder.l2);
                    supplier.placeVertex(vertexConsumer, last, builder, 0.0f, 0.1f, 0.0f, builder.r2, builder.g2, builder.b2, builder.a2, textureUN, textureVN, builder.l2);
                    supplier.placeVertex(vertexConsumer, last, builder, p1.x(), 0.0f, p1.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureUN, textureV, builder.l1);
                    supplier.placeVertex(vertexConsumer, last, builder, p0.x(), 0.0f, p0.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureU, textureV, builder.l1);
                }
                if (!builder.secondSide) continue;
                supplier.placeVertex(vertexConsumer, last, builder, p0.x(), 0.0f, p0.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureUN, textureV, builder.l1);
                supplier.placeVertex(vertexConsumer, last, builder, p1.x(), 0.0f, p1.z(), builder.r1, builder.g1, builder.b1, builder.a1, textureU, textureV, builder.l1);
                supplier.placeVertex(vertexConsumer, last, builder, 0.0f, 0.0f, 0.0f, builder.r2, builder.g2, builder.b2, builder.a2, textureU, textureVN, builder.l2);
                supplier.placeVertex(vertexConsumer, last, builder, 0.0f, 0.0f, 0.0f, builder.r2, builder.g2, builder.b2, builder.a2, textureUN, textureVN, builder.l2);
            }
        }

        public static void renderItemModelInGui(ItemStack stack, float x, float y, float xSize, float ySize, float zSize) {
            Render.renderItemModelInGui(stack, x, y, xSize, ySize, zSize, 0.0f, 0.0f, 0.0f);
        }

        public static void renderItemModelInGui(ItemStack stack, float x, float y, float xSize, float ySize, float zSize, float xRot, float yRot, float zRot) {
            boolean flag;
            Minecraft minecraft = Minecraft.m_91087_();
            BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
            CustomItemRenderer customItemRenderer = Render.getCustomItemRenderer();
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.m_85836_();
            poseStack.m_252880_(x, y, 100.0f + blitOffset);
            poseStack.m_85837_((double)xSize / 2.0, (double)ySize / 2.0, 0.0);
            poseStack.m_85841_(1.0f, -1.0f, 1.0f);
            poseStack.m_85841_(xSize, ySize, zSize);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(zRot));
            RenderSystem.applyModelViewMatrix();
            PoseStack posestack1 = new PoseStack();
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flag = !bakedmodel.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            customItemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            RenderSystem.disableDepthTest();
            multibuffersource$buffersource.m_109911_();
            RenderSystem.enableDepthTest();
            if (flag) {
                Lighting.m_84931_();
            }
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }

        public static void renderFloatingItemModelIntoGUI(GuiGraphics gui, ItemStack stack, float x, float y, float ticks, float ticksUp) {
            boolean flag;
            Minecraft minecraft = Minecraft.m_91087_();
            BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
            CustomItemRenderer customItemRenderer = Render.getCustomItemRenderer();
            float old = bakedmodel.m_7442_().f_111792_.f_111755_.y;
            PoseStack poseStack = gui.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(x + 8.0f, y + 8.0f, 100.0f + (blitOffset += 50.0f));
            poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            poseStack.m_85841_(16.0f, 16.0f, 16.0f);
            poseStack.m_85837_(0.0, Math.sin(Math.toRadians(ticksUp)) * 0.03125, 0.0);
            if (bakedmodel.m_7547_()) {
                bakedmodel.m_7442_().f_111792_.f_111755_.y = ticks;
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(ticks));
            }
            boolean bl = flag = !bakedmodel.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            customItemRenderer.renderItem(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            RenderSystem.disableDepthTest();
            Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
            RenderSystem.enableDepthTest();
            if (flag) {
                Lighting.m_84931_();
            }
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            bakedmodel.m_7442_().f_111792_.f_111755_.y = old;
            blitOffset -= 50.0f;
        }

        public static void renderCustomModel(ModelResourceLocation model, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
            BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(model);
            Minecraft.m_91087_().m_91291_().m_115143_(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42329_), displayContext, leftHand, poseStack, buffer, combinedLight, combinedOverlay, bakedmodel);
        }

        public static void renderBlockModel(ModelResourceLocation model, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
            BakedModel bakedmodel = Minecraft.m_91087_().m_91304_().m_119422_(model);
            Minecraft.m_91087_().m_91291_().m_115143_(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42329_), displayContext, leftHand, poseStack, buffer, combinedLight, combinedOverlay, bakedmodel);
        }

        public static TextureAtlasSprite getBlockSprite(ResourceLocation resourceLocation) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resourceLocation);
        }

        public static TextureAtlasSprite getBlockSprite(String modId, String sprite) {
            return Render.getBlockSprite(new ResourceLocation(modId, sprite));
        }

        public static TextureAtlasSprite getParticleSprite(ResourceLocation resourceLocation) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118260_).apply(resourceLocation);
        }

        public static TextureAtlasSprite getParticleSprite(String modId, String sprite) {
            return Render.getParticleSprite(new ResourceLocation(modId, sprite));
        }

        public static TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resourceLocation);
        }

        public static TextureAtlasSprite getSprite(String modId, String sprite) {
            return Render.getSprite(new ResourceLocation(modId, sprite));
        }

        public static void renderFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light) {
            Render.renderFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light);
        }

        public static void renderFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Col color, boolean flowing, int light) {
            Render.renderFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light);
        }

        public static void renderFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
            if (!fluidStack.isEmpty()) {
                RenderBuilder builder = Render.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
                builder.renderCube(stack, width, height, length);
            }
        }

        public static void renderFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Col color, boolean flowing, int light) {
            if (!fluidStack.isEmpty()) {
                RenderBuilder builder = Render.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
                builder.setColor(color).renderCube(stack, width, height, length);
            }
        }

        public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light) {
            Render.renderCenteredFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light);
        }

        public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Col color, boolean flowing, int light) {
            Render.renderCenteredFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light);
        }

        public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
            if (!fluidStack.isEmpty()) {
                RenderBuilder builder = Render.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
                builder.renderCenteredCube(stack, width, height, length);
            }
        }

        public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Col color, boolean flowing, int light) {
            if (!fluidStack.isEmpty()) {
                RenderBuilder builder = Render.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
                builder.setColor(color).renderCenteredCube(stack, width, height, length);
            }
        }

        public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light, float strength, float time) {
            Render.renderWavyFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light, strength, time);
        }

        public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Col color, boolean flowing, int light, float strength, float time) {
            Render.renderWavyFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light, strength, time);
        }

        public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light, float strength, float time) {
            if (!fluidStack.isEmpty()) {
                RenderBuilder builder = Render.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
                builder.renderWavyCube(stack, width, height, length, strength, time);
            }
        }

        public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Col color, boolean flowing, int light, float strength, float time) {
            if (!fluidStack.isEmpty()) {
                RenderBuilder builder = Render.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
                builder.setColor(color).renderWavyCube(stack, width, height, length, strength, time);
            }
        }

        public static RenderBuilder getFluidRenderBuilder(FluidStack fluidStack, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
            RenderBuilder builder = RenderBuilder.create().setRenderType(TridotRenderTypes.TRANSLUCENT_TEXTURE);
            if (!fluidStack.isEmpty()) {
                FluidType type = fluidStack.getFluid().getFluidType();
                IClientFluidTypeExtensions clientType = IClientFluidTypeExtensions.of((FluidType)type);
                TextureAtlasSprite sprite = Render.getSprite(clientType.getStillTexture(fluidStack));
                if (flowing) {
                    sprite = Render.getSprite(clientType.getFlowingTexture(fluidStack));
                }
                builder.setFirstUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texLength, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texWidth).setSecondUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texWidth, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texHeight).setThirdUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texLength, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texHeight).setColor(new Col(clientType.getTintColor(fluidStack))).setLight(Math.max(type.getLightLevel(fluidStack) << 4, light));
            }
            return builder;
        }

        public static void renderConnectLine(PoseStack stack, Vec3 from, Vec3 to, Col color, float alpha) {
            double dX = to.m_7096_() - from.m_7096_();
            double dY = to.m_7098_() - from.m_7098_();
            double dZ = to.m_7094_() - from.m_7094_();
            double yaw = Math.atan2(dZ, dX);
            double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
            stack.m_85836_();
            stack.m_252781_(Axis.f_252436_.m_252977_((float)Math.toDegrees(-yaw)));
            stack.m_252781_(Axis.f_252403_.m_252977_((float)Math.toDegrees(-pitch) - 180.0f));
            RenderBuilder.create().setRenderType(TridotRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha).renderRay(stack, 0.01f, (float)from.m_82554_(to) + 0.01f);
            stack.m_85849_();
        }

        public static void renderConnectLine(PoseStack stack, BlockPos posFrom, BlockPos posTo, Col color, float alpha) {
            Render.renderConnectLine(stack, posFrom.m_252807_(), posTo.m_252807_(), color, alpha);
        }

        public static void renderConnectLineOffset(PoseStack stack, Vec3 from, Vec3 to, Col color, float alpha) {
            stack.m_85836_();
            stack.m_85837_(from.m_7096_(), from.m_7098_(), from.m_7094_());
            Render.renderConnectLine(stack, from, to, color, alpha);
            stack.m_85849_();
        }

        public static void renderConnectBoxLines(PoseStack stack, Vec3 size, Col color, float alpha) {
            Render.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, 0.0), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(0.0, 0.0, size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, 0.0, 0.0), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, size.m_7098_(), 0.0), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), size.m_7098_(), 0.0), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, size.m_7098_(), size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(0.0, size.m_7098_(), 0.0), new Vec3(size.m_7096_(), size.m_7098_(), 0.0), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), size.m_7098_(), 0.0), new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), new Vec3(0.0, size.m_7098_(), size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(0.0, size.m_7098_(), size.m_7094_()), new Vec3(0.0, size.m_7098_(), 0.0), color, alpha);
            stack.m_85836_();
            stack.m_252880_(0.01f, 0.01f, 0.01f);
            RenderBuilder.create().setRenderType(TridotRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha / 8.0f).enableSided().renderCube(stack, (float)size.m_7096_() - 0.02f, (float)size.m_7098_() - 0.02f, (float)size.m_7094_() - 0.02f);
            stack.m_85849_();
        }

        public static void renderConnectSideLines(PoseStack stack, Vec3 size, Col color, float alpha) {
            Render.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, 0.0), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(0.0, 0.0, size.m_7094_()), color, alpha);
            Render.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, 0.0, 0.0), color, alpha);
            stack.m_85836_();
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            RenderBuilder.create().setRenderType(TridotRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha / 8.0f).enableSided().renderQuad(stack, (float)size.m_7096_(), (float)size.m_7098_());
            stack.m_85849_();
        }

        public static void renderConnectSide(PoseStack stack, Direction side, Col color, float alpha) {
            Vec3 size = new Vec3(1.0, 1.0, 1.0);
            stack.m_85836_();
            stack.m_252880_(0.5f, 0.5f, 0.5f);
            stack.m_252781_(side.m_122424_().m_253075_());
            stack.m_252880_(0.0f, -0.001f, 0.0f);
            stack.m_85837_(-size.m_7096_() / 2.0, -size.m_7098_() / 2.0, -size.m_7094_() / 2.0);
            Render.renderConnectSideLines(stack, size, color, alpha);
            stack.m_85849_();
        }

        public static boolean isFormulaLine(double f, double j, boolean limit, double l) {
            if (limit) {
                return f >= j - l && f <= j + l;
            }
            return false;
        }

        public static Vector3f parametricSphere(float u, float v, float r) {
            return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
        }

        public static Vec2 perpendicularTrailPoints(Vector4f start, Vector4f end, float width) {
            float x = -start.x();
            float y = -start.y();
            if (Math.abs(start.z()) > 0.0f) {
                float ratio = end.z() / start.z();
                x = end.x() + x * ratio;
                y = end.y() + y * ratio;
            } else if (Math.abs(end.z()) <= 0.0f) {
                x += end.x();
                y += end.y();
            }
            if (start.z() > 0.0f) {
                x = -x;
                y = -y;
            }
            if (x * x + y * y > 0.0f) {
                float normalize = width * 0.5f / Render.distance(x, y);
                x *= normalize;
                y *= normalize;
            }
            return new Vec2(-y, x);
        }

        public static float distance(float ... a) {
            return Mth.m_14116_((float)Render.distSqr(a));
        }

        public static float distSqr(float ... a) {
            float d = 0.0f;
            for (float f : a) {
                d += f * f;
            }
            return d;
        }

        public static void applyWobble(Vector3f[] offsets, float strength, float gameTime) {
            float offset = 0.0f;
            for (Vector3f vector3f : offsets) {
                double time = (double)(gameTime / 40.0f) % Math.PI * 2.0;
                float sine = Mth.m_14031_((float)((float)(time + (double)offset * Math.PI * 2.0))) * strength;
                vector3f.add(sine, -sine, 0.0f);
                offset += 0.25f;
            }
        }

        static {
            blitOffset = 0.0f;
            FULL_BRIGHT = 0xF000F0;
            FULL_WIDTH_FUNCTION = f -> Float.valueOf(1.0f);
            LINEAR_IN_WIDTH_FUNCTION = f -> f;
            LINEAR_OUT_WIDTH_FUNCTION = f -> Float.valueOf(1.0f - f.floatValue());
            LINEAR_IN_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 1.0f ? 0.0f : f.floatValue());
            LINEAR_OUT_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 0.0f ? 0.0f : 1.0f - f.floatValue());
            LINEAR_IN_SEMI_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 1.0f ? 0.5f : f.floatValue());
            LINEAR_OUT_SEMI_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 0.0f ? 0.5f : 1.0f - f.floatValue());
        }
    }

    public static class Text {
        public static String cleanText(String text) {
            return text.replaceAll("[^\\p{L}\\p{N}\\s]+", "").toLowerCase();
        }

        public static Component formatf(String template, Object ... values) {
            return Component.m_237113_((String)Text.format(template, values));
        }

        public static String format(String template, Object ... values) {
            return Text.format(template, Structs.map(values));
        }

        public static String format(String template, Map<String, Object> values) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String placeholder = "$" + entry.getKey();
                template = template.replace(placeholder, entry.getValue().toString());
            }
            return template;
        }
    }

    public static class Schedule {
        private static ScheduledExecutorService scheduler = null;
        private static final HashMultimap<Integer, Runnable> scheduledSynchTasks = HashMultimap.create();

        public static void syncTask(Runnable run, int ticks) {
            scheduledSynchTasks.put((Object)(ServerTickHandler.tick + ticks), (Object)run);
        }

        public static void asyncTask(Runnable run, int time, TimeUnit unit) {
            if (scheduler == null) {
                Schedule.serverStartupTasks();
            }
            scheduler.schedule(run, (long)time, unit);
        }

        public static void serverStartupTasks() {
            if (scheduler != null) {
                scheduler.shutdownNow();
            }
            scheduler = Executors.newScheduledThreadPool(1);
            Schedule.handleSyncScheduledTasks(null);
        }

        public static void handleSyncScheduledTasks(@Nullable Integer tick) {
            if (scheduledSynchTasks.containsKey((Object)tick)) {
                Iterator tasks;
                Iterator iterator = tasks = tick == null ? scheduledSynchTasks.values().iterator() : scheduledSynchTasks.get((Object)tick).iterator();
                while (tasks.hasNext()) {
                    try {
                        ((Runnable)tasks.next()).run();
                    }
                    catch (Exception ex) {
                        Logger.getLogger("Scheduler").warn(ex.getMessage());
                    }
                    tasks.remove();
                }
            }
        }
    }

    public static class Entities {
        public static boolean canHitTarget(LivingEntity target, LivingEntity attacker) {
            return Entities.canHitTarget(target, attacker, 100.0f);
        }

        public static boolean canHitTarget(LivingEntity target, LivingEntity attacker, float amount) {
            DamageSource source = Entities.createDamageSource(attacker);
            LivingAttackEvent event = new LivingAttackEvent(target, source, amount);
            return !MinecraftForge.EVENT_BUS.post((Event)event);
        }

        public static DamageSource createDamageSource(LivingEntity attacker) {
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                return attacker.m_269291_().m_269075_(player);
            }
            return attacker.m_269291_().m_269333_(attacker);
        }

        public static void applyWithChance(LivingEntity pTarget, ImmutableList<MobEffectInstance> effects, float chance, ArcRandom arcRandom) {
            block2: {
                block3: {
                    if (effects.isEmpty()) break block2;
                    if (!(chance < 1.0f)) break block3;
                    if (!arcRandom.chance(chance)) break block2;
                    for (MobEffectInstance effectInstance : effects) {
                        pTarget.m_7292_(new MobEffectInstance(effectInstance));
                    }
                    break block2;
                }
                for (MobEffectInstance effectInstance : effects) {
                    pTarget.m_7292_(new MobEffectInstance(effectInstance));
                }
            }
        }
    }

    public static class Physics {
        public static void homingTo(double strength, Entity projectile, Level level, Entity pOwner, AABB boundingBox) {
            if (level.f_46443_) {
                return;
            }
            List targets = level.m_45976_(LivingEntity.class, boundingBox);
            LivingEntity nearest = null;
            double nearestDist = Double.MAX_VALUE;
            for (LivingEntity target : targets) {
                double dist;
                if (target == pOwner || !target.m_6084_() || !((dist = projectile.m_20280_((Entity)target)) < nearestDist)) continue;
                nearest = target;
                nearestDist = dist;
            }
            if (nearest != null) {
                Vec3 currentVelocity = projectile.m_20184_();
                Vec3 toTarget = nearest.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82546_(projectile.m_20182_()).m_82541_();
                Vec3 newVelocity = currentVelocity.m_82549_(toTarget.m_82490_(strength)).m_82541_().m_82490_(currentVelocity.m_82553_());
                projectile.m_20256_(newVelocity);
                projectile.f_19864_ = true;
            }
        }

        public static BlockPos nearbySurface(Level pLevel, BlockPos pos, LivingEntity entity) {
            return Physics.nearbySurface(pLevel, pos, entity, 1);
        }

        public static BlockPos nearbySurface(Level pLevel, BlockPos pos, LivingEntity entity, int iterations) {
            int z;
            int y;
            int x = pos.m_123341_() + (rand.nextInt() - rand.nextInt()) * 6;
            if (pLevel.m_45756_((Entity)entity, new AABB((double)x, (double)(y = pos.m_123342_() + rand.nextInt(1, 2)), (double)(z = pos.m_123343_() + (rand.nextInt() - rand.nextInt()) * 6), (double)x, (double)y, (double)z).m_82400_(1.0))) {
                return new BlockPos(x, y, z);
            }
            if (iterations > 1) {
                return Physics.nearbySurface(pLevel, pos, entity, iterations - 1);
            }
            return null;
        }
    }

    public static class Items {
        public static Item getItem(String modId, String id) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, id));
            return item != null ? item : net.minecraft.world.item.Items.f_42329_;
        }

        public static boolean getAttackStrengthScale(Player player, float powerPercent) {
            float f2 = player.m_36403_(0.5f);
            return f2 > powerPercent;
        }

        public static void cooldownItems(Player player, List<Item> items, int cooldownTicks) {
            for (Item pItems : items) {
                player.m_36335_().m_41524_(pItems, cooldownTicks);
            }
        }

        public static float enchantmentRadius(ItemStack stack) {
            int i = stack.getEnchantmentLevel((Enchantment)EnchantmentsRegistry.RADIUS.get());
            return i > 0 ? (float)i / 2.0f : 0.0f;
        }

        public static void addSkinTooltip(ItemStack stack, List<Component> tooltip) {
            ItemSkin skin = ItemSkin.itemSkin(stack);
            if (skin != null) {
                if (skin.getHoverName() != null) {
                    tooltip.remove(0);
                    tooltip.add(0, (Component)Component.m_237113_((String)stack.m_41786_().getString()).m_7220_(skin.getHoverName()));
                }
                tooltip.add(1, skin.skinComponent());
                tooltip.add(2, (Component)Component.m_237119_());
                if (skin.getComponents() != null) {
                    tooltip.addAll(skin.getComponents());
                }
            }
        }

        public static ItemStack getProjectile(Player player, ItemStack shootable, Boolf<ItemStack> predicate) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack ammo = player.m_150109_().m_8020_(i);
                if (!predicate.get(ammo)) continue;
                return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)shootable, (ItemStack)ammo);
            }
            return player.m_7500_() ? net.minecraft.world.item.Items.f_42594_.m_7968_() : ItemStack.f_41583_;
        }

        public static ItemStack getProjectile(Player player, ItemStack shootable, TagKey<Item> tag) {
            Boolf<ItemStack> predicate = stack -> stack.m_204117_(tag);
            return Items.getProjectile(player, shootable, predicate);
        }

        public static void effectTooltip(ImmutableList<MobEffectInstance> effects, List<Component> tooltipList, float duration, float chance) {
            if (!effects.isEmpty()) {
                if (chance > 0.0f && chance < 1.0f) {
                    tooltipList.add((Component)Component.m_237110_((String)"tooltip.tridot.applies_with_chance", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(chance * 100.0f))}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltipList.add((Component)Component.m_237115_((String)"tooltip.tridot.applies").m_130940_(ChatFormatting.GRAY));
                }
                Items.effectLines(effects, tooltipList, duration);
            }
        }

        public static void effectTargetTooltip(ImmutableList<MobEffectInstance> effects, List<Component> tooltipList, float duration, float chance) {
            if (!effects.isEmpty()) {
                if (chance > 0.0f && chance < 1.0f) {
                    tooltipList.add((Component)Component.m_237110_((String)"tooltip.tridot.applies_with_chance_target", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(chance * 100.0f))}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltipList.add((Component)Component.m_237115_((String)"tooltip.tridot.applies_to_target").m_130940_(ChatFormatting.GRAY));
                }
                Items.effectLines(effects, tooltipList, duration);
            }
        }

        private static void effectLines(ImmutableList<MobEffectInstance> effects, List<Component> tooltipList, float duration) {
            for (MobEffectInstance mobeffectinstance : effects) {
                MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                if (mobeffectinstance.m_19564_() > 0) {
                    mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
                }
                if (!mobeffectinstance.m_267633_(20)) {
                    mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)duration)});
                }
                tooltipList.add((Component)Component.m_237113_((String)" \u2666 ").m_130940_(mobeffect.m_19483_().m_19497_()).m_7220_((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_())));
            }
        }

        public static LootTable getTable(ServerLevel pServer, ResourceLocation pLoot) {
            return pServer.m_7654_().m_278653_().m_278676_(pLoot);
        }

        public static void dropLoot(Player pPlayer, Collection<ItemStack> pItemStacks) {
            for (ItemStack stack : pItemStacks) {
                pPlayer.m_36176_(stack, false);
            }
        }

        public static void giveLoot(ServerPlayer pPlayer, Collection<ItemStack> pItemStacks) {
            for (ItemStack stack : pItemStacks) {
                if (pPlayer.m_150109_().m_36054_(stack)) continue;
                pPlayer.m_36176_(stack, false);
            }
        }

        public static void spawnLoot(Level pLevel, BlockPos pPos, Collection<ItemStack> pItemStacks) {
            if (!pLevel.m_5776_()) {
                for (ItemStack stack : pItemStacks) {
                    pLevel.m_7967_((Entity)new ItemEntity(pLevel, (double)((float)pPos.m_123341_() + 0.5f), (double)((float)pPos.m_123342_() + 0.5f), (double)((float)pPos.m_123343_() + 0.5f), stack));
                }
            }
        }

        @Nonnull
        public static List<ItemStack> createLoot(ResourceLocation pLoot, LootParams pParams) {
            LootTable loot = Items.getTable(pParams.m_287182_(), pLoot);
            if (loot == LootTable.f_79105_) {
                return Lists.newArrayList();
            }
            return loot.m_287195_(pParams);
        }

        public static LootParams getGiftParameters(ServerLevel pLevel, Vec3 pPos, Entity pEntity) {
            return Items.getGiftParameters(pLevel, pPos, 0.0f, pEntity);
        }

        public static LootParams getGiftParameters(ServerLevel pLevel, Vec3 pPos, float pLuckValue, Entity pEntity) {
            return new LootParams.Builder(pLevel).m_287286_(LootContextParams.f_81455_, (Object)pEntity).m_287286_(LootContextParams.f_81460_, (Object)pPos).m_287239_(pLuckValue).m_287235_(LootContextParamSets.f_81416_);
        }

        public static void clearItem(Player player, ItemStack stack) {
            Item item = stack.m_41720_();
            int count = stack.m_41613_();
            Inventory inv = player.m_150109_();
            inv.m_36022_(i -> i.m_41720_().equals(item), count, (Container)player.f_36095_.m_39730_());
        }

        public static void giveItem(Player player, ItemStack stack) {
            ItemStack outputCopy = stack.m_41777_();
            int k = outputCopy.m_41613_();
            int i = outputCopy.m_41741_();
            while (k > 0) {
                int l = Math.min(i, k);
                k -= l;
                ItemStack itemstack1 = outputCopy.m_41777_();
                itemstack1.m_41764_(l);
                boolean flag = player.m_150109_().m_36054_(itemstack1);
                if (flag && itemstack1.m_41619_()) {
                    itemstack1.m_41764_(1);
                    ItemEntity itementity1 = player.m_36176_(itemstack1, false);
                    if (itementity1 != null) {
                        itementity1.m_32065_();
                    }
                    player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                    player.f_36096_.m_38946_();
                    continue;
                }
                ItemEntity itementity = player.m_36176_(itemstack1, false);
                if (itementity == null) continue;
                itementity.m_32061_();
                itementity.m_266426_(player.m_20148_());
            }
        }

        public static FluidStack deserializeFluidStack(JsonObject json) {
            String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
            if (fluid == null || fluid == Fluids.f_76191_) {
                throw new JsonSyntaxException("Unknown fluid " + fluidName);
            }
            int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
            return new FluidStack(fluid, amount);
        }

        public static MobEffectInstance deserializeMobEffect(JsonObject json) {
            String effectName = GsonHelper.m_13906_((JsonObject)json, (String)"effect");
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
            if (mobEffect == null) {
                throw new JsonSyntaxException("Unknown effect " + effectName);
            }
            int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
            int amplifier = GsonHelper.m_13927_((JsonObject)json, (String)"amplifier");
            return new MobEffectInstance(mobEffect, duration, amplifier);
        }

        public static MobEffectInstance mobEffectFromNetwork(FriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                MobEffect mobEffect = (MobEffect)buffer.readRegistryId();
                int duration = buffer.readInt();
                int amplifier = buffer.readInt();
                return new MobEffectInstance(mobEffect, duration, amplifier);
            }
            return null;
        }

        public static void mobEffectToNetwork(MobEffectInstance effect, FriendlyByteBuf buffer) {
            if (effect == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeRegistryId(ForgeRegistries.MOB_EFFECTS, (Object)effect.m_19544_());
                buffer.writeInt(effect.m_19557_());
                buffer.writeInt(effect.m_19564_());
            }
        }

        public static Enchantment deserializeEnchantment(JsonObject json) {
            String enchantmentName = GsonHelper.m_13906_((JsonObject)json, (String)"enchantment");
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentName));
            if (enchantment == null) {
                throw new JsonSyntaxException("Unknown enchantment " + enchantmentName);
            }
            return enchantment;
        }

        public static Enchantment enchantmentFromNetwork(FriendlyByteBuf buffer) {
            return !buffer.readBoolean() ? null : (Enchantment)buffer.readRegistryId();
        }

        public static void enchantmentToNetwork(Enchantment enchantment, FriendlyByteBuf buffer) {
            if (enchantment == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeRegistryId(ForgeRegistries.ENCHANTMENTS, (Object)enchantment);
            }
        }
    }

    public static class Hit {
        public static float seenPercent(Vec3 pVector, Entity pEntity, float pStrength) {
            AABB aabb = pEntity.m_20191_();
            double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
            double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
            double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
            double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
            double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
            if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
                int i = 0;
                int j = 0;
                for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                    for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                        for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                            double d8 = Mth.m_14139_((double)d5, (double)aabb.f_82288_, (double)aabb.f_82291_);
                            double d9 = Mth.m_14139_((double)d6, (double)aabb.f_82289_, (double)aabb.f_82292_);
                            double d10 = Mth.m_14139_((double)d7, (double)aabb.f_82290_, (double)aabb.f_82293_);
                            Vec3 vec3 = new Vec3(d8 + d3, d9, d10 + d4);
                            if (pEntity.m_9236_().m_45547_(new ClipContext(vec3, pVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, pEntity)).m_6662_() == HitResult.Type.MISS) {
                                ++i;
                            }
                            ++j;
                        }
                    }
                }
                return (float)i / (float)j * pStrength;
            }
            return pStrength;
        }

        public static void circularHit(Level level, Player player) {
            List list = level.m_45933_((Entity)player, player.m_20191_().m_82400_(1.0));
            float damage = (float)player.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44821_((LivingEntity)player);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)entity;
                    target.m_6469_(level.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)player.m_21211_(), (MobType)target.m_6336_())) * 1.35f);
                }
            }
        }

        public static void circularHit(Level level, Player player, double inflateValue) {
            List list = level.m_45933_((Entity)player, player.m_20191_().m_82400_(inflateValue));
            float damage = (float)player.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44821_((LivingEntity)player);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)entity;
                    target.m_6469_(level.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)player.m_21211_(), (MobType)target.m_6336_())) * 1.35f);
                }
            }
        }

        public static void circularHit(Level level, ItemStack stack, Player player, @Nullable ParticleOptions type, List<LivingEntity> hitEntities, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
            for (int i = 0; i < 360; i += 10) {
                double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
                float pRadius = radius + Items.enchantmentRadius(stack);
                double X2 = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)pRadius;
                double Y2 = Math.cos(pitch) * (double)pRadius;
                double Z2 = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)pRadius;
                AABB boundingBox = new AABB(pos.x, pos.y - 1.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2);
                List entities = level.m_45976_(Entity.class, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)player) || !Entities.canHitTarget((LivingEntity)player, livingEntity)) continue;
                    hitEntities.add(livingEntity);
                }
                X2 = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)pRadius * 0.75;
                Y2 = Math.cos(pitch) * (double)pRadius * 0.75;
                Z2 = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)pRadius * 0.75;
                if (type == null || level.m_5776_() || !(level instanceof ServerLevel)) continue;
                ServerLevel pServer = (ServerLevel)level;
                pServer.m_8767_(type, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        public static void circularHit(Level level, Player player, @Nullable ParticleOptions type, List<LivingEntity> hitEntities, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
            for (int i = 0; i < 360; i += 10) {
                double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
                double X2 = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)radius;
                double Y2 = Math.cos(pitch) * (double)radius;
                double Z2 = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)radius;
                AABB boundingBox = new AABB(pos.x, pos.y - 1.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2);
                List entities = level.m_45976_(Entity.class, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)player) || !Entities.canHitTarget((LivingEntity)player, livingEntity)) continue;
                    hitEntities.add(livingEntity);
                }
                X2 = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)radius * 0.75;
                Y2 = Math.cos(pitch) * (double)radius * 0.75;
                Z2 = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)radius * 0.75;
                if (type == null || level.m_5776_() || !(level instanceof ServerLevel)) continue;
                ServerLevel pServer = (ServerLevel)level;
                pServer.m_8767_(type, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        public static void hitLast(Level pLevel, Player pPlayer, float pAmount) {
            LivingEntity lastHurtMob = pPlayer.m_271686_();
            if (!pLevel.m_5776_() && pLevel instanceof ServerLevel) {
                ServerLevel pServer = (ServerLevel)pLevel;
                if (lastHurtMob == null) {
                    return;
                }
                lastHurtMob.m_6469_(pServer.m_269111_().m_269075_(pPlayer), pAmount);
            }
        }

        public static void markNearbyMobs(Level pLevel, Player pPlayer, List<LivingEntity> hitEntities, Vec3 pos, float pitchRaw, float yawRaw, float radius) {
            double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
            double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
            double X2 = Math.sin(pitch) * Math.cos(yaw) * (double)radius;
            double Y2 = Math.cos(pitch) * (double)radius;
            double Z2 = Math.sin(pitch) * Math.sin(yaw) * (double)radius;
            AABB boundingBox = new AABB(pos.f_82479_, pos.f_82480_ - 8.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.f_82481_, pos.f_82479_ + X2, pos.f_82480_ + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.f_82481_ + Z2);
            List entities = pLevel.m_45976_(Entity.class, boundingBox);
            for (Entity entity : entities) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)pPlayer)) continue;
                hitEntities.add(livingEntity);
                if (!livingEntity.m_6084_()) {
                    return;
                }
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40, 0, false, false, false));
            }
        }

        public static void healNearbyMobs(MobCategory pType, Float pHeal, Level pLevel, LivingEntity pHealer, List<LivingEntity> hitEntities, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
            for (int i = 0; i < 360; i += 10) {
                double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
                double X2 = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)radius;
                double Y2 = Math.cos(pitch) * (double)radius;
                double Z2 = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)radius;
                AABB boundingBox = new AABB(pos.x, pos.y - 8.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2);
                List entities = pLevel.m_45976_(Entity.class, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)pHealer) || !pType.equals((Object)entity.m_6095_().m_20674_())) continue;
                    hitEntities.add(livingEntity);
                    if (!livingEntity.m_6084_()) {
                        return;
                    }
                    livingEntity.m_5634_(pHeal.floatValue());
                }
            }
        }

        public static void healNearbyMobs(float pHeal, Level pLevel, LivingEntity pHealer, List<LivingEntity> hitEntities, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
            for (int i = 0; i < 360; i += 10) {
                double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
                double X2 = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)radius;
                double Y2 = Math.cos(pitch) * (double)radius;
                double Z2 = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)radius;
                AABB boundingBox = new AABB(pos.x, pos.y - 8.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2);
                List entities = pLevel.m_45976_(Entity.class, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)pHealer)) continue;
                    hitEntities.add(livingEntity);
                    if (!livingEntity.m_6084_()) {
                        return;
                    }
                    livingEntity.m_5634_(pHeal);
                }
            }
        }

        public static HitResult hitResult(Vec3 from, Entity entity, Predicate<Entity> filter, Vec3 to, Level level) {
            EntityHitResult result;
            Vec3 vec3 = from.m_82549_(to);
            BlockHitResult hitresult = level.m_45547_(new ClipContext(from, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec3 = hitresult.m_82450_();
            }
            if ((result = ProjectileUtil.m_37304_((Level)level, (Entity)entity, (Vec3)from, (Vec3)vec3, (AABB)entity.m_20191_().m_82369_(to).m_82400_(1.0), filter)) != null) {
                hitresult = result;
            }
            return hitresult;
        }

        public static void explosion(Player player, ItemStack itemstack, Vec3 pos, Vec3 clipPos, float radius, float damage, float knockback) {
            Level level = player.m_9236_();
            RandomSource rand = level.f_46441_;
            List entities = level.m_45976_(Entity.class, new AABB(pos.f_82479_ + clipPos.f_82479_ - (double)radius, pos.f_82480_ + clipPos.f_82480_ - (double)radius, pos.f_82481_ + clipPos.f_82481_ - (double)radius, pos.f_82479_ + clipPos.f_82479_ + (double)radius, pos.f_82480_ + clipPos.f_82480_ + (double)radius, pos.f_82481_ + clipPos.f_82481_ + (double)radius));
            for (Entity entity : entities) {
                LivingEntity enemy;
                if (!(entity instanceof LivingEntity) || (enemy = (LivingEntity)entity).equals((Object)player)) continue;
                enemy.m_6469_(level.m_269111_().m_269036_((Entity)player, (Entity)player), damage);
                enemy.m_147240_((double)knockback, player.m_20185_() + clipPos.f_82479_ - entity.m_20185_(), player.m_20189_() + clipPos.f_82481_ - entity.m_20189_());
                if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44981_, (ItemStack)itemstack) <= 0) continue;
                int i = EnchantmentHelper.m_44914_((LivingEntity)player);
                enemy.m_20254_(i * 4);
            }
            if (level instanceof ServerLevel) {
                ServerLevel srv = (ServerLevel)level;
                srv.m_8767_((ParticleOptions)ParticleTypes.f_123812_, pos.f_82479_ + clipPos.f_82479_, pos.f_82480_ + clipPos.f_82480_, player.m_20189_() + clipPos.f_82481_, 1, 0.0, 0.0, 0.0, (double)radius);
                srv.m_5594_(null, player.m_20183_().m_7918_((int)clipPos.f_82479_, (int)(clipPos.f_82480_ + (double)player.m_20192_()), (int)clipPos.f_82481_), SoundEvents.f_11913_, SoundSource.AMBIENT, 10.0f, 1.0f);
                srv.m_8767_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_ + clipPos.f_82479_ + (rand.m_188500_() - 0.5) * (double)radius, pos.f_82480_ + clipPos.f_82480_ + (rand.m_188500_() - 0.5) * (double)radius, pos.f_82481_ + clipPos.f_82481_ + (rand.m_188500_() - 0.5) * (double)radius, 8, 0.05 * ((rand.m_188500_() - 0.5) * (double)radius), 0.05 * ((rand.m_188500_() - 0.5) * (double)radius), 0.05 * ((rand.m_188500_() - 0.5) * (double)radius), (double)0.2f);
                srv.m_8767_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_ + clipPos.f_82479_ + (rand.m_188500_() - 0.5) * (double)radius, pos.f_82480_ + clipPos.f_82480_ + (rand.m_188500_() - 0.5) * (double)radius, pos.f_82481_ + clipPos.f_82481_ + (rand.m_188500_() - 0.5) * (double)radius, 6, 0.05 * ((rand.m_188500_() - 0.5) * (double)radius), 0.05 * ((rand.m_188500_() - 0.5) * (double)radius), 0.05 * ((rand.m_188500_() - 0.5) * (double)radius), (double)0.2f);
            }
        }
    }

    public static class Blocks {
        public static void endShapedPortal(int pSize, Level pDestination, BlockPos pPos, BlockState pPortal, BlockState pFrame) {
            int j;
            int i;
            for (i = 0; i < pSize - 1; ++i) {
                for (j = 0; j < pSize - 1; ++j) {
                    pDestination.m_7731_(pPos.m_7918_(i, 0, j), pPortal, 2);
                }
            }
            for (i = 0; i < pSize; ++i) {
                for (j = 0; j < pSize; ++j) {
                    if (i != 0 && i != pSize - 1 && j != 0 && j != pSize - 1) continue;
                    pDestination.m_7731_(pPos.m_7918_(i, 0, j), pFrame, 2);
                }
            }
        }

        public static boolean growCrop(ItemStack stack, Level level, BlockPos blockPos) {
            if (BoneMealItem.m_40627_((ItemStack)stack, (Level)level, (BlockPos)blockPos)) {
                return true;
            }
            BlockState blockstate = level.m_8055_(blockPos);
            boolean flag = blockstate.m_60783_((BlockGetter)level, blockPos, Direction.UP);
            return flag && BoneMealItem.m_40631_((ItemStack)stack, (Level)level, (BlockPos)blockPos.m_121945_(Direction.UP), (Direction)Direction.UP);
        }

        public static boolean growCrop(Level level, BlockPos blockPos) {
            return Blocks.growCrop(ItemStack.f_41583_, level, blockPos);
        }

        public static ToIntFunction<BlockState> light(int pValue) {
            return state -> !state.m_60795_() ? pValue : 0;
        }

        public static ToIntFunction<BlockState> lightIfLit(int pValue) {
            return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? pValue : 0;
        }

        public static ToIntFunction<BlockState> lightIfLit() {
            return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 14 : 0;
        }

        public static ToIntFunction<BlockState> plantLight() {
            return state -> !state.m_60795_() ? 12 : 0;
        }
    }

    public static class Particles {
        public static void inRadius(Level level, @Nullable ItemStack stack, ParticleOptions type, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
            float pRadius = stack != null ? radius + Items.enchantmentRadius(stack) : radius;
            for (int i = 0; i < 360; i += 10) {
                double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
                double yaw = (double)((float)i + yawRaw + 90.0f) * Math.PI / 180.0;
                double X2 = Math.sin(pitch) * Math.cos(yaw) * (double)pRadius * 0.75;
                double Y2 = Math.cos(pitch) * (double)pRadius * 0.75;
                double Z2 = Math.sin(pitch) * Math.sin(yaw) * (double)pRadius * 0.75;
                if (level.m_5776_() || !(level instanceof ServerLevel)) continue;
                ServerLevel pServer = (ServerLevel)level;
                pServer.m_8767_(type, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        public static void mark(Level level, Player player, List<LivingEntity> hitEntities, ParticleOptions type, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
            for (int i = 0; i < 360; i += 10) {
                double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
                double yaw = (double)((float)i + yawRaw + 90.0f) * Math.PI / 180.0;
                double X2 = Math.sin(pitch) * Math.cos(yaw) * (double)radius;
                double Y2 = Math.cos(pitch) * (double)radius;
                double Z2 = Math.sin(pitch) * Math.sin(yaw) * (double)radius;
                AABB boundingBox = new AABB(pos.x, pos.y - 8.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z, pos.x + X2, pos.y + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.z + Z2);
                List entities = level.m_45976_(Entity.class, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)player)) continue;
                    hitEntities.add(livingEntity);
                    if (!livingEntity.m_6084_()) {
                        return;
                    }
                    if (level.m_5776_() || !(level instanceof ServerLevel)) continue;
                    ServerLevel pServer = (ServerLevel)level;
                    pServer.m_8767_(type, livingEntity.m_20185_(), livingEntity.m_20186_() + 2.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public static void around(Vector3d pos, float distance, float speed, Level level, ParticleOptions options) {
            RandomSource source = RandomSource.m_216327_();
            for (int i = 0; i < 360; i += 10) {
                double X2 = (rand.nextDouble() - 0.5) * (double)distance;
                double Y2 = (rand.nextDouble() - 0.5) * (double)distance;
                double Z2 = (rand.nextDouble() - 0.5) * (double)distance;
                double dX = -X2;
                double dY = -Y2;
                double dZ = -Z2;
                if (level.m_5776_() || !(level instanceof ServerLevel)) continue;
                ServerLevel pServer = (ServerLevel)level;
                for (int ii = 0; ii < 1 + Mth.m_216271_((RandomSource)source, (int)0, (int)2); ++ii) {
                    double yaw = Math.atan2(dZ, dX) + (double)i;
                    double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                    double XX = Math.sin(pitch) * Math.cos(yaw) * (double)speed / (double)(ii + 1);
                    double YY = Math.sin(pitch) * Math.sin(yaw) * (double)speed / (double)(ii + 1);
                    double ZZ = Math.cos(pitch) * (double)speed / (double)(ii + 1);
                    pServer.m_8767_(options, pos.x + X2, pos.y + Y2, pos.z + Z2, 1, XX, YY, ZZ, 0.0);
                }
            }
        }

        public static void lineToAttacked(Level pLevel, Player pPlayer, ParticleOptions pType, int pDuration) {
            LivingEntity lastHurtMob = pPlayer.m_271686_();
            if (!pLevel.m_5776_() && pLevel instanceof ServerLevel) {
                ServerLevel pServer = (ServerLevel)pLevel;
                if (lastHurtMob == null) {
                    return;
                }
                Vec3 pos = new Vec3(pPlayer.m_20185_(), pPlayer.m_20186_() + 0.5, pPlayer.m_20189_());
                Vec3 EndPos = new Vec3(lastHurtMob.m_20185_(), lastHurtMob.m_20186_() + 0.5, lastHurtMob.m_20189_());
                double distance = pos.m_82554_(EndPos);
                double distanceInBlocks = Math.floor(distance);
                pDuration = 0;
                while ((double)pDuration < distanceInBlocks) {
                    double dX = pos.f_82479_ - EndPos.f_82479_;
                    double dY = pos.f_82480_ - EndPos.f_82480_;
                    double dZ = pos.f_82481_ - EndPos.f_82481_;
                    float x = (float)(dX / distanceInBlocks);
                    float y = (float)(dY / distanceInBlocks);
                    float z = (float)(dZ / distanceInBlocks);
                    pServer.m_8767_(pType, pos.f_82479_ - (double)(x * (float)pDuration), pos.f_82480_ - (double)(y * (float)pDuration), pos.f_82481_ - (double)(z * (float)pDuration), 1, 0.0, 0.0, 0.0, 0.0);
                    ++pDuration;
                }
            }
        }

        public static void lineToAttacked(Level pLevel, Player pPlayer, ParticleOptions pType) {
            LivingEntity lastHurtMob = pPlayer.m_271686_();
            if (!pLevel.m_5776_() && pLevel instanceof ServerLevel) {
                ServerLevel pServer = (ServerLevel)pLevel;
                if (lastHurtMob == null) {
                    return;
                }
                Vec3 pos = new Vec3(pPlayer.m_20185_(), pPlayer.m_20186_() + 0.5, pPlayer.m_20189_());
                Vec3 EndPos = new Vec3(lastHurtMob.m_20185_(), lastHurtMob.m_20186_() + 0.5, lastHurtMob.m_20189_());
                double distance = pos.m_82554_(EndPos);
                double distanceInBlocks = Math.floor(distance);
                int i = 0;
                while ((double)i < distanceInBlocks) {
                    double dX = pos.f_82479_ - EndPos.f_82479_;
                    double dY = pos.f_82480_ - EndPos.f_82480_;
                    double dZ = pos.f_82481_ - EndPos.f_82481_;
                    float x = (float)(dX / distanceInBlocks);
                    float y = (float)(dY / distanceInBlocks);
                    float z = (float)(dZ / distanceInBlocks);
                    pServer.m_8767_(pType, pos.f_82479_ - (double)(x * (float)i), pos.f_82480_ - (double)(y * (float)i), pos.f_82481_ - (double)(z * (float)i), 1, 0.0, 0.0, 0.0, 0.0);
                    ++i;
                }
            }
        }

        public static void lineToNearby(Level pLevel, Player pPlayer, ParticleOptions pType, List<LivingEntity> hitEntities, Vec3 pos, float pitchRaw, float yawRaw, float radius) {
            double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
            double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
            double X2 = Math.sin(pitch) * Math.cos(yaw) * (double)radius;
            double Y2 = Math.cos(pitch) * (double)radius;
            double Z2 = Math.sin(pitch) * Math.sin(yaw) * (double)radius;
            AABB boundingBox = new AABB(pos.f_82479_, pos.f_82480_ - 8.0 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.f_82481_, pos.f_82479_ + X2, pos.f_82480_ + Y2 + ((double)rand.nextFloat() - 0.5) * (double)0.2f, pos.f_82481_ + Z2);
            List entities = pLevel.m_45976_(Entity.class, boundingBox);
            for (Entity entity : entities) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)pPlayer)) continue;
                hitEntities.add(livingEntity);
                if (!livingEntity.m_6084_()) {
                    return;
                }
                Vec3 pTo = new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                double distance = pos.m_82554_(pTo);
                double distanceInBlocks = Math.floor(distance);
                int i = 0;
                while ((double)i < distanceInBlocks) {
                    double dX = pos.f_82479_ - pTo.f_82479_;
                    double dY = pos.f_82480_ - pTo.f_82480_;
                    double dZ = pos.f_82481_ - pTo.f_82481_;
                    float x = (float)(dX / distanceInBlocks);
                    float y = (float)(dY / distanceInBlocks);
                    float z = (float)(dZ / distanceInBlocks);
                    if (!pLevel.m_5776_() && pLevel instanceof ServerLevel) {
                        ServerLevel pServer = (ServerLevel)pLevel;
                        pServer.m_8767_(pType, pos.f_82479_ - (double)(x * (float)i), pos.f_82480_ - (double)(y * (float)i), pos.f_82481_ - (double)(z * (float)i), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    ++i;
                }
                for (i = 0; i < 3; ++i) {
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123796_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }

        public static void line(Level pLevel, Vec3 pFrom, Vec3 pTo, ParticleOptions pType) {
            double distance = pFrom.m_82554_(pTo);
            double distanceInBlocks = Math.floor(distance);
            int i = 0;
            while ((double)i < distanceInBlocks) {
                double dX = pFrom.f_82479_ - pTo.f_82479_;
                double dY = pFrom.f_82480_ - pTo.f_82480_;
                double dZ = pFrom.f_82481_ - pTo.f_82481_;
                float x = (float)(dX / distanceInBlocks);
                float y = (float)(dY / distanceInBlocks);
                float z = (float)(dZ / distanceInBlocks);
                if (!pLevel.m_5776_() && pLevel instanceof ServerLevel) {
                    ServerLevel pServer = (ServerLevel)pLevel;
                    pServer.m_8767_(pType, pFrom.f_82479_ - (double)(x * (float)i), pFrom.f_82480_ - (double)(y * (float)i), pFrom.f_82481_ - (double)(z * (float)i), 1, 0.0, 0.0, 0.0, 0.0);
                }
                ++i;
            }
        }
    }
}

