/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.afterdark.features;

import com.mojang.serialization.Codec;
import dev.denismasterherobrine.afterdark.mixin.DripstoneHelperMixin;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LargeDiamondOrePillarFeature
extends Feature<LargeDripstoneConfiguration> {
    public LargeDiamondOrePillarFeature(Codec<LargeDripstoneConfiguration> pContext) {
        super(pContext);
    }

    public boolean m_142674_(FeaturePlaceContext<LargeDripstoneConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        BlockPos blockpos = new BlockPos((int)pContext.m_159777_().m_252807_().m_7096_(), pContext.m_159777_().m_123342_(), (int)pContext.m_159777_().m_252807_().m_7094_());
        RandomSource random = pContext.m_225041_();
        LargeDripstoneConfiguration config = (LargeDripstoneConfiguration)pContext.m_159778_();
        if (!DripstoneHelperMixin.invokeCanGenerateOrLava((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        Optional optional = Column.m_158175_((LevelSimulatedReader)worldgenlevel, (BlockPos)blockpos, (int)config.f_160945_, DripstoneUtils::m_159664_, DripstoneUtils::m_159649_);
        if (optional.isPresent() && optional.get() instanceof Column.Range) {
            Column.Range column$range = (Column.Range)optional.get();
            if (column$range.m_158214_() < 4) {
                return false;
            }
            int i = (int)((float)column$range.m_158214_() * config.f_160948_);
            int j = Mth.m_14045_((int)i, (int)config.f_160946_.m_142739_(), (int)config.f_160946_.m_142737_());
            int k = Mth.m_216287_((RandomSource)random, (int)config.f_160946_.m_142739_(), (int)j);
            LargePillar largepillarfeature$largepillar = LargeDiamondOrePillarFeature.makeDarkPrismarine(blockpos.m_175288_(column$range.m_158212_() - 1), false, random, k, config.f_160949_, config.f_160947_);
            LargePillar largepillarfeature$largepillar1 = LargeDiamondOrePillarFeature.makeDarkPrismarine(blockpos.m_175288_(column$range.m_158213_() + 1), true, random, k, config.f_160950_, config.f_160947_);
            WindOffsetter largepillarfeature$windoffsetter = largepillarfeature$largepillar.isSuitableForWind(config) && largepillarfeature$largepillar1.isSuitableForWind(config) ? new WindOffsetter(blockpos.m_123342_(), random, config.f_160951_) : WindOffsetter.noWind();
            boolean flag = largepillarfeature$largepillar.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largepillarfeature$windoffsetter);
            boolean flag1 = largepillarfeature$largepillar1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largepillarfeature$windoffsetter);
            if (flag) {
                largepillarfeature$largepillar.placeBlocks(worldgenlevel, random, largepillarfeature$windoffsetter);
            }
            if (flag1) {
                largepillarfeature$largepillar1.placeBlocks(worldgenlevel, random, largepillarfeature$windoffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargePillar makeDarkPrismarine(BlockPos pRoot, boolean pPointingUp, RandomSource pRandom, int pRadius, FloatProvider pBluntnessBase, FloatProvider pScaleBase) {
        return new LargePillar(pRoot, pPointingUp, pRadius, pBluntnessBase.m_214084_(pRandom), pScaleBase.m_214084_(pRandom));
    }

    static final class LargePillar {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargePillar(BlockPos pRoot, boolean pPointingUp, int pRadius, double pBluntness, double pScale) {
            this.root = pRoot;
            this.pointingUp = pPointingUp;
            this.radius = pRadius;
            this.bluntness = pBluntness;
            this.scale = pScale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel pLevel, WindOffsetter pWindOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.m_122032_();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_(Blocks.f_49991_)) {
                        return false;
                    }
                    if (DripstoneHelperMixin.invokeCanGenerateBase(pLevel, pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float pRadius) {
            return (int)DripstoneHelperMixin.invokeScaleHeightFromRadius(pRadius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel pLevel, RandomSource pRandom, WindOffsetter pWindOffsetter) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = Mth.m_14116_((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)pRandom.m_188501_() < 0.2) {
                        k = (int)((float)k * Mth.m_216283_((RandomSource)pRandom, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.m_7918_(i, 0, j).m_122032_();
                    boolean flag = false;
                    int l = this.pointingUp ? pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, blockpos$mutableblockpos.m_123341_(), blockpos$mutableblockpos.m_123343_()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && blockpos$mutableblockpos.m_123342_() < l; ++i1) {
                        BlockPos blockpos = pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos);
                        if (DripstoneHelperMixin.invokeCanGenerateOrLava((LevelAccessor)pLevel, blockpos)) {
                            flag = true;
                            Block block = Blocks.f_50089_;
                            pLevel.m_7731_(blockpos, block.m_49966_(), 2);
                        } else if (flag && pLevel.m_8055_(blockpos).m_204336_(BlockTags.f_13061_)) continue block1;
                        blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargeDripstoneConfiguration pConfig) {
            return this.radius >= pConfig.f_160952_ && this.bluntness >= (double)pConfig.f_160953_;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int pOriginY, RandomSource pRandom, FloatProvider pMagnitude) {
            this.originY = pOriginY;
            float f = pMagnitude.m_214084_(pRandom);
            float f1 = Mth.m_216283_((RandomSource)pRandom, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.m_14089_((float)f1) * f), 0.0, (double)(Mth.m_14031_((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos pPos) {
            if (this.windSpeed == null) {
                return pPos;
            }
            int i = this.originY - pPos.m_123342_();
            Vec3 vec3 = this.windSpeed.m_82490_((double)i);
            return pPos.m_7918_((int)vec3.f_82479_, 0, (int)vec3.f_82481_);
        }
    }
}

