/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.afterdark.blocks;

import dev.denismasterherobrine.afterdark.Config;
import dev.denismasterherobrine.afterdark.blocks.entity.TeleportBlockEntity;
import dev.denismasterherobrine.afterdark.registry.AfterdarkRegistry;
import dev.denismasterherobrine.afterdark.util.PlayerEntityAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TeleportBlock
extends BaseEntityBlock
implements EntityBlock {
    public TeleportBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.25, (double)0.375, (double)0.375, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.625, (double)0.375, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.25, (double)0.625, (double)0.75, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.25, (double)0.25, (double)0.75, (double)0.375, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.625, (double)0.25, (double)0.75, (double)0.75, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.625, (double)0.25, (double)0.375, (double)0.75, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.625, (double)0.625, (double)0.375, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.625, (double)0.625, (double)0.75, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return this.makeShape();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TeleportBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_ && world.m_7654_() != null) {
            if (player.m_9236_() == world.m_7654_().m_129880_(AfterdarkRegistry.AFTERDARK_LEVEL) && Config.INSTANCE.canReturnWithoutCatalyst) {
                this.teleportFromDimension(player);
            } else {
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof TeleportBlockEntity) {
                    TeleportBlockEntity teleportBlockEntity = (TeleportBlockEntity)blockEntity;
                    if (teleportBlockEntity.getRemainingTeleports() > 0 || Config.INSTANCE.TeleportCatalystUses < 1) {
                        PlayerEntityAccess playerAccess = (PlayerEntityAccess)player;
                        if (player.m_9236_() == world.m_7654_().m_129880_(AfterdarkRegistry.AFTERDARK_LEVEL)) {
                            if (teleportBlockEntity.getRemainingTeleports() > 0) {
                                teleportBlockEntity.setRemainingTeleports(teleportBlockEntity.getRemainingTeleports() - 1);
                            }
                            this.teleportFromDimension(player);
                        } else {
                            if (teleportBlockEntity.getRemainingTeleports() > 0) {
                                teleportBlockEntity.setRemainingTeleports(teleportBlockEntity.getRemainingTeleports() - 1);
                            }
                            playerAccess.the_afterdark$setLastWorld(player.m_9236_().m_46472_().m_135782_().toString());
                            this.teleportToDimension(player);
                        }
                    } else if (player.m_21120_(hand).m_41720_() == AfterdarkRegistry.TELEPORT_CATALYST_ITEM && player.m_21120_(hand).m_41613_() > 0) {
                        player.m_21120_(hand).m_41774_(1);
                        teleportBlockEntity.renewTeleports();
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"chat.the_afterdark.teleport_missing_catalyst"), false);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void teleportToDimension(Player player) {
        if (player.m_20194_() != null) {
            BlockPos safePos = this.getSafeTeleportPos((Level)player.m_20194_().m_129880_(AfterdarkRegistry.AFTERDARK_LEVEL), player.m_20183_(), player);
            player.m_264318_(player.m_20194_().m_129880_(AfterdarkRegistry.AFTERDARK_LEVEL), safePos.m_252807_().m_7096_(), (double)safePos.m_123342_(), safePos.m_252807_().m_7094_(), RelativeMovement.m_264098_((int)0), player.m_146908_(), player.m_146909_());
        }
    }

    public void teleportFromDimension(Player player) {
        if (player.m_20194_() != null) {
            ResourceKey playerLastWorld;
            if (!Config.INSTANCE.shouldTeleportReturnToSetWorld) {
                String lastWorld = ((PlayerEntityAccess)player).the_afterdark$getLastWorld();
                if (lastWorld == null) {
                    playerLastWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)Config.INSTANCE.returnSetWorld));
                } else {
                    playerLastWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)lastWorld));
                    if (playerLastWorld == null) {
                        playerLastWorld = Level.f_46428_;
                    }
                }
            } else {
                playerLastWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)Config.INSTANCE.returnSetWorld));
            }
            BlockPos safePos = this.getSafeTeleportPos((Level)player.m_20194_().m_129880_(playerLastWorld), player.m_20183_(), player);
            player.m_264318_(player.m_20194_().m_129880_(playerLastWorld), safePos.m_252807_().m_7096_(), (double)safePos.m_123342_(), safePos.m_252807_().m_7094_(), RelativeMovement.m_264098_((int)0), player.m_146908_(), player.m_146909_());
        }
    }

    public boolean isTeleportSafe(Level world, BlockPos pos, Player player) {
        if (world.m_8055_(pos.m_7495_()).m_60796_((BlockGetter)world, pos.m_7495_())) {
            int i = 0;
            while ((float)i < player.m_20206_()) {
                if (!world.m_8055_(pos.m_6630_(i)).m_60795_()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public BlockPos getSafeTeleportPos(Level world, BlockPos pos, Player player) {
        BlockPos checkPos;
        int z;
        int radius = Config.INSTANCE.SafeTeleportCheckRadius;
        if (this.isTeleportSafe(world, pos, player)) {
            return pos;
        }
        for (int r = 0; r <= radius; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int y = -r; y <= r; ++y) {
                    for (z = -r; z <= r; ++z) {
                        checkPos = pos.m_7918_(x, y, z);
                        if (!this.isTeleportSafe(world, checkPos, player)) continue;
                        return checkPos;
                    }
                }
            }
        }
        for (int y = world.m_141937_(); y <= world.m_141928_(); ++y) {
            BlockPos checkPos2 = pos.m_175288_(y);
            if (!this.isTeleportSafe(world, checkPos2, player)) continue;
            return checkPos2;
        }
        for (int i = 0; i < world.m_141928_() + Math.abs(world.m_141937_()); ++i) {
            int x;
            int y = pos.m_123342_() + i;
            if (y <= world.m_141928_()) {
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0 || !this.isTeleportSafe(world, checkPos = new BlockPos(pos.m_123341_() + x, y, pos.m_123343_() + z), player)) continue;
                        return checkPos;
                    }
                }
            }
            y = pos.m_123342_() - i;
            if (pos.m_123342_() - i < world.m_141937_()) continue;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0 || !this.isTeleportSafe(world, checkPos = new BlockPos(pos.m_123341_() + x, y, pos.m_123343_() + z), player)) continue;
                    return checkPos;
                }
            }
        }
        return pos;
    }
}

