/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.industrial_mixer;

import com.drmangotea.tfmg.content.machinery.vat.base.IVatMachine;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlock;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class IndustrialMixerBlockEntity
extends KineticBlockEntity
implements IVatMachine {
    public MixerMode mixerMode = MixerMode.NONE;
    public int vatSize = 1;
    public int vatHeight = 1;
    public BlockPos vatPos = null;
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;

    public IndustrialMixerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void vatUpdated(VatBlockEntity be) {
        this.vatSize = be.getWidth();
        this.vatHeight = be.getHeight();
        this.vatPos = be.m_58899_();
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            return;
        }
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
    }

    public void destroy() {
        ItemStack mixerItem = this.mixerMode.item;
        Containers.m_18992_((Level)this.m_58904_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)mixerItem);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        for (MixerMode mode : MixerMode.values()) {
            if (mode != this.mixerMode) continue;
            compound.m_128359_("MixerMode", mode.name);
        }
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.setMixerMode(compound.m_128461_("MixerMode"), false);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.03125, LerpedFloat.Chaser.EXP);
        }
        super.read(compound, clientPacket);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(3.0);
    }

    @Override
    public String getOperationId() {
        return switch (this.mixerMode) {
            default -> throw new IncompatibleClassChangeError();
            case MixerMode.NONE -> "";
            case MixerMode.MIXING -> "tfmg:mixing";
            case MixerMode.CENTRIFUGE -> "tfmg:centrifuge";
        };
    }

    @Override
    public boolean canOperate(VatBlockEntity vat) {
        return this.getSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue() || this.getSpeed() <= -IRotate.SpeedLevel.MEDIUM.getSpeedValue();
    }

    public boolean setMixerMode(ItemStack modeItem, boolean simulate) {
        for (MixerMode mode : MixerMode.values()) {
            if (!mode.item.m_150930_(modeItem.m_41720_())) continue;
            if (!simulate) {
                this.mixerMode = mode;
                continue;
            }
            return true;
        }
        if (!simulate && this.m_58898_()) {
            VatBlock.updateVatState(this.m_58900_(), this.m_58904_(), this.m_58899_().m_121945_(Direction.DOWN));
        }
        this.sendData();
        return false;
    }

    public boolean setMixerMode(String name, boolean simulate) {
        for (MixerMode mode : MixerMode.values()) {
            if (!Objects.equals(mode.name, name)) continue;
            if (!simulate) {
                this.mixerMode = mode;
                continue;
            }
            return true;
        }
        if (!simulate && this.m_58898_()) {
            VatBlock.updateVatState(this.m_58900_(), this.m_58904_(), this.m_58899_().m_121945_(Direction.DOWN));
        }
        this.sendData();
        return false;
    }

    @Override
    public int getWorkPercentage() {
        return (int)(this.getSpeed() / 255.0f * 100.0f);
    }

    @Override
    public IVatMachine.PositionRequirement getPositionRequirement() {
        return IVatMachine.PositionRequirement.TOP_CENTER;
    }

    @Override
    public String[] doesntWorkWith() {
        return new String[]{"electrodes"};
    }

    static enum MixerMode {
        NONE("none", ItemStack.f_41583_),
        MIXING("mixing", TFMGItems.MIXER_BLADE.asStack()),
        CENTRIFUGE("centrifuge", TFMGItems.CENTRIFUGE.asStack());

        public final String name;
        public final ItemStack item;

        private MixerMode(String name, ItemStack stack) {
            this.name = name;
            this.item = stack;
        }
    }
}

