/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.transformer;

import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class TransformerBlockEntity
extends VoltageAlteringBlockEntity {
    boolean updateInFront = false;
    public ItemStack primaryCoil = ItemStack.f_41583_;
    public ItemStack secondaryCoil = ItemStack.f_41583_;
    public float coilRatio = 0.0f;

    public TransformerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getOutputVoltage() {
        return (int)((float)this.getData().getVoltage() * this.coilRatio);
    }

    @Override
    public int getOutputPower() {
        return this.coilRatio == 0.0f ? 0 : this.getPowerUsage();
    }

    @Override
    public IElectric getControlledBlock() {
        IElectric be;
        Direction facing = this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_) ? (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) : ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId()) {
            return be;
        }
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.updateInFront) {
            this.updateInFront();
            this.updateInFront = false;
        }
        if (this.getPowerUsage() > 0 && this.f_58857_.m_5776_()) {
            TFMGSoundEvents.ELECTRIC_HUM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 1.0f, false);
        }
    }

    public void destroy() {
        ItemEntity item;
        super.destroy();
        BlockPos pos = this.m_58899_();
        if (!this.primaryCoil.m_41619_()) {
            item = new ItemEntity(this.f_58857_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), this.primaryCoil);
            this.f_58857_.m_7967_((Entity)item);
        }
        if (!this.secondaryCoil.m_41619_()) {
            item = new ItemEntity(this.f_58857_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), this.secondaryCoil);
            this.f_58857_.m_7967_((Entity)item);
        }
    }

    @Override
    public int getPowerUsage() {
        IElectric be;
        Direction facing = this.getDirection();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            return Math.max(be.getNetworkPowerUsage(this), 0);
        }
        return 0;
    }

    public void updateCoils() {
        int primaryTurns = this.primaryCoil.m_41784_().m_128451_("Turns");
        int secondaryTurns = this.secondaryCoil.m_41784_().m_128451_("Turns");
        if (this.primaryCoil.m_41619_() || this.secondaryCoil.m_41619_() || primaryTurns < 50 || secondaryTurns < 50) {
            this.coilRatio = 0.0f;
            this.updateNextTick();
            this.updateInFront();
            return;
        }
        this.coilRatio = (float)secondaryTurns / (float)primaryTurns;
        this.updateNextTick();
        this.updateInFront();
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        if (this.coilRatio != 0.0f) {
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
            CreateLang.translate((String)"multimeter.transformer_ratio", (Object[])new Object[0]).add(CreateLang.number((double)this.coilRatio)).color(13035564).forGoggles(tooltip, 1);
        }
        return true;
    }

    @Override
    public float resistance() {
        IElectric be;
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            return Math.max(be.getNetworkResistance(), 0);
        }
        return 0.0f;
    }

    public Direction getDirection() {
        if (!this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_)) {
            return ((Direction)this.m_58900_().m_61143_((Property)TFMGHorizontalDirectionalBlock.f_54117_)).m_122428_();
        }
        return (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122427_();
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (oldVoltage != this.getData().getVoltage() || oldPower != this.getPowerUsage()) {
            this.updateInFront = true;
        }
        this.sendStuff();
        this.m_6596_();
    }

    @Override
    public void updateNetwork() {
        super.updateNetwork();
        this.updateInFront();
    }

    @Override
    public void remove() {
        super.remove();
        this.updateInFront();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.updateInFront = true;
    }

    public void updateInFront() {
        IElectric be;
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new UpdateInFrontPacket(BlockPos.m_122022_((long)this.getPos())));
        }
        Direction facing = this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_) ? (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) : ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.m_6596_();
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("PrimaryCoil", (Tag)this.primaryCoil.serializeNBT());
        compound.m_128365_("SecondaryCoil", (Tag)this.secondaryCoil.serializeNBT());
        compound.m_128350_("CoilRation", this.coilRatio);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.primaryCoil = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PrimaryCoil"));
        this.secondaryCoil = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SecondaryCoil"));
        this.coilRatio = compound.m_128457_("CoilRation");
    }
}

