/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.StructureGelMod;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToggleViewBoundsPacket {
    private final boolean shouldViewBounds;

    public ToggleViewBoundsPacket(boolean shouldViewBounds) {
        this.shouldViewBounds = shouldViewBounds;
    }

    public static void encoder(ToggleViewBoundsPacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.shouldViewBounds);
    }

    public static ToggleViewBoundsPacket decoder(FriendlyByteBuf buff) {
        boolean shouldViewBounds = buff.readBoolean();
        return new ToggleViewBoundsPacket(shouldViewBounds);
    }

    public static void handler(ToggleViewBoundsPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> StructureGelMod.proxy.setViewBounds(packet.shouldViewBounds)));
        context.get().setPacketHandled(true);
    }
}

