/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;

public class CloneTool
extends BuildingToolMode.ForCorners {
    public CloneTool(String name, int modelIndex, boolean resetPosesAfterAction) {
        super(name, modelIndex, resetPosesAfterAction);
    }

    @Override
    protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
        if (level.f_46443_) {
            return;
        }
        double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
        ToolModeProperty.SGRotation rotation = BuildingToolItem.getProperty(stack, ToolModeProperty.ROTATION);
        ToolModeProperty.SGMirror mirror = BuildingToolItem.getProperty(stack, ToolModeProperty.MIRROR);
        boolean cut = BuildingToolItem.getProperty(stack, ToolModeProperty.CUT_FALSE).value();
        ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_ALL_AIR);
        RandomSource rand = level.m_213780_();
        CapturedBlocks captured = BuildingToolItem.getCapturedBlocks(stack, level, player);
        if (captured == null) {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.clipboard_missing", Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            return;
        }
        captured = captured.withTransforms(mirror.toVanilla(rand), rotation.toVanilla(rand));
        ActionHistory.ActionBuilder action = ActionHistory.newAction();
        if (cut) {
            BlockState air = Blocks.f_50016_.m_49966_();
            this.forPosesWithin((Vec3i)cornerA, (Vec3i)cornerB, pos -> this.setBlock(level, (BlockPos)pos, air, action));
            this.clearPoses(stack, player);
        }
        BoundingBox destBB = CloneTool.getCloneDestBounds(captured, clickedPos, level.m_8055_(clickedPos), player.m_20182_(), player.m_6144_());
        BlockPos startPos = new BlockPos(destBB.m_162395_(), destBB.m_162396_(), destBB.m_162398_());
        for (CapturedBlocks.BlockInfo info : captured.getBlockInfos()) {
            if (!((double)rand.m_188501_() < integrity)) continue;
            BlockPos placePos = startPos.m_121955_((Vec3i)info.pos());
            BlockState placeState = info.state();
            if (!replace.shouldReplace(level, placeState, placePos)) continue;
            this.setBlock(level, placePos, old -> info.state(), info.blockEntityTag().orElse(null), action, captured.getMirror(), captured.getRotation());
        }
        ActionHistory.get(player).add(level, action);
        BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.clone_blocks", new Object[0]);
        BuildingToolMode.playSound(player, SoundEvents.f_12200_);
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String shift = SGText.keybindString(options.f_92090_);
        String rightClick = SGText.keybindString(options.f_92095_);
        String leftClick = SGText.keybindString(options.f_92096_);
        return new Object[]{Component.m_237110_((String)"item.structure_gel.building_tool.mode.select_corners", (Object[])new Object[]{rightClick, shift, rightClick, rightClick, shift}), leftClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.INTEGRITY);
        properties.add(ToolModeProperty.ROTATION);
        properties.add(ToolModeProperty.MIRROR);
        properties.add(ToolModeProperty.CUT_FALSE);
        properties.add(ToolModeProperty.REPLACE_ALL_AIR);
    }

    @Override
    public boolean hasBlockPalette() {
        return false;
    }

    private void saveCapturedBlocks(ItemStack stack, Level level, Player player) {
        Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
        Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
        if (pos0.isPresent() && pos1.isPresent()) {
            CapturedBlocks captured = new CapturedBlocks(level, pos0.get(), pos1.get(), Mirror.NONE, Rotation.NONE);
            BuildingToolItem.setCapturedBlocks(stack, level, player, captured);
        }
    }

    @Override
    public void setPosition(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
        super.setPosition(player, clickedPos, stack, message);
        this.saveCapturedBlocks(stack, player.m_9236_(), player);
    }

    @Override
    public void onSelect(ItemStack stack, Level level, Player player) {
        this.saveCapturedBlocks(stack, level, player);
    }

    @Override
    public void clearPoses(ItemStack stack, Player player) {
        super.clearPoses(stack, player);
        BuildingToolItem.setCapturedBlocks(stack, player.m_9236_(), player, null);
    }

    @Override
    public boolean requiresSelectionLoaded() {
        return false;
    }

    @Override
    public void onReleaseCorner(ItemStack stack, Level level, Player player) {
        this.saveCapturedBlocks(stack, level, player);
    }

    public static BoundingBox getCloneDestBounds(CapturedBlocks captured, BlockPos targetPos, BlockState targetedBlock, Vec3 playerPos, boolean placeOneBlockAbove) {
        Vec3i bbLength = captured.getBounds().m_71053_();
        BlockPos start = targetPos.m_7918_(-bbLength.m_123341_() + bbLength.m_123341_() / 2, 0, -bbLength.m_123343_() + bbLength.m_123343_() / 2);
        if (placeOneBlockAbove) {
            start = start.m_7494_();
        }
        BoundingBox destBB = BoundingBox.m_162375_((Vec3i)start, (Vec3i)start.m_121955_(bbLength));
        int x = destBB.m_162395_();
        int z = destBB.m_162398_();
        int dx = destBB.m_162399_();
        int dz = destBB.m_162401_();
        LinkedList<Vec3i> edgePositions = new LinkedList<Vec3i>();
        edgePositions.add(new Vec3i(x, 0, z));
        edgePositions.add(new Vec3i(x, 0, dz));
        edgePositions.add(new Vec3i(dx, 0, z));
        edgePositions.add(new Vec3i(dx, 0, dz));
        edgePositions.sort(Comparator.comparingDouble(v -> new Vec3((double)v.m_123341_() + 0.5, (double)v.m_123342_(), (double)v.m_123343_() + 0.5).m_82554_(playerPos)));
        Vec3i closestCorner = (Vec3i)edgePositions.getFirst();
        BlockPos center = destBB.m_162394_();
        return destBB.m_71045_(center.m_123341_() - closestCorner.m_123341_(), 0, center.m_123343_() - closestCorner.m_123343_());
    }
}

