/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.client.widget.OnTooltip;
import com.legacy.structure_gel.core.client.widget.SuggestionEditBox;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TexturedEditBox
extends EditBox {
    private final int u;
    private final int v;
    private final int texWidth;
    private final int texHeight;
    private final ResourceLocation texture;
    private int textColor;
    private int hoveredTextColor;
    @Nullable
    private OnTooltip<TexturedEditBox> onTooltip;
    @Nullable
    private SuggestionEditBox.SuggestionComponent<String> suggestions;

    public TexturedEditBox(Font font, int x, int y, int width, int height, int u, int v, int texWidth, int texHeight, ResourceLocation texture, Component name) {
        super(font, x, y, width, height, name);
        this.u = u;
        this.v = v;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.texture = texture;
        this.textColor = 0xE0E0E0;
        this.hoveredTextColor = 0xE0E0E0;
        this.suggestions = new SuggestionEditBox.SuggestionComponent((EditBox)this, Collections::emptyList, Function.identity(), 0);
        this.m_94182_(false);
    }

    public TexturedEditBox(Font font, int x, int y, int width, int height, int u, int v, ResourceLocation texture, Component name) {
        this(font, x, y, width, height, u, v, 256, 256, texture, name);
    }

    public void onTooltip(OnTooltip<TexturedEditBox> onTooltip) {
        this.onTooltip = onTooltip;
    }

    public void m_93692_(boolean isFocused) {
        super.m_93692_(isFocused);
        this.suggestions.update(this.m_94155_());
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        boolean isOverText = super.m_5953_(mouseX, mouseY);
        if (this.m_93696_() && (isOverText || this.suggestions.m_5953_(mouseX, mouseY))) {
            return true;
        }
        return isOverText;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.suggestions.m_6050_(mouseX, mouseY, amount) && this.m_142518_()) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        if (this.m_93696_() && this.suggestions.m_5953_(mouseX, mouseY) && this.m_142518_()) {
            return this.suggestions.m_6375_(mouseX, mouseY, clickType);
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_7933_(int keyCode, int keyB, int modifiers) {
        if (this.m_142518_()) {
            if (keyCode == 256 && this.m_93696_()) {
                this.m_93692_(false);
                return true;
            }
            if (this.suggestions.m_7933_(keyCode, keyB, modifiers)) {
                return true;
            }
        }
        return super.m_7933_(keyCode, keyB, modifiers);
    }

    public void m_94151_(Consumer<String> responder) {
        super.m_94151_(s -> {
            responder.accept((String)s);
            this.suggestions.update(this.m_94155_());
        });
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.m_94213_()) {
            this.renderTexture(graphics, mouseX, mouseY, partialTicks);
            if (this.m_198029_()) {
                this.renderToolTip(graphics, mouseX, mouseY);
            }
        }
        int oldX = this.m_252754_();
        int oldY = this.m_252907_();
        this.m_252865_(this.m_252754_() + 4);
        this.m_253211_(this.m_252907_() + 8);
        this.m_94202_(this.m_198029_() ? this.hoveredTextColor : this.textColor);
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        this.m_252865_(oldX);
        this.m_253211_(oldY);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.m_93696_() && this.m_142518_()) {
            this.suggestions.x = this.m_252754_() - 1;
            this.suggestions.y = this.m_252907_() + this.m_93694_() + 1;
            this.suggestions.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderTexture(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        int h = this.f_93619_;
        graphics.m_280163_(this.texture, this.m_252754_(), this.m_252907_(), (float)this.u, this.m_198029_() ? (float)(this.v + h) : (float)this.v, this.f_93618_, h, this.texWidth, this.texHeight);
        RenderSystem.disableBlend();
    }

    public void renderToolTip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.onTooltip != null) {
            this.onTooltip.onTooltip(this, graphics, mouseX, mouseY);
        }
    }

    @Deprecated
    public void m_94202_(int color) {
        super.m_94202_(color);
    }

    public void setTextColor(int textColor, int hoveredTextColor) {
        super.m_94202_(textColor);
        this.textColor = textColor;
        this.hoveredTextColor = hoveredTextColor;
    }

    public void setSuggestions(Supplier<Collection<String>> suggestions) {
        this.suggestions = new SuggestionEditBox.SuggestionComponent((EditBox)this, suggestions, Function.identity(), 10);
    }
}

