/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.data.providers.RegistrarDatapackEntriesProvider;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.core.StructureGelMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

public class RegistrarHandler<T> {
    private static final Map<String, Map<ResourceKey<Registry<?>>, RegistrarHandler<?>>> HANDLERS = new HashMap();
    protected final ResourceKey<Registry<T>> registry;
    protected final String modID;
    private boolean registeredToBus = false;
    private final List<Registrar<?>> needsRegistered = new ArrayList();
    private final List<Registrar<?>> needsGenerated = new ArrayList();
    private final List<BootstrapInit<T>> bootstraps = new ArrayList<BootstrapInit<T>>();

    protected RegistrarHandler(ResourceKey<Registry<T>> registry, String modID) {
        this.registry = registry;
        this.modID = modID;
    }

    public static <T> RegistrarHandler<T> getOrCreate(ResourceKey<Registry<T>> registry, String modID) {
        return RegistrarHandler.getOrCreate(registry, modID, r -> new RegistrarHandler(r, modID));
    }

    public static BlockHandler getOrCreateBlocks(String modID) throws ClassCastException {
        RegistrarHandler handler = RegistrarHandler.getOrCreate(Registries.f_256747_, modID, r -> new BlockHandler(modID));
        if (handler instanceof BlockHandler) {
            return (BlockHandler)handler;
        }
        throw new ClassCastException("[Structure Gel] Cannot get a " + BlockHandler.class.getSimpleName() + " for " + modID + " because it already owns one as a " + handler.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> RegistrarHandler<T> getOrCreate(ResourceKey<Registry<T>> registry, String modID, Function<ResourceKey<Registry<?>>, RegistrarHandler<?>> handlerFactory) {
        Map<String, Map<ResourceKey<Registry<?>>, RegistrarHandler<?>>> map = HANDLERS;
        synchronized (map) {
            return HANDLERS.computeIfAbsent(modID, s -> new HashMap()).computeIfAbsent(registry, handlerFactory);
        }
    }

    public <V extends T> Registrar.Static<V> createStatic(String key, Supplier<V> value) {
        return this.createStatic(new ResourceLocation(this.modID, key), value);
    }

    public <V extends T> Registrar.Static<V> createStatic(ResourceLocation key, Supplier<V> value) {
        Registrar.Static<V> ret = Registrar.createStatic(this.registry, key, value);
        this.needsRegistered.add(ret);
        return ret;
    }

    public <V extends T> Registrar.Pointer<V> createPointer(String key, Supplier<V> value) {
        return this.createPointer(key, (BootstapContext<?> c) -> value.get());
    }

    public <V extends T> Registrar.Pointer<V> createPointer(ResourceLocation key, Supplier<V> value) {
        return this.createPointer(key, (BootstapContext<?> c) -> value.get());
    }

    public <V extends T> Registrar.Pointer<V> createPointer(String key, Function<BootstapContext<?>, V> value) {
        return this.createPointer(new ResourceLocation(this.modID, key), value);
    }

    public <V extends T> Registrar.Pointer<V> createPointer(ResourceLocation key, Function<BootstapContext<?>, V> value) {
        Registrar.Pointer<V> ret = Registrar.createPointer(this.registry, key, value);
        if (DatagenModLoader.isRunningDataGen()) {
            this.needsGenerated.add(ret);
        }
        return ret;
    }

    public RegistrarHandler<T> bootstrap(BootstrapInit<T> bootstrap) {
        this.bootstraps.add(bootstrap);
        return this;
    }

    public ResourceKey<T> key(String name) {
        return ResourceKey.m_135785_(this.registry, (ResourceLocation)new ResourceLocation(this.modID, name));
    }

    public TagKey<T> tagKey(String name) {
        return TagKey.m_203882_(this.registry, (ResourceLocation)new ResourceLocation(this.modID, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHandlers(String modID, IEventBus bus, RegistrarHandler<?> ... handlers) {
        RegistrarHandler<?>[] registrarHandlerArray = HANDLERS;
        synchronized (HANDLERS) {
            HANDLERS.getOrDefault(ModLoadingContext.get().getActiveNamespace(), Map.of()).values().forEach(h -> h.register(bus));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (RegistrarHandler<?> handler : handlers) {
                handler.register(bus);
            }
            return;
        }
    }

    public void register(IEventBus modBus) {
        if (!this.registeredToBus) {
            modBus.addListener(this::registerValues);
            this.registeredToBus = true;
        }
    }

    public void registerValues(RegisterEvent event) {
        if (this.registry.equals((Object)event.getRegistryKey())) {
            int s = this.needsRegistered.size();
            for (int i = 0; i < s; ++i) {
                Registrar<?> r = this.needsRegistered.get(i);
                if (!(r instanceof Registrar.Static)) continue;
                r.register(event);
            }
            this.needsRegistered.clear();
        }
    }

    public static RegistrarDatapackEntriesProvider createGenerator(PackOutput packOutput, String modID, String ... additionalMods) {
        HashSet<String> modsToGen = new HashSet<String>();
        modsToGen.add(modID);
        for (String mod : additionalMods) {
            modsToGen.add(mod);
        }
        HashMap<ResourceKey, List> registrars = new HashMap<ResourceKey, List>();
        for (String mod : modsToGen) {
            Map<ResourceKey<Registry<?>>, RegistrarHandler<?>> handlers = HANDLERS.get(mod);
            if (handlers == null) continue;
            for (Map.Entry<ResourceKey<Registry<?>>, RegistrarHandler<?>> entry : handlers.entrySet()) {
                RegistrarHandler<?> handler = entry.getValue();
                if (handler.isBuiltIn()) continue;
                registrars.computeIfAbsent(entry.getKey(), r -> new ArrayList()).add(handler);
            }
        }
        RegistrySetBuilder builder = new RegistrySetBuilder();
        for (Map.Entry entry : registrars.entrySet()) {
            builder.m_254916_((ResourceKey)entry.getKey(), c -> ((List)entry.getValue()).forEach(r -> r.registerForDatagen(c)));
        }
        return new RegistrarDatapackEntriesProvider(packOutput, builder);
    }

    public boolean isBuiltIn() {
        return BuiltInRegistries.f_257047_.m_7804_(this.registry.m_135782_());
    }

    private void registerForDatagen(BootstapContext<T> context) {
        StructureGelMod.LOGGER.info("Generating {}", this.registry);
        for (BootstrapInit<T> bootstrap : this.bootstraps) {
            bootstrap.run(context);
        }
        int s = this.needsGenerated.size();
        for (int i = 0; i < s; ++i) {
            Registrar<?> r = this.needsGenerated.get(i);
            if (!(r instanceof Registrar.Pointer)) continue;
            Registrar.Pointer p = (Registrar.Pointer)r;
            p.registerData(context);
        }
        this.needsGenerated.clear();
    }

    public static final class BlockHandler
    extends RegistrarHandler<Block> {
        protected BlockHandler(String modID) {
            super(Registries.f_256747_, modID);
        }

        public <V extends Block> Registrar.Static<V> createStatic(String key, Supplier<V> value, Item.Properties itemProperties) {
            return this.createStatic(key, value, itemProperties, BlockItem::new);
        }

        public <V extends Block> Registrar.Static<V> createStatic(ResourceLocation key, Supplier<V> value, Item.Properties itemProperties) {
            return this.createStatic(key, value, itemProperties, BlockItem::new);
        }

        public <V extends Block> Registrar.Static<V> createStatic(String key, Supplier<V> value, Item.Properties itemProperties, BiFunction<V, Item.Properties, BlockItem> blockItemFactory) {
            return this.createStatic(new ResourceLocation(this.modID, key), value, itemProperties, blockItemFactory);
        }

        public <V extends Block> Registrar.Static<V> createStatic(ResourceLocation key, Supplier<V> value, Item.Properties itemProperties, BiFunction<V, Item.Properties, BlockItem> blockItemFactory) {
            Registrar.Static ret = super.createStatic(key, value);
            BlockHandler.getOrCreate(Registries.f_256913_, this.modID).createStatic(key, () -> (BlockItem)blockItemFactory.apply((Block)ret.get(), itemProperties));
            return ret;
        }
    }

    public static interface BootstrapInit<T> {
        public void run(BootstapContext<T> var1);
    }
}

