/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.data.tags;

import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.holdersets.CompositeHolderSet;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.ICustomHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;

public class FilterHolderSet<T>
implements ICustomHolderSet<T> {
    private final HolderSet<T> whitelist;
    private final HolderSet<T> blacklist;
    @Nullable
    private Set<Holder<T>> set;
    @Nullable
    private List<Holder<T>> list;

    public FilterHolderSet(HolderSet<T> whitelist, HolderSet<T> blacklist) {
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.whitelist.addInvalidationListener(this::invalidate);
        this.blacklist.addInvalidationListener(this::invalidate);
    }

    public static <T> Builder<T> builder(ResourceKey<Registry<T>> registry) {
        return new Builder();
    }

    public static Builder<Biome> biomes() {
        return FilterHolderSet.builder(Registries.f_256952_);
    }

    public static <T> Codec<? extends ICustomHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        return RecordCodecBuilder.create(instance -> instance.group((App)HolderSetCodec.m_206685_((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("whitelist").forGetter(f -> f.whitelist), (App)HolderSetCodec.m_206685_((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("blacklist").forGetter(f -> f.blacklist)).apply((Applicative)instance, FilterHolderSet::new));
    }

    public Stream<Holder<T>> m_203614_() {
        return this.whitelist.m_203614_().filter(holder -> !this.blacklist.m_203333_(holder));
    }

    public int m_203632_() {
        return this.getList().size();
    }

    public Either<TagKey<T>, List<Holder<T>>> m_203440_() {
        return Either.right(this.getList());
    }

    public Optional<Holder<T>> m_213653_(RandomSource rand) {
        List<Holder<T>> l = this.getList();
        int size = l.size();
        if (size > 0) {
            return Optional.of(l.get(rand.m_188503_(size)));
        }
        return Optional.empty();
    }

    public Holder<T> m_203662_(int index) {
        return this.getList().get(index);
    }

    public boolean m_203333_(Holder<T> holder) {
        return this.getSet().contains(holder);
    }

    public Iterator<Holder<T>> iterator() {
        return this.getList().iterator();
    }

    public HolderSetType type() {
        return SGRegistry.HolderSetTypes.FILTER.get();
    }

    public boolean m_207277_(HolderOwner<T> holderOwner) {
        return true;
    }

    public Optional<TagKey<T>> m_245234_() {
        return Optional.empty();
    }

    private void invalidate() {
        this.set = null;
        this.list = null;
    }

    private List<Holder<T>> getList() {
        if (this.list == null) {
            this.list = List.copyOf(this.getSet());
        }
        return this.list;
    }

    private Set<Holder<T>> getSet() {
        if (this.set == null) {
            this.set = this.m_203614_().collect(Collectors.toSet());
        }
        return this.set;
    }

    public List<String> toFilterStrings() {
        List<String> vals = this.valuesToStrings(this.whitelist);
        this.valuesToStrings(this.blacklist).stream().map(s -> "!" + s).forEach(vals::add);
        return vals;
    }

    private List<String> valuesToStrings(HolderSet<T> holderSet) {
        ArrayList<String> values = new ArrayList<String>();
        if (holderSet instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)holderSet;
            values.add("#" + named.m_205839_().f_203868_().toString());
        } else if (holderSet instanceof CompositeHolderSet) {
            CompositeHolderSet composite = (CompositeHolderSet)holderSet;
            composite.getComponents().forEach(hSet -> values.addAll(this.valuesToStrings((HolderSet<T>)hSet)));
        } else {
            holderSet.m_203614_().map(Holder::m_203543_).filter(Optional::isPresent).map(o -> ((ResourceKey)o.get()).m_135782_().toString()).forEach(values::add);
        }
        return values;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " = " + this.toFilterStrings();
    }

    public static final class Builder<T> {
        private final LinkedHashSet<ResourceKey<T>> wVals = new LinkedHashSet();
        private final LinkedHashSet<TagKey<T>> wTags = new LinkedHashSet();
        private final LinkedHashSet<HolderSet<T>> wHolderSets = new LinkedHashSet();
        private final LinkedHashSet<ResourceKey<T>> bVals = new LinkedHashSet();
        private final LinkedHashSet<TagKey<T>> bTags = new LinkedHashSet();
        private final LinkedHashSet<HolderSet<T>> bHolderSets = new LinkedHashSet();

        private Builder() {
        }

        public final Builder<T> values(boolean whitelist, Collection<ResourceKey<T>> names) {
            if (whitelist) {
                this.wVals.addAll(names);
            } else {
                this.bVals.addAll(names);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> values(boolean whitelist, ResourceKey<T> ... keys) {
            return this.values(whitelist, List.of(keys));
        }

        @SafeVarargs
        public final Builder<T> values(boolean whitelist, Registrar<T> ... objects) {
            return this.values(whitelist, Arrays.stream(objects).map(Registrar::getKey).toList());
        }

        public final Builder<T> tags(boolean whitelist, Collection<TagKey<T>> tags) {
            if (whitelist) {
                this.wTags.addAll(tags);
            } else {
                this.bTags.addAll(tags);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> tags(boolean whitelist, TagKey<T> ... tags) {
            return this.tags(whitelist, List.of(tags));
        }

        public final Builder<T> holderSets(boolean whitelist, Collection<HolderSet<T>> holderSets) {
            if (whitelist) {
                this.wHolderSets.addAll(holderSets);
            } else {
                this.bHolderSets.addAll(holderSets);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> holderSets(boolean whitelist, HolderSet<T> ... holderSets) {
            return this.holderSets(whitelist, List.of(holderSets));
        }

        public FilterHolderSet<T> build(HolderGetter<T> registry) {
            return new FilterHolderSet<T>(this.compileList(registry, this.wVals, this.wTags, this.wHolderSets), this.compileList(registry, this.bVals, this.bTags, this.bHolderSets));
        }

        private HolderSet<T> compileList(HolderGetter<T> registry, Collection<ResourceKey<T>> keys, Collection<TagKey<T>> tags, Collection<HolderSet<T>> holderSets) {
            ArrayList<Object> compiledSets = new ArrayList<Object>();
            if (!keys.isEmpty()) {
                compiledSets.add(HolderSet.m_205800_(keys.stream().map(arg_0 -> registry.m_254902_(arg_0)).filter(Optional::isPresent).map(Optional::get).toList()));
            }
            if (!tags.isEmpty()) {
                compiledSets.addAll(tags.stream().map(arg_0 -> registry.m_254901_(arg_0)).filter(Optional::isPresent).map(n -> (HolderSet)n.get()).toList());
            }
            if (!holderSets.isEmpty()) {
                compiledSets.addAll(holderSets);
            }
            if (compiledSets.isEmpty()) {
                return HolderSet.m_205809_((Holder[])new Holder[0]);
            }
            return new OrHolderSet(compiledSets);
        }

        public List<String> toFilterStrings() {
            List<String> vals = this.valuesToStrings(this.wVals, this.wTags, this.wHolderSets);
            this.valuesToStrings(this.bVals, this.bTags, this.bHolderSets).stream().map(s -> "!" + s).forEach(vals::add);
            return vals;
        }

        private List<String> valuesToStrings(Collection<ResourceKey<T>> keys, Collection<TagKey<T>> tags, Collection<HolderSet<T>> holderSets) {
            ArrayList<String> values = new ArrayList<String>();
            for (ResourceKey<T> resourceKey : keys) {
                values.add(resourceKey.m_135782_().toString());
            }
            for (TagKey tagKey : tags) {
                values.add("#" + tagKey.f_203868_().toString());
            }
            for (HolderSet holderSet : holderSets) {
                holderSet.m_203614_().map(Holder::m_203543_).filter(Optional::isPresent).map(o -> ((ResourceKey)o.get()).m_135782_().toString()).forEach(values::add);
            }
            return values;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " = " + this.toFilterStrings();
        }
    }
}

