/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.data.providers;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.DataPackRegistriesHooks;

public class RegistrarDatapackEntriesProvider
implements DataProvider {
    private final PackOutput output;
    private final Lazy<HolderLookup.Provider> vanillaProv;
    private final Lazy<HolderLookup.Provider> modProv;
    private final CompletableFuture<HolderLookup.Provider> registriesFuture;

    public RegistrarDatapackEntriesProvider(PackOutput output, RegistrySetBuilder datapackEntriesBuilder) {
        this.output = output;
        this.vanillaProv = Lazy.concurrentOf(() -> VanillaRegistries.m_255371_());
        this.modProv = Lazy.concurrentOf(() -> RegistrarDatapackEntriesProvider.constructRegistries((HolderLookup.Provider)this.vanillaProv.get(), datapackEntriesBuilder));
        this.registriesFuture = CompletableFuture.supplyAsync(this.modProv, Util.m_183991_());
    }

    private static HolderLookup.Provider constructRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        HashSet builderKeys = new HashSet(datapackEntriesBuilder.getEntryKeys());
        DataPackRegistriesHooks.getDataPackRegistries().stream().filter(data -> !builderKeys.contains(data.f_243794_())).forEach(data -> datapackEntriesBuilder.m_254916_(data.f_243794_(), context -> {}));
        return datapackEntriesBuilder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), original);
    }

    public CompletableFuture<HolderLookup.Provider> getLookupProvider() {
        return CompletableFuture.supplyAsync(() -> new MultiProv((HolderLookup.Provider)this.modProv.get(), (HolderLookup.Provider)this.vanillaProv.get()), Util.m_183991_());
    }

    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        return this.registriesFuture.thenCompose(prov -> {
            RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)prov);
            return CompletableFuture.allOf((CompletableFuture[])DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().flatMap(arg_0 -> this.lambda$run$6(cachedOutput, prov, (DynamicOps)ops, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistryCap(CachedOutput cachedOutput, HolderLookup.Provider prov, DynamicOps<JsonElement> ops, RegistryDataLoader.RegistryData<T> registryDat) {
        ResourceKey registryKey = registryDat.f_243794_();
        return prov.m_254861_(registryKey).map(registry -> {
            Object folder = registryKey.m_135782_().m_135815_();
            String mod = registryKey.m_135782_().m_135827_();
            if (!"minecraft".equals(mod)) {
                folder = mod + "/" + (String)folder;
            }
            PackOutput.PathProvider packoutput$pathprovider = this.output.m_245269_(PackOutput.Target.DATA_PACK, (String)folder);
            return CompletableFuture.allOf((CompletableFuture[])registry.m_214062_().map(holder -> RegistrarDatapackEntriesProvider.dumpValue(packoutput$pathprovider.m_245731_(holder.m_205785_().m_135782_()), cachedOutput, ops, registryDat.f_244580_(), holder.m_203334_())).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpValue(Path path, CachedOutput cachedOutput, DynamicOps<JsonElement> ops, Encoder<E> encoder, E value) {
        Optional optional = encoder.encodeStart(ops, value).resultOrPartial(error -> f_252483_.error("Couldn't serialize element {}: {}", (Object)path, error));
        return optional.isPresent() ? DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)optional.get()), (Path)path) : CompletableFuture.completedFuture(null);
    }

    public String m_6055_() {
        return "[Structure Gel] Registrar Registries";
    }

    private /* synthetic */ Stream lambda$run$6(CachedOutput cachedOutput, HolderLookup.Provider prov, DynamicOps ops, RegistryDataLoader.RegistryData registryDat) {
        return this.dumpRegistryCap(cachedOutput, prov, (DynamicOps<JsonElement>)ops, registryDat).stream();
    }

    private record MultiProv(HolderLookup.Provider a, HolderLookup.Provider b) implements HolderLookup.Provider
    {
        public <T> Optional<HolderLookup.RegistryLookup<T>> m_254861_(ResourceKey<? extends Registry<? extends T>> registryKey) {
            return Optional.of(new MultiReg(this.a.m_254861_(registryKey), this.b.m_254861_(registryKey)));
        }

        private record MultiReg<T>(Optional<HolderLookup.RegistryLookup<T>> a, Optional<HolderLookup.RegistryLookup<T>> b) implements HolderLookup.RegistryLookup<T>
        {
            public Stream<Holder.Reference<T>> m_214062_() {
                return Stream.concat(this.a.stream(), this.b.stream()).flatMap(HolderLookup::m_214062_).distinct();
            }

            public Stream<HolderSet.Named<T>> m_214063_() {
                return Stream.concat(this.a.stream(), this.b.stream()).flatMap(HolderLookup::m_214063_).distinct();
            }

            public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> key) {
                Optional aVal;
                if (this.a.isPresent() && (aVal = this.a.get().m_254902_(key)).isPresent()) {
                    return aVal;
                }
                if (this.b.isPresent()) {
                    Optional bVal = this.b.get().m_254902_(key);
                    return bVal;
                }
                return Optional.empty();
            }

            public Optional<HolderSet.Named<T>> m_254901_(TagKey<T> key) {
                Optional aVal;
                if (this.a.isPresent() && (aVal = this.a.get().m_254901_(key)).isPresent()) {
                    return aVal;
                }
                if (this.b.isPresent()) {
                    Optional bVal = this.b.get().m_254901_(key);
                    return bVal;
                }
                return Optional.empty();
            }

            public ResourceKey<? extends Registry<? extends T>> m_254879_() {
                return this.a.isPresent() ? this.a.get().m_254879_() : this.b.get().m_254879_();
            }

            public Lifecycle m_254883_() {
                return Lifecycle.stable();
            }
        }
    }
}

