/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing;

import com.bonker.stardewfishing.common.init.SFAttributes;
import com.bonker.stardewfishing.server.AttributeCache;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="stardew_fishing", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SFConfig {
    static final ForgeConfigSpec SERVER_SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.DoubleValue QUALITY_1_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue QUALITY_2_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue QUALITY_3_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue QUALITY_1_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue QUALITY_2_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue QUALITY_3_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue BITE_TIME_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue TREASURE_CHEST_CHANCE;
    private static final ForgeConfigSpec.DoubleValue GOLDEN_CHEST_CHANCE;
    private static final ForgeConfigSpec.BooleanValue INVENTORY_BOBBER_EQUIPPING;
    private static final ForgeConfigSpec.BooleanValue LEGENDARY_FISH_FLASHING;
    private static final ForgeConfigSpec.DoubleValue LEGENDARY_FISH_CHANCE;

    public static int getQuality(double accuracy) {
        if (accuracy >= (Double)QUALITY_3_THRESHOLD.get()) {
            return 3;
        }
        if (accuracy >= (Double)QUALITY_2_THRESHOLD.get()) {
            return 2;
        }
        if (accuracy >= (Double)QUALITY_1_THRESHOLD.get()) {
            return 1;
        }
        return 0;
    }

    public static double getMultiplier(double accuracy, Player player, double expMultiplierStat) {
        double multiplier = switch (SFConfig.getQuality(accuracy)) {
            case 3 -> (Double)QUALITY_3_MULTIPLIER.get();
            case 2 -> (Double)QUALITY_2_MULTIPLIER.get();
            case 1 -> (Double)QUALITY_1_MULTIPLIER.get();
            default -> 1.0;
        };
        multiplier *= expMultiplierStat;
        return multiplier *= AttributeCache.getAttribute(player, (Attribute)SFAttributes.EXPERIENCE_MULTIPLIER.get());
    }

    public static double getBiteTimeMultiplier() {
        return (Double)BITE_TIME_MULTIPLIER.get();
    }

    public static double getTreasureChestChance() {
        return (Double)TREASURE_CHEST_CHANCE.get();
    }

    public static double getGoldenChestChance() {
        return (Double)GOLDEN_CHEST_CHANCE.get();
    }

    public static boolean isInventoryEquippingEnabled() {
        return (Boolean)INVENTORY_BOBBER_EQUIPPING.get();
    }

    public static boolean isLegendaryFlashingEnabled() {
        return (Boolean)LEGENDARY_FISH_FLASHING.get();
    }

    public static float getLegendaryFishChance(float luck) {
        return (float)((Double)LEGENDARY_FISH_CHANCE.get() + (double)(luck * 0.01f));
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        QUALITY_1_THRESHOLD = BUILDER.comment("The minimum accuracy that grants an item of quality 1.").defineInRange("quality1Threshold", 0.75, 0.0, 1.0);
        QUALITY_2_THRESHOLD = BUILDER.comment("The minimum accuracy that grants an item of quality 2.").defineInRange("quality2Threshold", 0.9, 0.0, 1.0);
        QUALITY_3_THRESHOLD = BUILDER.comment("The minimum accuracy that grants an item of quality 3.").defineInRange("quality3Threshold", 1.0, 0.0, 1.0);
        QUALITY_1_MULTIPLIER = BUILDER.comment("The multiplier that is applied to experience gained from fishing a quality 1 reward.").defineInRange("quality1Multiplier", 1.5, 1.0, 10.0);
        QUALITY_2_MULTIPLIER = BUILDER.comment("The multiplier that is applied to experience gained from fishing a quality 2 reward.").defineInRange("quality2Multiplier", 2.5, 1.0, 10.0);
        QUALITY_3_MULTIPLIER = BUILDER.comment("The multiplier that is applied to experience gained from fishing a quality 3 reward.").defineInRange("quality3Multiplier", 4.0, 1.0, 10.0);
        BITE_TIME_MULTIPLIER = BUILDER.comment("The multiplier that is applied to the time it takes for a fish to bite after casting your rod.").defineInRange("biteTimeMultiplier", 0.8, 0.0, 1.0);
        TREASURE_CHEST_CHANCE = BUILDER.comment("The chance for finding a treasure chest each time you play the fishing minigame.").defineInRange("treasureChestChance", 0.15, 0.0, 1.0);
        GOLDEN_CHEST_CHANCE = BUILDER.comment("The chance that a treasure chest found in the fishing minigame is a golden chest.").defineInRange("goldenChestChance", 0.1, 0.0, 1.0);
        INVENTORY_BOBBER_EQUIPPING = BUILDER.comment("Whether it be possible to attach bobber items by hovering over a fishing rod in an inventory and right clicking.").define("inventoryBobberEquipping", true);
        LEGENDARY_FISH_FLASHING = BUILDER.comment("Whether legendary fish will have a strobe effect when moving in the minigame.").define("legendaryFishFlashing", true);
        LEGENDARY_FISH_CHANCE = BUILDER.comment("The chance that any fish that bites is a legendary fish.").defineInRange("legendaryFishChance", 0.01, 0.0, 1.0);
        SERVER_SPEC = BUILDER.build();
    }
}

