/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.sittingplus.networking;

import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class SittingPlusNetworking {
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sittingplus", "network"), () -> "1.0", "1.0"::equals, "1.0"::equals);

    public static void register() {
        CHANNEL.registerMessage(0, StartSitPacket.class, StartSitPacket::encode, StartSitPacket::decode, StartSitPacket::handle);
        CHANNEL.registerMessage(1, StopSitPacket.class, StopSitPacket::encode, StopSitPacket::decode, StopSitPacket::handle);
    }

    public static class StartSitPacket {
        private final String playerId;
        private final ResourceLocation animationId;

        public StartSitPacket(String playerId, ResourceLocation animationId) {
            this.playerId = playerId;
            this.animationId = animationId;
        }

        public static void encode(StartSitPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.playerId);
            buf.m_130085_(packet.animationId);
        }

        public static StartSitPacket decode(FriendlyByteBuf buf) {
            String playerId = buf.m_130277_();
            ResourceLocation animationId = buf.m_130281_();
            return new StartSitPacket(playerId, animationId);
        }

        public static void handle(StartSitPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                    CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
                } else {
                    StartSitPacket.runClientHandle(packet);
                }
            });
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void runClientHandle(StartSitPacket packet) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                minecraft.f_91073_.m_6907_().stream().filter(player -> player.m_20148_().toString().equals(packet.playerId) && player instanceof AbstractClientPlayer).findFirst().ifPresent(player -> {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
                    if (animationStack == null) {
                        return;
                    }
                    KeyframeAnimation animationData = PlayerAnimationRegistry.getAnimation((ResourceLocation)packet.animationId);
                    if (animationData == null) {
                        return;
                    }
                    KeyframeAnimationPlayer animationPlayer = new KeyframeAnimationPlayer(animationData);
                    animationStack.addAnimLayer(0, (IAnimation)animationPlayer);
                });
            }
        }
    }

    public static class StopSitPacket {
        private final String playerId;

        public StopSitPacket(String playerId) {
            this.playerId = playerId;
        }

        public static void encode(StopSitPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.playerId);
        }

        public static StopSitPacket decode(FriendlyByteBuf buf) {
            String playerId = buf.m_130277_();
            return new StopSitPacket(playerId);
        }

        public static void handle(StopSitPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                    CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
                } else {
                    StopSitPacket.runClientHandle(packet);
                }
            });
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void runClientHandle(StopSitPacket packet) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                minecraft.f_91073_.m_6907_().stream().filter(player -> player.m_20148_().toString().equals(packet.playerId) && player instanceof AbstractClientPlayer).findFirst().ifPresent(player -> {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
                    if (animationStack != null) {
                        animationStack.removeLayer(0);
                    }
                });
            }
        }
    }
}

