/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBottomBlock;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBottomBlockEntity;
import net.dragonegg.sculkcatalyticchamber.registry.SpriteShiftRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ChamberBottomRenderer
extends SmartBlockEntityRenderer<ChamberBottomBlockEntity> {
    public ChamberBottomRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(ChamberBottomBlockEntity chamber, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlazeBurnerBlockEntity burner;
        BlazeBurnerBlock.HeatLevel heatLevel;
        super.renderSafe((SmartBlockEntity)chamber, partialTicks, ms, buffer, light, overlay);
        Level level = chamber.m_58904_();
        if (level == null) {
            return;
        }
        BlockState blockState = chamber.m_58900_();
        BlockPos pos = chamber.m_58899_();
        if (!(blockState.m_60734_() instanceof ChamberBottomBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)ChamberBottomBlock.FACING);
        if (direction != Direction.DOWN) {
            Vec3 directionVec = Vec3.m_82528_((Vec3i)direction.m_122436_());
            Vec3 outVec = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_).m_82549_(directionVec.m_82490_(0.55).m_82492_(0.0, 0.5, 0.0));
            boolean outToBasin = level.m_8055_(pos.m_121945_(direction).m_7495_()).m_60734_() instanceof BasinBlock;
            for (IntAttached<ItemStack> intAttached : chamber.visualizedOutputItems) {
                float progress = 1.0f - ((float)((Integer)intAttached.getFirst()).intValue() - partialTicks) / 10.0f;
                if (!outToBasin && progress > 0.35f) continue;
                ms.m_85836_();
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(outVec)).translate(new Vec3(0.0, (double)Math.max(-0.55f, -(progress * progress * 2.0f)), 0.0))).translate(directionVec.m_82490_((double)(progress * 0.5f)))).rotateY(AngleHelper.horizontalAngle((Direction)direction))).rotateX(progress * 180.0f);
                this.renderItem(ms, buffer, light, overlay, (ItemStack)intAttached.getValue());
                ms.m_85849_();
            }
        }
        BlockState belowState = level.m_8055_(pos.m_7495_());
        BlockEntity belowBE = level.m_7702_(pos.m_7495_());
        if (belowBE instanceof BlazeBurnerBlockEntity && (heatLevel = (burner = (BlazeBurnerBlockEntity)belowBE).getHeatLevelFromBlock()).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            float headAngle = (AngleHelper.horizontalAngle((Direction)Direction.SOUTH) + 180.0f) % 360.0f;
            float horizontalAngle = AngleHelper.rad((double)headAngle);
            ms.m_85836_();
            ms.m_252880_(1.0f, -1.0f, 1.0f);
            this.renderFlame(ms, buffer, level, belowState, heatLevel, horizontalAngle);
            ms.m_85849_();
        }
    }

    protected void renderItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, (Level)mc.f_91073_, 0);
    }

    protected void renderFlame(PoseStack ms, MultiBufferSource bufferSource, Level level, BlockState blockState, BlazeBurnerBlock.HeatLevel heatLevel, float horizontalAngle) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        VertexConsumer cutout = bufferSource.m_6299_(RenderType.m_110457_());
        SpriteShiftEntry spriteShift = SpriteShiftRegistry.SCULK_FLAME;
        float spriteWidth = spriteShift.getTarget().m_118410_() - spriteShift.getTarget().m_118409_();
        float spriteHeight = spriteShift.getTarget().m_118412_() - spriteShift.getTarget().m_118411_();
        float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
        double vScroll = speed * time;
        vScroll -= Math.floor(vScroll);
        vScroll = vScroll * (double)spriteHeight / 2.0;
        double uScroll = speed * time / 2.0f;
        uScroll -= Math.floor(uScroll);
        uScroll = uScroll * (double)spriteWidth / 2.0;
        SuperByteBuffer flameBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.BLAZE_BURNER_FLAME, (BlockState)blockState);
        flameBuffer.shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll);
        ChamberBottomRenderer.draw(flameBuffer, horizontalAngle, ms, cutout);
    }

    private static void draw(SuperByteBuffer buffer, float horizontalAngle, PoseStack ms, VertexConsumer vc) {
        buffer.rotate(Direction.UP.m_122434_(), horizontalAngle).light(0xF000F0).renderInto(ms, vc);
    }

    public int m_142163_() {
        return 16;
    }
}

