/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.network.forge;

import io.github.mortuusars.scholar.network.PacketDirection;
import io.github.mortuusars.scholar.network.packet.IPacket;
import io.github.mortuusars.scholar.network.packet.server.LecternEditBookC2SP;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketsImpl {
    private static final String PROTOCOL_VERSION = "1";
    private static int id = 0;
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("scholar:packets"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        CHANNEL.messageBuilder(LecternEditBookC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(LecternEditBookC2SP::toBuffer).decoder(LecternEditBookC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
    }

    public static void sendToServer(IPacket packet) {
        CHANNEL.sendToServer((Object)packet);
    }

    public static void sendToClient(IPacket packet, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToAllClients(IPacket packet) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    private static <T extends IPacket> void handlePacket(T packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        packet.handle(PacketsImpl.direction(context.getDirection()), (Player)context.getSender());
    }

    private static PacketDirection direction(NetworkDirection direction) {
        if (direction == NetworkDirection.PLAY_TO_SERVER) {
            return PacketDirection.TO_SERVER;
        }
        if (direction == NetworkDirection.PLAY_TO_CLIENT) {
            return PacketDirection.TO_CLIENT;
        }
        throw new IllegalStateException("Can only convert direction for Client/Server, not others.");
    }
}

