/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BookSigningScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/book_signing.png");
    @NotNull
    protected final Minecraft minecraft;
    @NotNull
    protected final Player player;
    protected final Screen parentScreen;
    protected final int bookColor;
    protected final Consumer<String> onSign;
    protected int textColor;
    protected int selectionColor;
    protected int selectionUnfocusedColor;
    protected int enterBookTitleFontColor;
    protected int byAuthorFontColor;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int textureWidth;
    protected int textureHeight;
    protected TextBox titleTextBox;
    protected ImageButton signButton;
    protected ImageButton cancelSigningButton;
    protected String titleText = "";

    public BookSigningScreen(Screen parentScreen, int bookColor, Consumer<String> onSign) {
        super((Component)Component.m_237119_());
        this.parentScreen = parentScreen;
        this.bookColor = bookColor;
        this.onSign = onSign;
        this.textColor = Config.Client.getColor(Config.Client.TEXT_COLOR);
        this.selectionColor = Config.Client.getColor(Config.Client.SELECTION_COLOR);
        this.selectionUnfocusedColor = Config.Client.getColor(Config.Client.SELECTION_UNFOCUSED_COLOR);
        this.enterBookTitleFontColor = Config.Client.getColor(Config.Client.ENTER_TITLE_COLOR);
        this.byAuthorFontColor = Config.Client.getColor(Config.Client.BY_AUTHOR_COLOR);
        this.minecraft = Minecraft.m_91087_();
        this.player = (Player)Objects.requireNonNull(this.minecraft.f_91074_);
        this.textureWidth = 256;
        this.textureHeight = 256;
    }

    public boolean m_7043_() {
        return (Boolean)Config.Client.SCREEN_PAUSE.get();
    }

    protected void m_7856_() {
        this.imageWidth = 149;
        this.imageHeight = 180;
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.titleTextBox = new TextBox(this.f_96547_, this.leftPos + 21, this.topPos + 71, 108, 9).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setHorizontalAlignment(HorizontalAlignment.CENTER).setOnTextChanged(this::setTitleText).setTextValidator(text -> text != null && this.f_96547_.m_92920_(text, 108) <= 9 && !text.contains("\n"));
        this.m_142416_((GuiEventListener)this.titleTextBox);
        this.signButton = new ImageButton(this.leftPos + 46, this.topPos + 108, 22, 22, 149, 0, 22, TEXTURE, this.textureWidth, this.textureHeight, b -> this.signAlbum(), (Component)Component.m_237115_((String)"book.finalizeButton"));
        MutableComponent component = Component.m_237115_((String)"book.finalizeButton").m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"book.finalizeWarning").m_130940_(ChatFormatting.GRAY));
        this.signButton.m_257544_(Tooltip.m_257550_((Component)component));
        this.m_142416_((GuiEventListener)this.signButton);
        this.cancelSigningButton = new ImageButton(this.leftPos + 83, this.topPos + 108, 22, 22, 171, 0, 22, TEXTURE, this.textureWidth, this.textureHeight, b -> this.cancelSigning(), CommonComponents.f_130656_);
        this.cancelSigningButton.m_257544_(Tooltip.m_257550_((Component)CommonComponents.f_130656_));
        this.m_142416_((GuiEventListener)this.cancelSigningButton);
        this.m_264313_((GuiEventListener)this.titleTextBox);
    }

    protected void setTitleText(FormattedString text) {
        this.titleText = text.toString();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.signButton.f_93623_ = this.canSign();
    }

    protected boolean canSign() {
        return !this.titleText.isBlank();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        this.m_280273_(guiGraphics);
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.m_280398_(TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.textureWidth, this.textureHeight));
        guiGraphics.m_280398_(TEXTURE, this.leftPos, this.topPos + 31, 0, 0.0f, 180.0f, this.imageWidth, 76, this.textureWidth, this.textureHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    protected void renderLabels(GuiGraphics guiGraphics) {
        MutableComponent component = Component.m_237115_((String)"book.editTitle");
        guiGraphics.m_280614_(this.f_96547_, (Component)component, this.leftPos + 74 - this.f_96547_.m_92852_((FormattedText)component) / 2, this.topPos + 51, this.enterBookTitleFontColor, false);
        component = Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{this.player.m_7755_()});
        guiGraphics.m_280614_(this.f_96547_, (Component)component, this.leftPos + 74 - this.f_96547_.m_92852_((FormattedText)component) / 2, this.topPos + 81, this.byAuthorFontColor, false);
    }

    protected void signAlbum() {
        if (this.canSign()) {
            this.onSign.accept(this.titleText.trim());
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Scholar.SoundEvents.BOOK_SIGNED.get(), (float)1.0f, (float)0.8f));
            this.m_7379_();
        }
    }

    protected void cancelSigning() {
        this.minecraft.m_91152_(this.parentScreen);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.cancelSigning();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

