/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.MouseEvent;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderWidget
extends AbstractSliderButton {
    private final Consumer<Double> listener;
    private final Component prefix;
    @Nullable
    private final Component suffix;
    @Nullable
    private final TextMapper textMapper;
    @Nullable
    private final MouseEventListener mouseEventListener;
    private final double min;
    private final double max;
    private final double step;
    private double mappedValue;
    private double previousAppliedValue;

    public SliderWidget(int x, int y, int width, int height, double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull Component prefix, @Nullable Component suffix, @Nullable TextMapper textMapper, @Nullable MouseEventListener mouseEventListener) {
        super(x, y, width, height, prefix, mappedValue);
        this.listener = listener;
        this.prefix = prefix;
        this.suffix = suffix;
        this.textMapper = textMapper;
        this.min = min;
        this.max = max;
        this.step = step;
        this.mappedValue = mappedValue;
        this.mouseEventListener = mouseEventListener;
        this.f_93577_ = this.unmapValue(this.mappedValue);
        this.mapValue();
        this.m_5695_();
        this.previousAppliedValue = this.mappedValue;
    }

    public SliderWidget(double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull Component prefix, @Nullable Component suffix, @Nullable TextMapper textMapper, @Nullable MouseEventListener mouseEventListener) {
        this(0, 0, 150, 20, mappedValue, min, max, step, listener, prefix, suffix, textMapper, mouseEventListener);
    }

    public SliderWidget(double mappedValue, double min, double max, double step, @NotNull Consumer<Double> listener, @NotNull Component prefix, @Nullable Component suffix) {
        this(0, 0, 150, 20, mappedValue, min, max, step, listener, prefix, suffix, null, null);
    }

    protected void m_5695_() {
        Component mappedText;
        MutableComponent label = this.prefix.m_6881_().m_130946_(": ");
        MutableComponent message = null;
        if (this.textMapper != null && (mappedText = this.textMapper.getText(this.mappedValue)) != null) {
            message = label.m_7220_(mappedText);
        }
        if (message == null) {
            String formatted = String.format(this.step % 1.0 == 0.0 ? "%.0f" : "%.2f", this.mappedValue);
            message = label.m_130946_(formatted);
            if (this.suffix != null) {
                message.m_7220_(this.suffix);
            }
        }
        this.m_93666_((Component)message);
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.sendMouseEvent(MouseEvent.CLICK);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.sendMouseEvent(MouseEvent.DRAG);
    }

    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        this.m_93692_(false);
        this.sendMouseEvent(MouseEvent.RELEASE);
    }

    private void sendMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, this.mappedValue);
        }
    }

    protected void m_5697_() {
        this.mapValue();
        if (this.previousAppliedValue != this.mappedValue) {
            this.previousAppliedValue = this.mappedValue;
            this.listener.accept(this.mappedValue);
        }
    }

    private double unmapValue(double mappedValue) {
        double clampedValue = Math.max(this.min, Math.min(mappedValue, this.max));
        return (clampedValue - this.min) / (this.max - this.min);
    }

    private void mapValue() {
        double scaledValue = this.min + this.f_93577_ * (this.max - this.min);
        this.mappedValue = (double)Math.round(scaledValue / this.step) * this.step;
    }

    public double getMappedValue() {
        return this.mappedValue;
    }

    public void applyMappedValue(double translatedValue) {
        this.f_93577_ = this.unmapValue(translatedValue);
        this.m_5697_();
        this.m_5695_();
    }

    public Component getPrefix() {
        return this.prefix;
    }

    @FunctionalInterface
    public static interface TextMapper {
        @Nullable
        public Component getText(double var1);
    }

    @FunctionalInterface
    public static interface MouseEventListener {
        public void onMouseEvent(@NotNull SliderWidget var1, @NotNull MouseEvent var2, double var3);
    }
}

