/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.MouseEvent;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SliderWidget;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorHotspotWidget
extends CursorWidget {
    private static final ResourceLocation BACKGROUND_64 = MinecraftCursor.loc("textures/gui/background_128.png");
    private static final int BACKGROUND_DISABLED = -1358954496;
    private static final int RULER_COLOR = -65536;
    private static final int OVERRIDE_RULER_COLOR = -16711936;
    private final Config.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
    private final CursorAnimationHelper animationHelper;
    private final SliderWidget xhotSlider;
    private final SliderWidget yhotSlider;
    @Nullable
    private final MouseEventListener mouseEventListener;
    private final int maxHotspot;
    private boolean renderRuler = true;
    private boolean dragging = false;

    public CursorHotspotWidget(@NotNull Cursor cursor, @NotNull CursorAnimationHelper animationHelper, @NotNull SliderWidget xhotSlider, @NotNull SliderWidget yhotSlider, @Nullable MouseEventListener mouseEventListener) {
        super(CommonComponents.f_237098_, cursor, BACKGROUND_64);
        this.animationHelper = animationHelper;
        this.xhotSlider = xhotSlider;
        this.yhotSlider = yhotSlider;
        this.mouseEventListener = mouseEventListener;
        this.maxHotspot = SettingsUtil.getMaxHotspot(cursor);
    }

    @Override
    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.f_93623_ = this.xhotSlider.m_142518_() || this.yhotSlider.m_142518_();
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
        super.renderBackground(guiGraphics);
        if (!this.f_93623_) {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.getRight(), this.getBottom(), -1358954496);
        }
    }

    @Override
    protected void renderCursor(@NotNull GuiGraphics guiGraphics, @NotNull Cursor cursor) {
        this.animationHelper.drawSprite(guiGraphics, cursor, this.m_252754_(), this.m_252907_(), this.m_5711_());
    }

    @Override
    protected void renderRuler(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!this.renderRuler) {
            return;
        }
        boolean isGlobalX = this.global.isXHotActive();
        boolean isGlobalY = this.global.isYHotActive();
        int colorX = isGlobalX ? -16711936 : -65536;
        int colorY = isGlobalY ? -16711936 : -65536;
        int xhot = this.clampHotspot(isGlobalX ? this.global.getXHot() : (int)this.xhotSlider.getMappedValue());
        int yhot = this.clampHotspot(isGlobalY ? this.global.getYHot() : (int)this.yhotSlider.getMappedValue());
        float rulerSize = this.getCellSize();
        int xhotX1 = (int)((float)this.m_252754_() + (float)xhot * rulerSize - (float)(!(rulerSize > 1.0f) && xhot == this.maxHotspot ? 1 : 0));
        int xhotX2 = (int)((float)this.m_252754_() + (float)xhot * rulerSize + (xhot > 0 ? rulerSize : Math.max(rulerSize, 2.0f)));
        int yhotY1 = (int)((float)this.m_252907_() + (float)yhot * rulerSize - (float)(!(rulerSize > 1.0f) && yhot == this.maxHotspot ? 1 : 0));
        int yhotY2 = (int)((float)this.m_252907_() + (float)yhot * rulerSize + (yhot > 0 ? rulerSize : Math.max(rulerSize, 2.0f)));
        if (isGlobalX && !isGlobalY || isGlobalX == isGlobalY) {
            guiGraphics.m_280509_(this.m_252754_(), yhotY1, this.getRight(), yhotY2, colorY);
            guiGraphics.m_280509_(xhotX1, this.m_252907_(), xhotX2, this.getBottom(), colorX);
        } else {
            guiGraphics.m_280509_(xhotX1, this.m_252907_(), xhotX2, this.getBottom(), colorX);
            guiGraphics.m_280509_(this.m_252754_(), yhotY1, this.getRight(), yhotY2, colorY);
        }
    }

    public void setRenderRuler(boolean renderRuler) {
        this.renderRuler = renderRuler;
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.dragging = true;
        this.setHotspots(MouseEvent.CLICK, mouseX, mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setHotspots(MouseEvent.DRAG, mouseX, mouseY);
        }
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (this.dragging) {
            this.dragging = false;
            this.setHotspots(MouseEvent.RELEASE, mouseX, mouseY);
            this.m_93692_(false);
        }
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        float cellSize = this.getCellSize();
        int xhot = this.clampHotspot((int)((mouseX - (double)this.m_252754_()) / (double)cellSize));
        int yhot = this.clampHotspot((int)((mouseY - (double)this.m_252907_()) / (double)cellSize));
        if (this.xhotSlider.m_142518_()) {
            this.xhotSlider.applyMappedValue(xhot);
        }
        if (this.yhotSlider.m_142518_()) {
            this.yhotSlider.applyMappedValue(yhot);
        }
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, xhot, yhot);
        }
    }

    private int clampHotspot(int hotspot) {
        return SettingsUtil.clamp(hotspot, 0, this.maxHotspot);
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        if (!this.f_93623_) {
            return CursorType.DEFAULT;
        }
        if (this.dragging) {
            return CursorType.GRABBING;
        }
        return CursorType.POINTER;
    }

    public static interface MouseEventListener {
        public void onMouseEvent(@NotNull CursorHotspotWidget var1, @NotNull MouseEvent var2, int var3, int var4);
    }
}

