/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.widget.ContainerEventHandlerPatch;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractListWidget<E extends Entry>
extends ContainerObjectSelectionList<E>
implements LayoutElement {
    public static final int DEFAULT_HEADER_HEIGHT = -4;
    public static final int SCROLLBAR_WIDTH = 6;
    protected final int rowGap;

    protected AbstractListWidget(Minecraft minecraft, int width, int y, int height, int itemHeight) {
        super(minecraft, width, height, y, y + height, itemHeight);
        this.m_93473_(true, -4);
        this.rowGap = 0;
    }

    protected AbstractListWidget(Minecraft minecraft, int width, int y, int height, int itemHeight, int rowGap) {
        super(minecraft, width, height, y, y + height, itemHeight + rowGap);
        this.m_93473_(true, -4);
        this.rowGap = rowGap;
    }

    protected void m_239227_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int left = this.m_5747_();
        int width = this.m_5759_();
        for (int i = 0; i < this.m_5773_(); ++i) {
            int top = this.m_7610_(i);
            int bottom = this.m_93485_(i);
            if (bottom < this.m_252907_() || top > this.getBottom()) continue;
            this.m_238964_(guiGraphics, mouseX, mouseY, partialTick, i, left, top, width, this.f_93387_);
        }
    }

    public void setClampedScrollAmount(double scrollAmount) {
        this.m_93410_(SettingsUtil.clamp(scrollAmount, 0.0, (double)this.m_93518_()));
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.m_93517_());
    }

    public boolean scrollbarVisible() {
        return this.m_93518_() > 0;
    }

    public int m_93518_() {
        return Math.max(0, super.m_93518_() - this.rowGap);
    }

    protected int m_5756_() {
        return this.scrollbarVisible() ? this.getRight() - 6 : this.getRight();
    }

    public int m_5759_() {
        return this.scrollbarVisible() ? this.m_5711_() - 6 : this.m_5711_();
    }

    public int m_5747_() {
        return this.m_252754_();
    }

    public void setWidth(int width) {
        this.f_93388_ = width;
        this.f_93392_ = this.f_93393_ + this.f_93388_;
    }

    public void setHeight(int height) {
        this.f_93389_ = height;
        this.f_93391_ = this.f_93390_ + this.f_93389_;
        this.clampScrollAmount();
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void m_252865_(int x) {
        this.m_93507_(x);
    }

    public void m_253211_(int y) {
        this.f_93390_ = y;
        this.f_93391_ = this.f_93390_ + this.f_93389_;
    }

    public int m_252754_() {
        return this.f_93393_;
    }

    public int m_252907_() {
        return this.f_93390_;
    }

    public int m_5711_() {
        return this.f_93388_;
    }

    public int m_93694_() {
        return this.f_93389_;
    }

    public int getRight() {
        return this.m_252754_() + this.m_5711_();
    }

    public int getBottom() {
        return this.m_252907_() + this.m_93694_();
    }

    @NotNull
    public ScreenRectangle m_264198_() {
        return super.m_264198_();
    }

    public void m_264134_(@NotNull Consumer<AbstractWidget> visitor) {
    }

    protected abstract class Entry
    extends ContainerObjectSelectionList.Entry<E>
    implements LayoutElement,
    ContainerEventHandlerPatch {
        private final int index;

        protected Entry(int index) {
            this.index = index;
        }

        protected Entry() {
            this(this$0.m_6702_().size());
        }

        public void m_252865_(int i) {
        }

        public void m_253211_(int i) {
        }

        public int m_252754_() {
            return AbstractListWidget.this.m_5747_();
        }

        public int m_252907_() {
            return AbstractListWidget.this.m_7610_(this.index);
        }

        public int m_5711_() {
            return AbstractListWidget.this.m_5759_();
        }

        public int m_93694_() {
            return AbstractListWidget.this.f_93387_ - AbstractListWidget.this.rowGap;
        }

        public int getRight() {
            return this.m_252754_() + this.m_5711_();
        }

        public int getBottom() {
            return this.m_252907_() + this.m_93694_();
        }

        @NotNull
        public ScreenRectangle m_264198_() {
            return super.m_264198_();
        }

        public void m_264134_(@NotNull Consumer<AbstractWidget> visitor) {
        }

        @Override
        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return ContainerEventHandlerPatch.super.m_6348_(mouseX, mouseY, button);
        }
    }
}

