/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.cursor.resolver.CursorTypeResolver;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.OptionsListWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugOptionsPanel
extends AbstractOptionsPanel {
    private static final String CLEAR_CACHE_KEY = "minecraft-cursor.options.debug.cache.clear";
    private static final String ISSUES_LINK = "https://github.com/fishstiz/minecraft-cursor/issues";
    private static final String WIKI_LINK = "https://fishstiz.github.io/minecraft-cursor-wiki/resource-pack/getting-started";
    private static final Component INSPECT_TEXT = Component.m_237115_((String)"minecraft-cursor.options.debug.inspect");
    private static final Component CACHE_TEXT = Component.m_237113_((String)Component.m_237115_((String)"minecraft-cursor.options.debug.cache.clear").getString().replace("\\:.*", ""));
    private static final Component REPORT_ISSUES_TEXT = Component.m_237115_((String)"minecraft-cursor.options.debug.report_issues");
    private static final Component OPEN_WIKI_TEXT = Component.m_237115_((String)"minecraft-cursor.options.debug.open_wiki");
    private OptionsListWidget optionsList;
    private ButtonWidget cacheButton;
    private int previousCacheSize = CursorTypeResolver.INSTANCE.cacheSize();

    public DebugOptionsPanel(Component title) {
        super(title);
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), this.getSpacing());
        this.optionsList.addToggle(CursorTypeResolver.INSTANCE.getInspector().isInspecting(), v -> CursorTypeResolver.INSTANCE.toggleInspector(), this.index(INSPECT_TEXT), null, true);
        this.previousCacheSize = -1;
        this.cacheButton = new ButtonWidget(DebugOptionsPanel.createCacheText(), CursorTypeResolver.INSTANCE::clearCache);
        this.optionsList.addButton(this.cacheButton);
        this.index(CACHE_TEXT);
        this.optionsList.addButton(new ButtonWidget(this.index(OPEN_WIKI_TEXT), ConfirmLinkScreen.m_274609_((String)WIKI_LINK, (Screen)this.getScreen(), (boolean)true)));
        this.optionsList.addButton(new ButtonWidget(this.index(REPORT_ISSUES_TEXT), ConfirmLinkScreen.m_274609_((String)ISSUES_LINK, (Screen)this.getScreen(), (boolean)true)));
        this.optionsList.search(this.getSearch());
        this.addRenderableWidget(this.optionsList);
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.setSize(this.getWidth(), this.computeMaxHeight(y));
            this.optionsList.m_264152_(x, y);
        }
    }

    @Override
    protected void searched(@NotNull String search, @Nullable Component matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.cacheButton != null && CursorTypeResolver.INSTANCE.cacheSize() != this.previousCacheSize) {
            this.previousCacheSize = CursorTypeResolver.INSTANCE.cacheSize();
            this.cacheButton.m_93666_(DebugOptionsPanel.createCacheText());
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private static Component createCacheText() {
        return Component.m_237110_((String)CLEAR_CACHE_KEY, (Object[])new Object[]{CursorTypeResolver.INSTANCE.cacheSize()});
    }
}

