/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogBrowserScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.ContainerEventHandlerPatch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOptionsPanel
extends CatalogBrowserScreen.ContentPanel
implements ContainerEventHandlerPatch {
    protected static final Component ENABLE_TEXT = Component.m_237115_((String)"minecraft-cursor.options.enabled");
    protected static final Component SCALE_TEXT = Component.m_237115_((String)"minecraft-cursor.options.scale");
    protected static final Component GUI_SCALE_TEXT = Component.m_237115_((String)"minecraft-cursor.options.scale.gui");
    protected static final Component XHOT_TEXT = Component.m_237115_((String)"minecraft-cursor.options.xhot");
    protected static final Component YHOT_TEXT = Component.m_237115_((String)"minecraft-cursor.options.yhot");
    protected static final Component HOTSPOT_SUFFIX = Component.m_237115_((String)"minecraft-cursor.options.hotspot-suffix");
    private final Component title;
    private StringWidget titleWidget;

    protected AbstractOptionsPanel(Component title) {
        this.title = AbstractOptionsPanel.withBold(title);
    }

    protected abstract void initContents();

    protected abstract void repositionContents(int var1, int var2);

    @Override
    protected final void init() {
        this.titleWidget = new StringWidget(this.getHeaderWidth(), this.getHeaderHeight(), this.title, this.getFont()).m_267769_();
        this.addRenderableIndexedWidget((AbstractWidget)this.titleWidget);
        this.initContents();
    }

    @Override
    protected final void repositionElements() {
        this.titleWidget.m_93674_(this.getHeaderWidth());
        this.titleWidget.m_264152_(this.getX(), this.getY());
        this.repositionContents(this.getX(), this.getY() + this.titleWidget.m_93694_() + this.getSpacing());
    }

    protected int computeMaxHeight(int top) {
        return Math.max(0, this.getHeight() - (top - this.getY()));
    }

    protected boolean loadCursor(@NotNull Cursor deferredCursor) {
        if (deferredCursor.isLoaded()) {
            throw new IllegalStateException("Cursor is already loaded");
        }
        if (CursorResourceLoader.loadCursorTexture(this.getMinecraft().m_91098_(), deferredCursor)) {
            return true;
        }
        this.getMinecraft().m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)this.getMinecraft(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)Component.m_237115_((String)"resourcePack.load_fail"), (Component)Component.m_237110_((String)"minecraft-cursor.options.global.deferred_loading.fail", (Object[])new Object[]{deferredCursor.getText()})));
        return false;
    }

    protected void refreshWidgets() {
        this.clearWidgets();
        this.init();
    }

    @Override
    protected void added() {
        this.refreshWidgets();
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return ContainerEventHandlerPatch.super.m_6348_(mouseX, mouseY, button);
    }

    private static MutableComponent withBold(Component text) {
        return text.m_6881_().m_130938_(style -> style.m_131136_(Boolean.valueOf(true)));
    }
}

