/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.AnimationData;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.AnimationMode;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.NativeImageUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AnimatedCursor
extends Cursor {
    private AnimationMode mode = AnimationMode.LOOP;
    private Map<Integer, FrameCursor> cursors = new HashMap<Integer, FrameCursor>();
    private List<FrameData> frames = new ArrayList<FrameData>();
    private boolean animated = true;
    private FrameData fallbackFrame;

    AnimatedCursor(CursorType type, Consumer<Cursor> onLoad) {
        super(type, onLoad);
    }

    void loadImage(NativeImage image, Config.Settings settings, AnimationData animation) throws IOException {
        super.loadImage(image, settings);
        int availableFrames = image.m_85084_() / this.getTextureWidth();
        HashMap<Integer, FrameCursor> newCursors = this.createCursors(image, settings, availableFrames);
        List<FrameData> newFrames = this.createFrames(animation, newCursors, availableFrames);
        this.updateState(settings.isAnimated(), animation, newCursors, newFrames);
    }

    private HashMap<Integer, FrameCursor> createCursors(NativeImage image, Config.Settings settings, int availableFrames) throws IOException {
        HashMap<Integer, FrameCursor> newCursors = new HashMap<Integer, FrameCursor>();
        for (int i = 1; i < availableFrames; ++i) {
            newCursors.put(i, this.createCursor(image, settings, i));
        }
        return newCursors;
    }

    private List<FrameData> createFrames(AnimationData animation, Map<Integer, FrameCursor> cursors, int availableFrames) {
        ArrayList<FrameData> newFrames = new ArrayList<FrameData>();
        if (animation.getFrames().isEmpty()) {
            newFrames.add(new FrameData(this, animation.getFrametime()));
            for (int i = 1; i < availableFrames; ++i) {
                newFrames.add(new FrameData(cursors.get(i), animation.getFrametime()));
            }
            return newFrames;
        }
        for (AnimationData.Frame frame : animation.getFrames()) {
            int index = frame.getIndex();
            if (index < 0 || index >= availableFrames) {
                MinecraftCursor.LOGGER.warn("[minecraft-cursor] Sprite does not exist on index {} for cursor type '{}', skipping frame.", (Object)index, (Object)this.getType());
                continue;
            }
            newFrames.add(new FrameData(index == 0 ? this : (Cursor)cursors.get(index), frame.getTime(animation)));
        }
        return newFrames;
    }

    private FrameCursor createCursor(NativeImage image, Config.Settings settings, int index) throws IOException {
        FrameCursor cursor = new FrameCursor(index);
        int size = this.getTextureWidth();
        try (NativeImage cropped = NativeImageUtil.cropImage(image, 0, index * size, size, size);){
            cursor.loadImage(cropped, settings);
        }
        return cursor;
    }

    private void updateState(Boolean animated, AnimationData animation, Map<Integer, FrameCursor> newCursors, List<FrameData> newFrames) {
        this.setAnimated(animated);
        this.fallbackFrame = new FrameData(this, 1);
        this.mode = animation.mode;
        if (this.mode.isReversed()) {
            Collections.reverse(newFrames);
        }
        this.frames = newFrames;
        List<FrameCursor> oldCursors = List.copyOf(this.cursors.values());
        this.cursors = newCursors;
        oldCursors.forEach(Cursor::destroy);
    }

    @Override
    protected void updateImage(double scale, int xhot, int yhot) {
        super.updateImage(scale, xhot, yhot);
        this.applyToFrames(cursor -> cursor.updateImage(scale, xhot, yhot));
    }

    private void applyToFrames(Consumer<Cursor> action) {
        for (Cursor cursor : this.cursors.values()) {
            action.accept(cursor);
        }
    }

    public int getFrameCount() {
        return Math.max(this.frames.size(), 1);
    }

    public FrameData getFrame(int index) {
        try {
            FrameData frame = this.frames.get(index);
            if (!this.isAnimated() || frame.cursor() == null || !frame.cursor().isEnabled()) {
                return this.getFallbackFrame();
            }
            return frame;
        }
        catch (IndexOutOfBoundsException e) {
            return this.getFallbackFrame();
        }
    }

    public FrameData nextFrame(AnimationState state) {
        return this.getFrame(state.next(this));
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(Boolean animated) {
        this.animated = animated == null || animated != false;
    }

    public AnimationMode getMode() {
        return this.mode;
    }

    @Override
    public void apply(Config.Settings settings) {
        this.setAnimated(settings.isAnimated());
        super.apply(settings);
    }

    @Override
    public void enable(boolean enabled) {
        super.enable(enabled);
        this.applyToFrames(cursor -> cursor.enable(enabled));
    }

    @Override
    public void destroy() {
        super.destroy();
        this.applyToFrames(Cursor::destroy);
    }

    @Override
    public void reload() {
        super.reload();
        this.applyToFrames(Cursor::reload);
    }

    public FrameData getFallbackFrame() {
        if (this.fallbackFrame == null) {
            this.fallbackFrame = new FrameData(this, 1);
        }
        return this.fallbackFrame;
    }

    private class FrameCursor
    extends Cursor {
        private final int textureIndex;

        private FrameCursor(int textureIndex) {
            super(AnimatedCursor.this);
            this.textureIndex = textureIndex;
        }

        @Override
        public int getTextureIndex() {
            return this.textureIndex;
        }

        @Override
        public int getTextureWidth() throws IllegalStateException {
            return AnimatedCursor.this.getTextureWidth();
        }

        @Override
        public int getTextureHeight() throws IllegalStateException {
            return AnimatedCursor.this.getTextureHeight();
        }
    }

    public record FrameData(Cursor cursor, int time) {
    }
}

