/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.AnimationData;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.config.ConfigLoader;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorResourceLoader {
    private static final String ANIMATION_TYPE = ".mcmeta";
    private static final ResourceLocation SETTINGS_LOCATION = MinecraftCursor.loc("atlases/cursors.json");
    private static final ResourceLocation DIR = MinecraftCursor.loc("textures/cursors/");
    private static Config.Resource resourceConfig;

    private CursorResourceLoader() {
    }

    public static ResourceLocation getDirectory() {
        return DIR;
    }

    public static void reload(ResourceManager manager) {
        CursorResourceLoader.onReload();
        CursorResourceLoader.loadResourceSettings(manager);
        CursorResourceLoader.loadCursorTextures(manager);
        Minecraft.m_91087_().execute(CursorResourceLoader::onReload);
    }

    static void onReload() {
        CursorManager.INSTANCE.setCurrentCursor(CursorType.DEFAULT);
    }

    private static void loadResourceSettings(ResourceManager manager) {
        CursorResourceLoader.getLayeredSettings(manager.m_213829_(SETTINGS_LOCATION)).ifPresent(config -> {
            if (config.isDifferent(MinecraftCursor.CONFIG)) {
                MinecraftCursor.LOGGER.info("[minecraft-cursor] New resource pack settings detected, updating config...");
                MinecraftCursor.CONFIG.setHash(config.getHash());
                MinecraftCursor.CONFIG.merge((Config.Resource)config);
                MinecraftCursor.CONFIG.getGlobal().setActiveAll(false);
                MinecraftCursor.CONFIG.save();
            }
            resourceConfig = config;
        });
    }

    private static Optional<Config.Resource> getLayeredSettings(List<Resource> configResources) {
        Config.Resource layeredResources = null;
        for (Resource configResource : configResources) {
            try {
                InputStream stream = configResource.m_215507_();
                try {
                    Config.Resource resourceConfig = ConfigLoader.loadResource(stream);
                    if (layeredResources == null) {
                        layeredResources = resourceConfig;
                        continue;
                    }
                    layeredResources.layer(resourceConfig.getAllSettings());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load settings of resource pack '{}'", (Object)configResource.m_215506_());
            }
        }
        return Optional.ofNullable(layeredResources);
    }

    public static boolean isResourceSetting(@NotNull Cursor cursor, @Nullable Config.Settings settings) {
        return SettingsUtil.equalSettings(resourceConfig.getOrCreateSettings(cursor), settings, true);
    }

    public static boolean retoreActiveResourceSettings(@NotNull Cursor cursor) {
        if (cursor.isLoaded() && resourceConfig != null) {
            MinecraftCursor.CONFIG.replaceActiveSettings(resourceConfig, cursor);
            cursor.apply(MinecraftCursor.CONFIG.getGlobal().apply(MinecraftCursor.CONFIG.getOrCreateSettings(cursor)));
            return true;
        }
        MinecraftCursor.LOGGER.error("Failed to apply resource settings for '{}'", (Object)cursor.getTypeKey());
        return false;
    }

    public static void restoreResourceSettings() {
        if (resourceConfig != null) {
            MinecraftCursor.CONFIG.setHash(resourceConfig.getHash());
            MinecraftCursor.CONFIG.merge(resourceConfig);
            for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
                cursor.apply(MinecraftCursor.CONFIG.getGlobal().apply(MinecraftCursor.CONFIG.getOrCreateSettings(cursor)));
            }
        } else {
            MinecraftCursor.LOGGER.error("Failed to apply resource config: Not Found.");
        }
    }

    private static void loadCursorTextures(ResourceManager manager) {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            Config.Settings settings = MinecraftCursor.CONFIG.getOrCreateSettings(cursor);
            if (!MinecraftCursor.CONFIG.isDeferredLoading() || settings.isEnabled()) {
                CursorResourceLoader.loadCursorTexture(manager, cursor, settings);
                continue;
            }
            MinecraftCursor.LOGGER.info("[minecraft-cursor] Skipped loading of disabled cursor '{}'.", (Object)cursor.getTypeKey());
        }
    }

    public static boolean loadCursorTexture(ResourceManager manager, Cursor cursor) {
        return CursorResourceLoader.loadCursorTexture(manager, cursor, MinecraftCursor.CONFIG.getOrCreateSettings(cursor));
    }

    /*
     * Exception decompiling
     */
    private static boolean loadCursorTexture(ResourceManager manager, Cursor cursor, Config.Settings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static AnimationData loadAnimation(ResourceManager manager, ResourceLocation location, Resource cursorResource) {
        Optional animationResource = manager.m_213713_(location.m_266382_(ANIMATION_TYPE));
        if (animationResource.isPresent() && ((Resource)animationResource.get()).m_215506_().equals(cursorResource.m_215506_())) {
            AnimationData animationData;
            block9: {
                InputStream stream = ((Resource)animationResource.get()).m_215507_();
                try {
                    animationData = ConfigLoader.loadAnimationData(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load animation data for '{}'", (Object)location);
                    }
                }
                stream.close();
            }
            return animationData;
        }
        return null;
    }

    private static /* synthetic */ void lambda$loadCursorTexture$1(ResourceLocation location) {
        Minecraft.m_91087_().m_91097_().m_118513_(location);
    }
}

