/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.textureloader;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.RegisterTextureAtlasSpriteLoadersEvent;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.textureloader.LodestoneTextureAtlasSpriteLoader;

public class LodestoneTextureLoader {
    protected static final ColorLerp GRADIENT = (image, x, y, luminosity, s) -> (float)(y % 16) / 16.0f;
    protected static final ColorLerp LUMINOUS_GRADIENT = (image, x, y, luminosity, s) -> ((float)(y % 16) / 16.0f + luminosity / s) / 2.0f;
    protected static final ColorLerp LUMINOUS = (image, x, y, luminosity, s) -> luminosity / s;

    public static void registerTextureLoader(String loaderName, ResourceLocation targetPath, ResourceLocation inputImage, TextureModifier textureModifier, RegisterTextureAtlasSpriteLoadersEvent event) {
        IEventBus busMod = FMLJavaModLoadingContext.get().getModEventBus();
        event.register(loaderName, (ITextureAtlasSpriteLoader)new LodestoneTextureAtlasSpriteLoader(textureModifier));
    }

    public static NativeImage applyGrayscale(NativeImage nativeimage) {
        for (int x = 0; x < nativeimage.m_84982_(); ++x) {
            for (int y = 0; y < nativeimage.m_85084_(); ++y) {
                int pixel = nativeimage.m_84985_(x, y);
                int L = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                nativeimage.m_84988_(x, y, FastColor.ABGR32.m_266248_((int)(pixel >> 24 & 0xFF), (int)L, (int)L, (int)L));
            }
        }
        return nativeimage;
    }

    public static NativeImage applyMultiColorGradient(Easing easing, NativeImage nativeimage, ColorLerp colorLerp, Color ... colors) {
        int luminosity;
        int alpha;
        int pixel;
        int y;
        int x;
        int colorCount = colors.length - 1;
        int lowestLuminosity = 255;
        int highestLuminosity = 0;
        for (x = 0; x < nativeimage.m_84982_(); ++x) {
            for (y = 0; y < nativeimage.m_85084_(); ++y) {
                pixel = nativeimage.m_84985_(x, y);
                alpha = pixel >> 24 & 0xFF;
                if (alpha == 0) continue;
                luminosity = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                if (luminosity < lowestLuminosity) {
                    lowestLuminosity = luminosity;
                }
                if (luminosity <= highestLuminosity) continue;
                highestLuminosity = luminosity;
            }
        }
        for (x = 0; x < nativeimage.m_84982_(); ++x) {
            for (y = 0; y < nativeimage.m_85084_(); ++y) {
                pixel = nativeimage.m_84985_(x, y);
                alpha = pixel >> 24 & 0xFF;
                if (alpha == 0) continue;
                luminosity = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                float pct = (float)luminosity / 255.0f;
                float newLuminosity = Mth.m_14179_((float)pct, (float)lowestLuminosity, (float)highestLuminosity);
                float lerp = 1.0f - colorLerp.lerp(pixel, x, y, newLuminosity, highestLuminosity);
                float colorIndex = (float)(2 * colorCount) * lerp;
                int index = (int)Mth.m_14036_((float)colorIndex, (float)0.0f, (float)colorCount);
                Color color = colors[index];
                Color nextColor = index == colorCount ? color : colors[index + 1];
                Color transition = ColorHelper.colorLerp(easing, colorIndex - (float)((int)colorIndex), color, nextColor);
                nativeimage.m_84988_(x, y, FastColor.ABGR32.m_266248_((int)alpha, (int)transition.getBlue(), (int)transition.getGreen(), (int)transition.getRed()));
            }
        }
        return nativeimage;
    }

    public static interface TextureModifier {
        public NativeImage modifyTexture(NativeImage var1);
    }

    public static interface ColorLerp {
        public float lerp(int var1, int var2, int var3, float var4, float var5);
    }
}

