/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class RenderTypeProvider {
    private final Function<RenderTypeToken, LodestoneRenderType> function;
    private final Function<RenderTypeToken, LodestoneRenderType> memorizedFunction;
    private final HashMap<ShaderUniformHandler, Function<RenderTypeToken, LodestoneRenderType>> uniformHandlerCache;

    public RenderTypeProvider(Function<RenderTypeToken, LodestoneRenderType> function) {
        this.function = function;
        this.memorizedFunction = Util.m_143827_(function);
        this.uniformHandlerCache = new HashMap();
    }

    public LodestoneRenderType apply(RenderTypeToken token) {
        return this.function.apply(token);
    }

    public LodestoneRenderType apply(RenderTypeToken token, ShaderUniformHandler uniformHandler) {
        LodestoneRenderType renderType = this.apply(token);
        return LodestoneRenderTypeRegistry.applyUniformChanges(renderType, uniformHandler);
    }

    public LodestoneRenderType applyAndCache(RenderTypeToken token) {
        return this.memorizedFunction.apply(token);
    }

    public LodestoneRenderType applyAndCache(RenderTypeToken token, ShaderUniformHandler uniformHandler) {
        if (!this.uniformHandlerCache.containsKey(uniformHandler)) {
            this.uniformHandlerCache.put(uniformHandler, Util.m_143827_(this.function));
        }
        LodestoneRenderType renderType = this.uniformHandlerCache.get(uniformHandler).apply(token);
        return LodestoneRenderTypeRegistry.applyUniformChanges(renderType, uniformHandler);
    }

    public LodestoneRenderType applyWithModifier(RenderTypeToken token, Consumer<LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder> modifier) {
        LodestoneRenderTypeRegistry.addRenderTypeModifier(modifier);
        return this.apply(token);
    }

    public LodestoneRenderType applyWithModifier(RenderTypeToken token, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder> modifier) {
        LodestoneRenderTypeRegistry.addRenderTypeModifier(modifier);
        return this.apply(token, uniformHandler);
    }

    public LodestoneRenderType applyWithModifierAndCache(RenderTypeToken token, Consumer<LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder> modifier) {
        LodestoneRenderTypeRegistry.addRenderTypeModifier(modifier);
        return this.applyAndCache(token);
    }

    public LodestoneRenderType applyWithModifierAndCache(RenderTypeToken token, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder> modifier) {
        LodestoneRenderTypeRegistry.addRenderTypeModifier(modifier);
        return this.applyAndCache(token, uniformHandler);
    }
}

