/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailRenderPoint;

public class VFXBuilders {
    public static ScreenVFXBuilder createScreen() {
        return new ScreenVFXBuilder();
    }

    public static WorldVFXBuilder createWorld() {
        return new WorldVFXBuilder();
    }

    public static class ScreenVFXBuilder {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        int light = -1;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 1.0f;
        float y1 = 1.0f;
        int zLevel;
        VertexFormat format;
        Supplier<ShaderInstance> shader = GameRenderer::m_172817_;
        ResourceLocation texture;
        ScreenVertexPlacementSupplier supplier;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();

        public ScreenVFXBuilder setPosTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_252986_(l, x, y, (float)this.zLevel).m_7421_(u, v).m_5752_();
            this.format = DefaultVertexFormat.f_85817_;
            return this;
        }

        public ScreenVFXBuilder setPosColorDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_252986_(l, x, y, (float)this.zLevel).m_85950_(this.r, this.g, this.b, this.a).m_5752_();
            this.format = DefaultVertexFormat.f_85815_;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_252986_(l, x, y, (float)this.zLevel).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_5752_();
            this.format = DefaultVertexFormat.f_85818_;
            return this;
        }

        public ScreenVFXBuilder setPosColorTexLightmapDefaultFormat() {
            this.supplier = (b, l, x, y, u, v) -> b.m_252986_(l, x, y, (float)this.zLevel).m_85950_(this.r, this.g, this.b, this.a).m_7421_(u, v).m_85969_(this.light).m_5752_();
            this.format = DefaultVertexFormat.f_85820_;
            return this;
        }

        public ScreenVFXBuilder setFormat(VertexFormat format) {
            this.format = format;
            return this;
        }

        public ScreenVFXBuilder setShaderTexture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public ScreenVFXBuilder setShader(Supplier<ShaderInstance> shader) {
            this.shader = shader;
            return this;
        }

        public ScreenVFXBuilder setShader(ShaderInstance shader) {
            this.shader = () -> shader;
            return this;
        }

        public ScreenVFXBuilder setVertexSupplier(ScreenVertexPlacementSupplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public ScreenVFXBuilder overrideBufferBuilder(BufferBuilder builder) {
            this.bufferbuilder = builder;
            return this;
        }

        public ScreenVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public ScreenVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public ScreenVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public ScreenVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public ScreenVFXBuilder setColorRaw(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public ScreenVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public ScreenVFXBuilder setPositionWithWidth(float x, float y, float width, float height) {
            return this.setPosition(x, y, x + width, y + height);
        }

        public ScreenVFXBuilder setPosition(float x0, float y0, float x1, float y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            return this;
        }

        public ScreenVFXBuilder setZLevel(int z) {
            this.zLevel = z;
            return this;
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSize) {
            return this.setUVWithWidth(u, v, width, height, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height, float canvasSizeX, float canvasSizeY) {
            return this.setUVWithWidth(u / canvasSizeX, v / canvasSizeY, width / canvasSizeX, height / canvasSizeY);
        }

        public ScreenVFXBuilder setUVWithWidth(float u, float v, float width, float height) {
            this.u0 = u;
            this.v0 = v;
            this.u1 = u + width;
            this.v1 = v + height;
            return this;
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSize) {
            return this.setUV(u0, v0, u1, v1, canvasSize, canvasSize);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1, float canvasSizeX, float canvasSizeY) {
            return this.setUV(u0 / canvasSizeX, v0 / canvasSizeY, u1 / canvasSizeX, v1 / canvasSizeY);
        }

        public ScreenVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public ScreenVFXBuilder blit(PoseStack stack) {
            Matrix4f last = stack.m_85850_().m_252922_();
            RenderSystem.setShader(this.shader);
            if (this.texture != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            }
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y1, this.u0, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y1, this.u1, this.v1);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x1, this.y0, this.u1, this.v0);
            this.supplier.placeVertex(this.bufferbuilder, last, this.x0, this.y0, this.u0, this.v0);
            return this;
        }

        public ScreenVFXBuilder draw(PoseStack stack) {
            if (this.bufferbuilder.m_85732_()) {
                this.bufferbuilder.m_231175_();
            }
            this.begin();
            this.blit(stack);
            this.end();
            return this;
        }

        public ScreenVFXBuilder endAndProceed() {
            return this.end().begin();
        }

        public ScreenVFXBuilder begin() {
            this.bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, this.format);
            return this;
        }

        public ScreenVFXBuilder end() {
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)this.bufferbuilder.m_231175_());
            return this;
        }

        private static interface ScreenVertexPlacementSupplier {
            public void placeVertex(BufferBuilder var1, Matrix4f var2, float var3, float var4, float var5, float var6);
        }
    }

    public static class WorldVFXBuilder {
        protected float r = 1.0f;
        protected float g = 1.0f;
        protected float b = 1.0f;
        protected float a = 1.0f;
        protected int light = 0xF000F0;
        protected float u0 = 0.0f;
        protected float v0 = 0.0f;
        protected float u1 = 1.0f;
        protected float v1 = 1.0f;
        protected MultiBufferSource bufferSource = RenderHandler.DELAYED_RENDER.getTarget();
        protected RenderType renderType;
        protected VertexFormat format;
        protected WorldVertexConsumerActor supplier;
        protected VertexConsumer vertexConsumer;
        protected HashMap<Object, Consumer<WorldVFXBuilder>> modularActors = new HashMap();
        protected int modularActorAddIndex;
        protected int modularActorGetIndex;
        public static final HashMap<VertexFormatElement, WorldVertexConsumerActor> CONSUMER_INFO_MAP = new HashMap();

        public WorldVFXBuilder replaceBufferSource(RenderHandler.LodestoneRenderLayer renderLayer) {
            return this.replaceBufferSource((MultiBufferSource)renderLayer.getTarget());
        }

        public WorldVFXBuilder replaceBufferSource(MultiBufferSource bufferSource) {
            this.bufferSource = bufferSource;
            return this;
        }

        public WorldVFXBuilder setRenderType(RenderType renderType) {
            return this.setRenderTypeRaw(renderType).setFormat(renderType.m_110508_()).setVertexConsumer(this.bufferSource.m_6299_(renderType));
        }

        public WorldVFXBuilder setRenderTypeRaw(RenderType renderType) {
            this.renderType = renderType;
            return this;
        }

        public WorldVFXBuilder setFormat(VertexFormat format) {
            ImmutableList elements = format.m_86023_();
            return this.setFormatRaw(format).setVertexSupplier((consumer, last, builder, x, y, z, u, v) -> {
                for (VertexFormatElement element : elements) {
                    CONSUMER_INFO_MAP.get(element).placeVertex(consumer, last, this, x, y, z, u, v);
                }
                consumer.m_5752_();
            });
        }

        public WorldVFXBuilder setFormatRaw(VertexFormat format) {
            this.format = format;
            return this;
        }

        public WorldVFXBuilder setVertexSupplier(WorldVertexConsumerActor supplier) {
            this.supplier = supplier;
            return this;
        }

        public WorldVFXBuilder setVertexConsumer(VertexConsumer vertexConsumer) {
            this.vertexConsumer = vertexConsumer;
            return this;
        }

        public VertexConsumer getVertexConsumer() {
            if (this.vertexConsumer == null) {
                this.setVertexConsumer(this.bufferSource.m_6299_(this.renderType));
            }
            return this.vertexConsumer;
        }

        public WorldVFXBuilder addModularActor(Consumer<WorldVFXBuilder> actor) {
            return this.addModularActor(this.modularActorAddIndex, actor);
        }

        public WorldVFXBuilder addModularActor(Object key, Consumer<WorldVFXBuilder> actor) {
            if (this.modularActors == null) {
                this.modularActors = new HashMap();
            }
            this.modularActors.put(key, actor);
            return this;
        }

        public Optional<HashMap<Object, Consumer<WorldVFXBuilder>>> getModularActors() {
            return Optional.ofNullable(this.modularActors);
        }

        public Optional<Consumer<WorldVFXBuilder>> getNextModularActor() {
            return Optional.ofNullable(this.modularActors).map(m -> (Consumer)m.get(this.modularActorGetIndex++));
        }

        public MultiBufferSource getBufferSource() {
            return this.bufferSource;
        }

        public RenderType getRenderType() {
            return this.renderType;
        }

        public VertexFormat getFormat() {
            return this.format;
        }

        public WorldVertexConsumerActor getSupplier() {
            return this.supplier;
        }

        public WorldVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public WorldVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public WorldVFXBuilder setColorRaw(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public WorldVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public WorldVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public WorldVFXBuilder renderBeam(Matrix4f last, BlockPos start, BlockPos end, float width) {
            return this.renderBeam(last, VecHelper.getCenterOf((Vec3i)start), VecHelper.getCenterOf((Vec3i)end), width);
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width) {
            Minecraft minecraft = Minecraft.m_91087_();
            Vec3 cameraPosition = minecraft.m_167982_().f_112249_.m_90583_();
            return this.renderBeam(last, start, end, width, cameraPosition);
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width, Consumer<WorldVFXBuilder> consumer) {
            Minecraft minecraft = Minecraft.m_91087_();
            Vec3 cameraPosition = minecraft.m_167982_().f_112249_.m_90583_();
            return this.renderBeam(last, start, end, width, cameraPosition, consumer);
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width, Vec3 cameraPosition) {
            return this.renderBeam(last, start, end, width, cameraPosition, builder -> {});
        }

        public WorldVFXBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width, Vec3 cameraPosition, Consumer<WorldVFXBuilder> consumer) {
            Vec3 delta = end.m_82546_(start);
            Vec3 normal = start.m_82546_(cameraPosition).m_82537_(delta).m_82541_().m_82542_((double)(width / 2.0f), (double)(width / 2.0f), (double)(width / 2.0f));
            Vec3[] positions = new Vec3[]{start.m_82546_(normal), start.m_82549_(normal), end.m_82549_(normal), end.m_82546_(normal)};
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[0].f_82479_, (float)positions[0].f_82480_, (float)positions[0].f_82481_, this.u0, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[1].f_82479_, (float)positions[1].f_82480_, (float)positions[1].f_82481_, this.u1, this.v1);
            consumer.accept(this);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[2].f_82479_, (float)positions[2].f_82480_, (float)positions[2].f_82481_, this.u1, this.v0);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[3].f_82479_, (float)positions[3].f_82480_, (float)positions[3].f_82481_, this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderTrail(PoseStack stack, List<TrailPoint> trailSegments, float width) {
            return this.renderTrail(stack, trailSegments, (Float f) -> Float.valueOf(width), (Float f) -> {});
        }

        public WorldVFXBuilder renderTrail(PoseStack stack, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc) {
            return this.renderTrail(stack, trailSegments, widthFunc, (Float f) -> {});
        }

        public WorldVFXBuilder renderTrail(PoseStack stack, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            return this.renderTrail(stack.m_85850_().m_252922_(), trailSegments, widthFunc, vfxOperator);
        }

        public WorldVFXBuilder renderTrail(Matrix4f pose, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            if (trailSegments.size() < 2) {
                return this;
            }
            List<Vector4f> positions = trailSegments.stream().map(TrailPoint::getMatrixPosition).peek(p -> p.mul((Matrix4fc)pose)).toList();
            int count = trailSegments.size() - 1;
            float increment = 1.0f / (float)count;
            TrailRenderPoint[] points = new TrailRenderPoint[trailSegments.size()];
            for (int i = 1; i < count; ++i) {
                float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
                Vector4f previous = positions.get(i - 1);
                Vector4f current = positions.get(i);
                Vector4f next = positions.get(i + 1);
                points[i] = new TrailRenderPoint(current, RenderHelper.perpendicularTrailPoints(previous, next, width));
            }
            points[0] = new TrailRenderPoint(positions.get(0), RenderHelper.perpendicularTrailPoints(positions.get(0), positions.get(1), widthFunc.apply(Float.valueOf(0.0f)).floatValue()));
            points[count] = new TrailRenderPoint(positions.get(count), RenderHelper.perpendicularTrailPoints(positions.get(count - 1), positions.get(count), widthFunc.apply(Float.valueOf(1.0f)).floatValue()));
            return this.renderPoints(points, this.u0, this.v0, this.u1, this.v1, vfxOperator);
        }

        public WorldVFXBuilder renderPoints(TrailRenderPoint[] points, float u0, float v0, float u1, float v1, Consumer<Float> vfxOperator) {
            int count = points.length - 1;
            float increment = 1.0f / (float)count;
            vfxOperator.accept(Float.valueOf(0.0f));
            points[0].renderStart(this.getVertexConsumer(), this, u0, v0, u1, Mth.m_14179_((float)increment, (float)v0, (float)v1));
            for (int i = 1; i < count; ++i) {
                float current = Mth.m_14179_((float)((float)i * increment), (float)v0, (float)v1);
                vfxOperator.accept(Float.valueOf(current));
                points[i].renderMid(this.getVertexConsumer(), this, u0, current, u1, current);
            }
            vfxOperator.accept(Float.valueOf(1.0f));
            points[count].renderEnd(this.getVertexConsumer(), this, u0, Mth.m_14179_((float)((float)count * increment), (float)v0, (float)v1), u1, v1);
            return this;
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, float size) {
            return this.renderQuad(stack, size, size);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, float width, float height) {
            Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f)};
            return this.renderQuad(stack, positions, width, height);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, Vector3f[] positions, float size) {
            return this.renderQuad(stack, positions, size, size);
        }

        public WorldVFXBuilder renderQuad(PoseStack stack, Vector3f[] positions, float width, float height) {
            for (Vector3f position : positions) {
                position.mul(width, height, width);
            }
            return this.renderQuad(stack.m_85850_().m_252922_(), positions);
        }

        public WorldVFXBuilder renderQuad(Matrix4f last, Vector3f[] positions) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.u0, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.u1, this.v1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.u1, this.v0);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.u0, this.v0);
            return this;
        }

        public WorldVFXBuilder renderSphere(PoseStack stack, float radius, int longs, int lats) {
            Matrix4f last = stack.m_85850_().m_252922_();
            float startU = this.u0;
            float startV = this.v0;
            float endU = (float)Math.PI * 2 * this.u1;
            float endV = (float)Math.PI * this.v1;
            float stepU = (endU - startU) / (float)longs;
            float stepV = (endV - startV) / (float)lats;
            for (int i = 0; i < longs; ++i) {
                for (int j = 0; j < lats; ++j) {
                    float u = (float)i * stepU + startU;
                    float v = (float)j * stepV + startV;
                    float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                    float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                    Vector3f p0 = RenderHelper.parametricSphere(u, v, radius);
                    Vector3f p1 = RenderHelper.parametricSphere(u, vn, radius);
                    Vector3f p2 = RenderHelper.parametricSphere(un, v, radius);
                    Vector3f p3 = RenderHelper.parametricSphere(un, vn, radius);
                    float textureU = u / endU * radius;
                    float textureV = v / endV * radius;
                    float textureUN = un / endU * radius;
                    float textureVN = vn / endV * radius;
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p0.x(), p0.y(), p0.z(), textureU, textureV);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), textureUN, textureV);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), textureU, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p3.x(), p3.y(), p3.z(), textureUN, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), textureU, textureVN);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), textureUN, textureV);
                }
            }
            return this;
        }

        static {
            CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85804_, (consumer, last, builder, x, y, z, u, v) -> {
                if (last == null) {
                    consumer.m_5483_((double)x, (double)y, (double)z);
                } else {
                    consumer.m_252986_(last, x, y, z);
                }
            });
            CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85805_, (consumer, last, builder, x, y, z, u, v) -> consumer.m_85950_(builder.r, builder.g, builder.b, builder.a));
            CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85806_, (consumer, last, builder, x, y, z, u, v) -> consumer.m_7421_(u, v));
            CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85808_, (consumer, last, builder, x, y, z, u, v) -> consumer.m_85969_(builder.light));
        }

        public static interface WorldVertexConsumerActor {
            public void placeVertex(VertexConsumer var1, Matrix4f var2, WorldVFXBuilder var3, float var4, float var5, float var6, float var7, float var8);
        }
    }
}

