/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.providers;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockStateProvider;

public final class LodestoneBlockModelProvider
extends BlockModelProvider {
    final Function<ResourceLocation, LodestoneBlockModelBuilder> factory = l -> new LodestoneBlockModelBuilder(provider, (ResourceLocation)l, existingFileHelper);
    public static final HashMap<String, ResourceLocation> BLOCK_TEXTURE_CACHE = new HashMap();

    public LodestoneBlockModelProvider(LodestoneBlockStateProvider provider, PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return super.m_213708_(cache);
    }

    protected void registerModels() {
    }

    public BlockModelBuilder getBuilder(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = this.extendWithFolder(path.contains(":") ? new ResourceLocation(path) : new ResourceLocation(this.modid, path));
        this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
        return this.generatedModels.computeIfAbsent(outputLoc, this.factory);
    }

    public BlockModelBuilder nested() {
        return this.factory.apply(new ResourceLocation("dummy:dummy"));
    }

    public ResourceLocation extendWithFolder(ResourceLocation rl) {
        if (rl.m_135815_().contains("/")) {
            return rl;
        }
        return new ResourceLocation(rl.m_135827_(), this.folder + "/" + rl.m_135815_());
    }

    private static class LodestoneBlockModelBuilder
    extends BlockModelBuilder {
        public final LodestoneBlockStateProvider provider;

        public LodestoneBlockModelBuilder(LodestoneBlockStateProvider provider, ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
            super(outputLocation, existingFileHelper);
            this.provider = provider;
            BLOCK_TEXTURE_CACHE.clear();
        }

        public BlockModelBuilder texture(String key, ResourceLocation texture) {
            ResourceLocation actualLocation = texture;
            if (!texture.m_135827_().equals("minecraft") && !this.provider.staticTextures.contains(texture)) {
                String actualPath = texture.m_135815_().replace("block/", "block/" + LodestoneBlockStateProvider.getTexturePath());
                actualLocation = new ResourceLocation(texture.m_135827_(), actualPath);
            }
            BLOCK_TEXTURE_CACHE.put(key, actualLocation);
            return (BlockModelBuilder)super.texture(key, actualLocation);
        }
    }
}

