/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.statesmith.BlockStateSmith;
import team.lodestar.lodestone.systems.datagen.statesmith.ModularBlockStateSmith;

public class BlockStateSmithTypes {
    public static ModularBlockStateSmith<Block> CUSTOM_MODEL = new ModularBlockStateSmith<Block>(Block.class, (block, provider, stateFunction, modelFileSupplier) -> stateFunction.act(block, modelFileSupplier.generateModel(block)));
    public static BlockStateSmith<Block> FULL_BLOCK = new BlockStateSmith<Block>(Block.class, (block, provider) -> provider.simpleBlock(block));
    public static BlockStateSmith<Block> GRASS_BLOCK = new BlockStateSmith<Block>(Block.class, (block, provider) -> provider.simpleBlock(block, provider.grassBlockModel(block)));
    public static BlockStateSmith<Block> CROSS_MODEL_BLOCK = new BlockStateSmith<Block>(Block.class, ItemModelSmithTypes.CROSS_MODEL_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        provider.simpleBlock(block, (ModelFile)provider.models().cross(name, provider.getBlockTexture(name)));
    });
    public static BlockStateSmith<Block> TALL_CROSS_MODEL_BLOCK = new BlockStateSmith<Block>(Block.class, ItemModelSmithTypes.AFFIXED_BLOCK_TEXTURE_MODEL.apply("_top"), (block, provider) -> {
        String name = provider.getBlockName(block);
        provider.getVariantBuilder(block).forAllStates(s -> {
            String affix = ((DoubleBlockHalf)s.m_61143_((Property)DoublePlantBlock.f_52858_)).equals((Object)DoubleBlockHalf.LOWER) ? "_bottom" : "_top";
            String affixedName = name + affix;
            return ConfiguredModel.builder().modelFile((ModelFile)provider.models().cross(affixedName, provider.getBlockTexture(affixedName))).build();
        });
    });
    public static BlockStateSmith<Block> LEAVES_BLOCK = new BlockStateSmith<Block>(Block.class, (block, provider) -> provider.simpleBlock(block, provider.leavesBlockModel(block)));
    public static BlockStateSmith<RotatedPillarBlock> LOG_BLOCK = new BlockStateSmith<RotatedPillarBlock>(RotatedPillarBlock.class, (block, provider) -> provider.logBlock((RotatedPillarBlock)block));
    public static BlockStateSmith<RotatedPillarBlock> AXIS_BLOCK = new BlockStateSmith<RotatedPillarBlock>(RotatedPillarBlock.class, (block, provider) -> provider.axisBlock((RotatedPillarBlock)block));
    public static BlockStateSmith<RotatedPillarBlock> WOOD_BLOCK = new BlockStateSmith<RotatedPillarBlock>(RotatedPillarBlock.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("_wood", "") + "_log";
        ResourceLocation logTexture = provider.getBlockTexture(textureName);
        provider.axisBlock((RotatedPillarBlock)block, logTexture, logTexture);
    });
    public static BlockStateSmith<Block> DIRECTIONAL_BLOCK = new BlockStateSmith<Block>(Block.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        ResourceLocation textureName = provider.getBlockTexture(name);
        BlockModelBuilder directionalModel = (BlockModelBuilder)provider.models().cubeColumnHorizontal(name, textureName, provider.extend(textureName, "_top"));
        provider.directionalBlock(block, (ModelFile)directionalModel);
    });
    public static BlockStateSmith<Block> HORIZONTAL_BLOCK = new BlockStateSmith<Block>(Block.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        ResourceLocation textureName = provider.getBlockTexture(name);
        BlockModelBuilder horizontalModel = (BlockModelBuilder)provider.models().cubeAll(name, textureName);
        provider.horizontalBlock(block, (ModelFile)horizontalModel);
    });
    public static BlockStateSmith<StairBlock> STAIRS_BLOCK = new BlockStateSmith<StairBlock>(StairBlock.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("_stairs", "");
        provider.stairsBlock((StairBlock)block, provider.getBlockTexture(textureName));
    });
    public static BlockStateSmith<SlabBlock> SLAB_BLOCK = new BlockStateSmith<SlabBlock>(SlabBlock.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("_slab", "");
        provider.slabBlock((SlabBlock)block, provider.getBlockTexture(textureName), provider.getBlockTexture(textureName));
    });
    public static BlockStateSmith<WallBlock> WALL_BLOCK = new BlockStateSmith<WallBlock>(WallBlock.class, ItemModelSmithTypes.WALL_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("_wall", "");
        provider.wallBlock((WallBlock)block, provider.getBlockTexture(textureName));
    });
    public static BlockStateSmith<FenceBlock> FENCE_BLOCK = new BlockStateSmith<FenceBlock>(FenceBlock.class, ItemModelSmithTypes.FENCE_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("_fence", "");
        provider.fenceBlock((FenceBlock)block, provider.getBlockTexture(textureName));
    });
    public static BlockStateSmith<FenceGateBlock> FENCE_GATE_BLOCK = new BlockStateSmith<FenceGateBlock>(FenceGateBlock.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("_fence_gate", "");
        provider.fenceGateBlock((FenceGateBlock)block, provider.getBlockTexture(textureName));
    });
    public static BlockStateSmith<PressurePlateBlock> PRESSURE_PLATE_BLOCK = new BlockStateSmith<PressurePlateBlock>(PressurePlateBlock.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("_pressure_plate", "");
        provider.pressurePlateBlock((PressurePlateBlock)block, provider.getBlockTexture(textureName));
    });
    public static BlockStateSmith<ButtonBlock> BUTTON_BLOCK = new BlockStateSmith<ButtonBlock>(ButtonBlock.class, ItemModelSmithTypes.BUTTON_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ResourceLocation texture = provider.getBlockTexture(name.replace("_button", ""));
        provider.buttonBlock((ButtonBlock)block, texture);
        ((BlockModelBuilder)provider.models().withExistingParent(name + "_inventory", new ResourceLocation("block/button_inventory"))).texture("texture", texture);
    });
    public static BlockStateSmith<DoorBlock> DOOR_BLOCK = new BlockStateSmith<DoorBlock>(DoorBlock.class, ItemModelSmithTypes.GENERATED_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        provider.doorBlock((DoorBlock)block, provider.getBlockTexture(name + "_bottom"), provider.getBlockTexture(name + "_top"));
    });
    public static BlockStateSmith<TrapDoorBlock> TRAPDOOR_BLOCK = new BlockStateSmith<TrapDoorBlock>(TrapDoorBlock.class, ItemModelSmithTypes.TRAPDOOR_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        provider.trapdoorBlock((TrapDoorBlock)block, provider.getBlockTexture(name), true);
    });
    public static BlockStateSmith<TorchBlock> TORCH_BLOCK = new BlockStateSmith<TorchBlock>(TorchBlock.class, ItemModelSmithTypes.BLOCK_TEXTURE_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ModelBuilder torchModel = provider.models().torch(provider.getBlockName(block), provider.getBlockTexture(name));
        provider.getVariantBuilder(block).forAllStates(arg_0 -> BlockStateSmithTypes.lambda$static$21((ModelFile)torchModel, arg_0));
    });
    public static BlockStateSmith<WallTorchBlock> WALL_TORCH_BLOCK = new BlockStateSmith<WallTorchBlock>(WallTorchBlock.class, ItemModelSmithTypes.NO_MODEL, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replace("wall_", "");
        ModelBuilder torchModel = provider.models().torchWall(provider.getBlockName(block), provider.getBlockTexture(textureName));
        provider.horizontalBlock(block, (ModelFile)torchModel, 90);
    });
    public static BlockStateSmith<SignBlock> WOODEN_SIGN_BLOCK = new BlockStateSmith<SignBlock>(SignBlock.class, ItemModelSmithTypes.GENERATED_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        String particleTextureName = name.replace("_wall", "").replace("_sign", "") + "_planks";
        provider.getVariantBuilder(block).forAllStates(s -> ConfiguredModel.builder().modelFile((ModelFile)provider.models().sign(name, provider.getBlockTexture(particleTextureName))).build());
    });

    private static /* synthetic */ ConfiguredModel[] lambda$static$21(ModelFile torchModel, BlockState s) {
        return ConfiguredModel.builder().modelFile(torchModel).build();
    }
}

