/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.block;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.ThrowawayBlockDataHandler;
import team.lodestar.lodestone.systems.block.LodestoneThrowawayBlockData;
import team.lodestar.lodestone.systems.datagen.LodestoneDatagenBlockData;

public class LodestoneBlockProperties
extends BlockBehaviour.Properties {
    public static LodestoneBlockProperties of() {
        return new LodestoneBlockProperties();
    }

    public static LodestoneBlockProperties copy(BlockBehaviour pBlockBehaviour) {
        LodestoneBlockProperties properties = LodestoneBlockProperties.of();
        properties.f_60888_ = pBlockBehaviour.f_60439_.f_60888_;
        properties.f_60887_ = pBlockBehaviour.f_60439_.f_60887_;
        properties.f_60884_ = pBlockBehaviour.f_60439_.f_60884_;
        properties.f_60890_ = pBlockBehaviour.f_60439_.f_60890_;
        properties.f_60886_ = pBlockBehaviour.f_60439_.f_60886_;
        properties.f_283880_ = pBlockBehaviour.f_60439_.f_283880_;
        properties.f_60885_ = pBlockBehaviour.f_60439_.f_60885_;
        properties.f_60891_ = pBlockBehaviour.f_60439_.f_60891_;
        properties.f_60892_ = pBlockBehaviour.f_60439_.f_60892_;
        properties.f_60903_ = pBlockBehaviour.f_60439_.f_60903_;
        properties.f_60895_ = pBlockBehaviour.f_60439_.f_60895_;
        properties.f_60896_ = pBlockBehaviour.f_60439_.f_60896_;
        properties.f_60889_ = pBlockBehaviour.f_60439_.f_60889_;
        properties.f_60893_ = pBlockBehaviour.f_60439_.f_60893_;
        properties.f_60894_ = pBlockBehaviour.f_60439_.f_60894_;
        properties.f_278123_ = pBlockBehaviour.f_60439_.f_278123_;
        properties.f_279618_ = pBlockBehaviour.f_60439_.f_279618_;
        properties.f_278130_ = pBlockBehaviour.f_60439_.f_278130_;
        properties.f_243850_ = pBlockBehaviour.f_60439_.f_243850_;
        properties.f_279538_ = pBlockBehaviour.f_60439_.f_279538_;
        properties.f_279630_ = pBlockBehaviour.f_60439_.f_279630_;
        properties.f_60897_ = pBlockBehaviour.f_60439_.f_60897_;
        properties.f_60898_ = pBlockBehaviour.f_60439_.f_60898_;
        properties.f_60899_ = pBlockBehaviour.f_60439_.f_60899_;
        properties.f_60900_ = pBlockBehaviour.f_60439_.f_60900_;
        properties.f_60902_ = pBlockBehaviour.f_60439_.f_60902_;
        properties.f_244138_ = pBlockBehaviour.f_60439_.f_244138_;
        properties.f_271289_ = pBlockBehaviour.f_60439_.f_271289_;
        properties.f_60901_ = pBlockBehaviour.f_60439_.f_60901_;
        return properties;
    }

    public LodestoneBlockProperties addThrowawayData(Function<LodestoneThrowawayBlockData, LodestoneThrowawayBlockData> function) {
        ThrowawayBlockDataHandler.THROWAWAY_DATA_CACHE.put(this, function.apply(ThrowawayBlockDataHandler.THROWAWAY_DATA_CACHE.getOrDefault((Object)this, new LodestoneThrowawayBlockData())));
        return this;
    }

    public LodestoneThrowawayBlockData getThrowawayData() {
        return ThrowawayBlockDataHandler.THROWAWAY_DATA_CACHE.getOrDefault((Object)this, LodestoneThrowawayBlockData.EMPTY);
    }

    public LodestoneBlockProperties setCutoutRenderType() {
        return this.setRenderType(() -> RenderType::m_110457_);
    }

    public LodestoneBlockProperties setRenderType(Supplier<Supplier<RenderType>> renderType) {
        if (FMLEnvironment.dist.isClient()) {
            this.addThrowawayData(d -> d.setRenderType(renderType));
        }
        return this;
    }

    public LodestoneBlockProperties addDatagenData(Function<LodestoneDatagenBlockData, LodestoneDatagenBlockData> function) {
        if (DatagenModLoader.isRunningDataGen()) {
            ThrowawayBlockDataHandler.DATAGEN_DATA_CACHE.put(this, function.apply(ThrowawayBlockDataHandler.DATAGEN_DATA_CACHE.getOrDefault((Object)this, new LodestoneDatagenBlockData())));
        }
        return this;
    }

    public LodestoneDatagenBlockData getDatagenData() {
        return ThrowawayBlockDataHandler.DATAGEN_DATA_CACHE.getOrDefault((Object)this, LodestoneDatagenBlockData.EMPTY);
    }

    public LodestoneBlockProperties addTag(TagKey<Block> tag) {
        this.addDatagenData(d -> d.addTag(tag));
        return this;
    }

    @SafeVarargs
    public final LodestoneBlockProperties addTags(TagKey<Block> ... tags) {
        this.addDatagenData(d -> d.addTags(tags));
        return this;
    }

    public LodestoneBlockProperties hasInheritedLoot() {
        this.addDatagenData(LodestoneDatagenBlockData::hasInheritedLoot);
        return this;
    }

    public LodestoneBlockProperties needsPickaxe() {
        this.addDatagenData(LodestoneDatagenBlockData::needsPickaxe);
        return this;
    }

    public LodestoneBlockProperties needsAxe() {
        this.addDatagenData(LodestoneDatagenBlockData::needsAxe);
        return this;
    }

    public LodestoneBlockProperties needsShovel() {
        this.addDatagenData(LodestoneDatagenBlockData::needsShovel);
        return this;
    }

    public LodestoneBlockProperties needsHoe() {
        this.addDatagenData(LodestoneDatagenBlockData::needsHoe);
        return this;
    }

    public LodestoneBlockProperties needsStone() {
        this.addDatagenData(LodestoneDatagenBlockData::needsStone);
        return this;
    }

    public LodestoneBlockProperties needsIron() {
        this.addDatagenData(LodestoneDatagenBlockData::needsIron);
        return this;
    }

    public LodestoneBlockProperties needsDiamond() {
        this.addDatagenData(LodestoneDatagenBlockData::needsDiamond);
        return this;
    }

    @NotNull
    public LodestoneBlockProperties noCollission() {
        return (LodestoneBlockProperties)super.m_60910_();
    }

    @NotNull
    public LodestoneBlockProperties noOcclusion() {
        return (LodestoneBlockProperties)super.m_60955_();
    }

    @NotNull
    public LodestoneBlockProperties friction(float friction) {
        return (LodestoneBlockProperties)super.m_60911_(friction);
    }

    @NotNull
    public LodestoneBlockProperties speedFactor(float factor) {
        return (LodestoneBlockProperties)super.m_60956_(factor);
    }

    @NotNull
    public LodestoneBlockProperties jumpFactor(float factor) {
        return (LodestoneBlockProperties)super.m_60967_(factor);
    }

    @NotNull
    public LodestoneBlockProperties sound(@NotNull SoundType type) {
        return (LodestoneBlockProperties)super.m_60918_(type);
    }

    @NotNull
    public LodestoneBlockProperties lightLevel(@NotNull ToIntFunction<BlockState> lightMap) {
        return (LodestoneBlockProperties)super.m_60953_(lightMap);
    }

    @NotNull
    public LodestoneBlockProperties strength(float destroyTime, float explosionResistance) {
        return (LodestoneBlockProperties)super.m_60913_(destroyTime, explosionResistance);
    }

    @NotNull
    public LodestoneBlockProperties instabreak() {
        return (LodestoneBlockProperties)super.m_60966_();
    }

    @NotNull
    public LodestoneBlockProperties strength(float strength) {
        return (LodestoneBlockProperties)super.m_60978_(strength);
    }

    @NotNull
    public LodestoneBlockProperties randomTicks() {
        return (LodestoneBlockProperties)super.m_60977_();
    }

    @NotNull
    public LodestoneBlockProperties dynamicShape() {
        return (LodestoneBlockProperties)super.m_60988_();
    }

    @NotNull
    public LodestoneBlockProperties noLootTable() {
        return (LodestoneBlockProperties)super.m_222994_();
    }

    @NotNull
    public LodestoneBlockProperties dropsLike(@NotNull Block block) {
        if (DatagenModLoader.isRunningDataGen()) {
            this.getDatagenData().hasInheritedLootTable = true;
        }
        return (LodestoneBlockProperties)super.m_60916_(block);
    }

    @NotNull
    public LodestoneBlockProperties lootFrom(@NotNull Supplier<? extends Block> blockIn) {
        this.hasInheritedLoot();
        return (LodestoneBlockProperties)super.lootFrom(blockIn);
    }

    @NotNull
    public LodestoneBlockProperties air() {
        return (LodestoneBlockProperties)super.m_60996_();
    }

    @NotNull
    public LodestoneBlockProperties isValidSpawn(@NotNull BlockBehaviour.StateArgumentPredicate<EntityType<?>> predicate) {
        return (LodestoneBlockProperties)super.m_60922_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties isRedstoneConductor(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60924_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties isSuffocating(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60960_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties isViewBlocking(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60971_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties hasPostProcess(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60982_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties emissiveRendering(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60991_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties requiresCorrectToolForDrops() {
        return (LodestoneBlockProperties)super.m_60999_();
    }

    @NotNull
    public LodestoneBlockProperties mapColor(@NotNull Function<BlockState, MapColor> p_285406_) {
        return (LodestoneBlockProperties)super.m_284495_(p_285406_);
    }

    @NotNull
    public LodestoneBlockProperties mapColor(@NotNull DyeColor p_285331_) {
        return (LodestoneBlockProperties)super.m_284268_(p_285331_);
    }

    @NotNull
    public LodestoneBlockProperties mapColor(@NotNull MapColor p_285137_) {
        return (LodestoneBlockProperties)super.m_284180_(p_285137_);
    }

    @NotNull
    public LodestoneBlockProperties destroyTime(float destroyTime) {
        return (LodestoneBlockProperties)super.m_155954_(destroyTime);
    }

    @NotNull
    public LodestoneBlockProperties explosionResistance(float explosionResistance) {
        return (LodestoneBlockProperties)super.m_155956_(explosionResistance);
    }

    @NotNull
    public LodestoneBlockProperties ignitedByLava() {
        return (LodestoneBlockProperties)super.m_278183_();
    }

    @NotNull
    public LodestoneBlockProperties liquid() {
        return (LodestoneBlockProperties)super.m_278788_();
    }

    @NotNull
    public LodestoneBlockProperties forceSolidOn() {
        return (LodestoneBlockProperties)super.m_280606_();
    }

    @NotNull
    public LodestoneBlockProperties pushReaction(@NotNull PushReaction p_278265_) {
        return (LodestoneBlockProperties)super.m_278166_(p_278265_);
    }

    @NotNull
    public LodestoneBlockProperties offsetType(@NotNull BlockBehaviour.OffsetType pOffsetType) {
        return (LodestoneBlockProperties)super.m_222979_(pOffsetType);
    }

    @NotNull
    public LodestoneBlockProperties noParticlesOnBreak() {
        return (LodestoneBlockProperties)super.m_246721_();
    }

    @NotNull
    public LodestoneBlockProperties requiredFeatures(FeatureFlag ... pRequiredFeatures) {
        return (LodestoneBlockProperties)super.m_246843_(pRequiredFeatures);
    }

    @NotNull
    public LodestoneBlockProperties instrument(@NotNull NoteBlockInstrument p_282170_) {
        return (LodestoneBlockProperties)super.m_280658_(p_282170_);
    }

    @NotNull
    public LodestoneBlockProperties replaceable() {
        return (LodestoneBlockProperties)super.m_280170_();
    }
}

