/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.network.worldevent;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.registry.common.LodestoneWorldEventTypeRegistry;
import team.lodestar.lodestone.systems.network.LodestoneClientPacket;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class SyncWorldEventPacket
extends LodestoneClientPacket {
    ResourceLocation type;
    public boolean start;
    public CompoundTag eventData;

    public SyncWorldEventPacket(ResourceLocation type, boolean start, CompoundTag eventData) {
        this.type = type;
        this.start = start;
        this.eventData = eventData;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.type);
        buf.writeBoolean(this.start);
        buf.m_130079_(this.eventData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        WorldEventType eventType = LodestoneWorldEventTypeRegistry.EVENT_TYPES.get(this.type);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        WorldEventHandler.addWorldEvent((Level)level, this.start, eventType.createInstance(this.eventData));
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, SyncWorldEventPacket.class, SyncWorldEventPacket::encode, SyncWorldEventPacket::decode, LodestoneClientPacket::handle);
    }

    public static SyncWorldEventPacket decode(FriendlyByteBuf buf) {
        return new SyncWorldEventPacket(buf.m_130281_(), buf.readBoolean(), buf.m_130260_());
    }
}

